package software.amazon.awscdk.services.codebuild.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:37.164Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.cloudformation.ProjectResource")
public class ProjectResource extends software.amazon.awscdk.Resource {
    protected ProjectResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::CodeBuild::Project``.
     * @param parent the ``cdk.Construct`` this ``ProjectResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ProjectResource``
     */
    public ProjectResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(properties).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     * @cloudformation_attribute Arn
     */
    public java.lang.String getProjectArn() {
        return this.jsiiGet("projectArn", java.lang.String.class);
    }

    public java.lang.String getProjectName() {
        return this.jsiiGet("projectName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.codebuild.cloudformation.ProjectResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.codebuild.cloudformation.ProjectResourceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html
     */
    public static interface ArtifactsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.ArtifactsProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-type
         */
        java.lang.Object getType();
        /**
         * ``ProjectResource.ArtifactsProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-type
         */
        void setType(final java.lang.String value);
        /**
         * ``ProjectResource.ArtifactsProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.ArtifactsProperty.ArtifactIdentifier``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-artifactidentifier
         */
        java.lang.Object getArtifactIdentifier();
        /**
         * ``ProjectResource.ArtifactsProperty.ArtifactIdentifier``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-artifactidentifier
         */
        void setArtifactIdentifier(final java.lang.String value);
        /**
         * ``ProjectResource.ArtifactsProperty.ArtifactIdentifier``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-artifactidentifier
         */
        void setArtifactIdentifier(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.ArtifactsProperty.EncryptionDisabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-encryptiondisabled
         */
        java.lang.Object getEncryptionDisabled();
        /**
         * ``ProjectResource.ArtifactsProperty.EncryptionDisabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-encryptiondisabled
         */
        void setEncryptionDisabled(final java.lang.Boolean value);
        /**
         * ``ProjectResource.ArtifactsProperty.EncryptionDisabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-encryptiondisabled
         */
        void setEncryptionDisabled(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.ArtifactsProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-location
         */
        java.lang.Object getLocation();
        /**
         * ``ProjectResource.ArtifactsProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-location
         */
        void setLocation(final java.lang.String value);
        /**
         * ``ProjectResource.ArtifactsProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-location
         */
        void setLocation(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.ArtifactsProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-name
         */
        java.lang.Object getName();
        /**
         * ``ProjectResource.ArtifactsProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-name
         */
        void setName(final java.lang.String value);
        /**
         * ``ProjectResource.ArtifactsProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-name
         */
        void setName(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.ArtifactsProperty.NamespaceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-namespacetype
         */
        java.lang.Object getNamespaceType();
        /**
         * ``ProjectResource.ArtifactsProperty.NamespaceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-namespacetype
         */
        void setNamespaceType(final java.lang.String value);
        /**
         * ``ProjectResource.ArtifactsProperty.NamespaceType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-namespacetype
         */
        void setNamespaceType(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.ArtifactsProperty.OverrideArtifactName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-overrideartifactname
         */
        java.lang.Object getOverrideArtifactName();
        /**
         * ``ProjectResource.ArtifactsProperty.OverrideArtifactName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-overrideartifactname
         */
        void setOverrideArtifactName(final java.lang.Boolean value);
        /**
         * ``ProjectResource.ArtifactsProperty.OverrideArtifactName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-overrideartifactname
         */
        void setOverrideArtifactName(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.ArtifactsProperty.Packaging``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-packaging
         */
        java.lang.Object getPackaging();
        /**
         * ``ProjectResource.ArtifactsProperty.Packaging``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-packaging
         */
        void setPackaging(final java.lang.String value);
        /**
         * ``ProjectResource.ArtifactsProperty.Packaging``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-packaging
         */
        void setPackaging(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.ArtifactsProperty.Path``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-path
         */
        java.lang.Object getPath();
        /**
         * ``ProjectResource.ArtifactsProperty.Path``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-path
         */
        void setPath(final java.lang.String value);
        /**
         * ``ProjectResource.ArtifactsProperty.Path``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-path
         */
        void setPath(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ArtifactsProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ArtifactsProperty}
         */
        final class Builder {
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _artifactIdentifier;
            @javax.annotation.Nullable
            private java.lang.Object _encryptionDisabled;
            @javax.annotation.Nullable
            private java.lang.Object _location;
            @javax.annotation.Nullable
            private java.lang.Object _name;
            @javax.annotation.Nullable
            private java.lang.Object _namespaceType;
            @javax.annotation.Nullable
            private java.lang.Object _overrideArtifactName;
            @javax.annotation.Nullable
            private java.lang.Object _packaging;
            @javax.annotation.Nullable
            private java.lang.Object _path;

            /**
             * Sets the value of Type
             * @param value ``ProjectResource.ArtifactsProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``ProjectResource.ArtifactsProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of ArtifactIdentifier
             * @param value ``ProjectResource.ArtifactsProperty.ArtifactIdentifier``
             * @return {@code this}
             */
            public Builder withArtifactIdentifier(@javax.annotation.Nullable final java.lang.String value) {
                this._artifactIdentifier = value;
                return this;
            }
            /**
             * Sets the value of ArtifactIdentifier
             * @param value ``ProjectResource.ArtifactsProperty.ArtifactIdentifier``
             * @return {@code this}
             */
            public Builder withArtifactIdentifier(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._artifactIdentifier = value;
                return this;
            }
            /**
             * Sets the value of EncryptionDisabled
             * @param value ``ProjectResource.ArtifactsProperty.EncryptionDisabled``
             * @return {@code this}
             */
            public Builder withEncryptionDisabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._encryptionDisabled = value;
                return this;
            }
            /**
             * Sets the value of EncryptionDisabled
             * @param value ``ProjectResource.ArtifactsProperty.EncryptionDisabled``
             * @return {@code this}
             */
            public Builder withEncryptionDisabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._encryptionDisabled = value;
                return this;
            }
            /**
             * Sets the value of Location
             * @param value ``ProjectResource.ArtifactsProperty.Location``
             * @return {@code this}
             */
            public Builder withLocation(@javax.annotation.Nullable final java.lang.String value) {
                this._location = value;
                return this;
            }
            /**
             * Sets the value of Location
             * @param value ``ProjectResource.ArtifactsProperty.Location``
             * @return {@code this}
             */
            public Builder withLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._location = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``ProjectResource.ArtifactsProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``ProjectResource.ArtifactsProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._name = value;
                return this;
            }
            /**
             * Sets the value of NamespaceType
             * @param value ``ProjectResource.ArtifactsProperty.NamespaceType``
             * @return {@code this}
             */
            public Builder withNamespaceType(@javax.annotation.Nullable final java.lang.String value) {
                this._namespaceType = value;
                return this;
            }
            /**
             * Sets the value of NamespaceType
             * @param value ``ProjectResource.ArtifactsProperty.NamespaceType``
             * @return {@code this}
             */
            public Builder withNamespaceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._namespaceType = value;
                return this;
            }
            /**
             * Sets the value of OverrideArtifactName
             * @param value ``ProjectResource.ArtifactsProperty.OverrideArtifactName``
             * @return {@code this}
             */
            public Builder withOverrideArtifactName(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._overrideArtifactName = value;
                return this;
            }
            /**
             * Sets the value of OverrideArtifactName
             * @param value ``ProjectResource.ArtifactsProperty.OverrideArtifactName``
             * @return {@code this}
             */
            public Builder withOverrideArtifactName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._overrideArtifactName = value;
                return this;
            }
            /**
             * Sets the value of Packaging
             * @param value ``ProjectResource.ArtifactsProperty.Packaging``
             * @return {@code this}
             */
            public Builder withPackaging(@javax.annotation.Nullable final java.lang.String value) {
                this._packaging = value;
                return this;
            }
            /**
             * Sets the value of Packaging
             * @param value ``ProjectResource.ArtifactsProperty.Packaging``
             * @return {@code this}
             */
            public Builder withPackaging(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._packaging = value;
                return this;
            }
            /**
             * Sets the value of Path
             * @param value ``ProjectResource.ArtifactsProperty.Path``
             * @return {@code this}
             */
            public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
                this._path = value;
                return this;
            }
            /**
             * Sets the value of Path
             * @param value ``ProjectResource.ArtifactsProperty.Path``
             * @return {@code this}
             */
            public Builder withPath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._path = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ArtifactsProperty build() {
                return new ArtifactsProperty() {
                    private java.lang.Object $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $artifactIdentifier = _artifactIdentifier;
                    @javax.annotation.Nullable
                    private java.lang.Object $encryptionDisabled = _encryptionDisabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $location = _location;
                    @javax.annotation.Nullable
                    private java.lang.Object $name = _name;
                    @javax.annotation.Nullable
                    private java.lang.Object $namespaceType = _namespaceType;
                    @javax.annotation.Nullable
                    private java.lang.Object $overrideArtifactName = _overrideArtifactName;
                    @javax.annotation.Nullable
                    private java.lang.Object $packaging = _packaging;
                    @javax.annotation.Nullable
                    private java.lang.Object $path = _path;

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(final java.lang.String value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(final software.amazon.awscdk.Token value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public java.lang.Object getArtifactIdentifier() {
                        return this.$artifactIdentifier;
                    }

                    @Override
                    public void setArtifactIdentifier(@javax.annotation.Nullable final java.lang.String value) {
                        this.$artifactIdentifier = value;
                    }

                    @Override
                    public void setArtifactIdentifier(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$artifactIdentifier = value;
                    }

                    @Override
                    public java.lang.Object getEncryptionDisabled() {
                        return this.$encryptionDisabled;
                    }

                    @Override
                    public void setEncryptionDisabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$encryptionDisabled = value;
                    }

                    @Override
                    public void setEncryptionDisabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$encryptionDisabled = value;
                    }

                    @Override
                    public java.lang.Object getLocation() {
                        return this.$location;
                    }

                    @Override
                    public void setLocation(@javax.annotation.Nullable final java.lang.String value) {
                        this.$location = value;
                    }

                    @Override
                    public void setLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$location = value;
                    }

                    @Override
                    public java.lang.Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$name = value;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$name = value;
                    }

                    @Override
                    public java.lang.Object getNamespaceType() {
                        return this.$namespaceType;
                    }

                    @Override
                    public void setNamespaceType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$namespaceType = value;
                    }

                    @Override
                    public void setNamespaceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$namespaceType = value;
                    }

                    @Override
                    public java.lang.Object getOverrideArtifactName() {
                        return this.$overrideArtifactName;
                    }

                    @Override
                    public void setOverrideArtifactName(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$overrideArtifactName = value;
                    }

                    @Override
                    public void setOverrideArtifactName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$overrideArtifactName = value;
                    }

                    @Override
                    public java.lang.Object getPackaging() {
                        return this.$packaging;
                    }

                    @Override
                    public void setPackaging(@javax.annotation.Nullable final java.lang.String value) {
                        this.$packaging = value;
                    }

                    @Override
                    public void setPackaging(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$packaging = value;
                    }

                    @Override
                    public java.lang.Object getPath() {
                        return this.$path;
                    }

                    @Override
                    public void setPath(@javax.annotation.Nullable final java.lang.String value) {
                        this.$path = value;
                    }

                    @Override
                    public void setPath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$path = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.ArtifactsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-type
             */
            @Override
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-type
             */
            @Override
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-type
             */
            @Override
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.ArtifactsProperty.ArtifactIdentifier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-artifactidentifier
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getArtifactIdentifier() {
                return this.jsiiGet("artifactIdentifier", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.ArtifactIdentifier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-artifactidentifier
             */
            @Override
            public void setArtifactIdentifier(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("artifactIdentifier", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.ArtifactIdentifier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-artifactidentifier
             */
            @Override
            public void setArtifactIdentifier(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("artifactIdentifier", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.EncryptionDisabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-encryptiondisabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEncryptionDisabled() {
                return this.jsiiGet("encryptionDisabled", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.EncryptionDisabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-encryptiondisabled
             */
            @Override
            public void setEncryptionDisabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("encryptionDisabled", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.EncryptionDisabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-encryptiondisabled
             */
            @Override
            public void setEncryptionDisabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("encryptionDisabled", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-location
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLocation() {
                return this.jsiiGet("location", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-location
             */
            @Override
            public void setLocation(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("location", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-location
             */
            @Override
            public void setLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("location", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.NamespaceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-namespacetype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getNamespaceType() {
                return this.jsiiGet("namespaceType", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.NamespaceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-namespacetype
             */
            @Override
            public void setNamespaceType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("namespaceType", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.NamespaceType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-namespacetype
             */
            @Override
            public void setNamespaceType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("namespaceType", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.OverrideArtifactName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-overrideartifactname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOverrideArtifactName() {
                return this.jsiiGet("overrideArtifactName", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.OverrideArtifactName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-overrideartifactname
             */
            @Override
            public void setOverrideArtifactName(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("overrideArtifactName", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.OverrideArtifactName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-overrideartifactname
             */
            @Override
            public void setOverrideArtifactName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("overrideArtifactName", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Packaging``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-packaging
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPackaging() {
                return this.jsiiGet("packaging", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Packaging``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-packaging
             */
            @Override
            public void setPackaging(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("packaging", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Packaging``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-packaging
             */
            @Override
            public void setPackaging(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("packaging", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-path
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPath() {
                return this.jsiiGet("path", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-path
             */
            @Override
            public void setPath(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("path", value);
            }

            /**
             * ``ProjectResource.ArtifactsProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-path
             */
            @Override
            public void setPath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("path", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html
     */
    public static interface CloudWatchLogsConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.CloudWatchLogsConfigProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-status
         */
        java.lang.Object getStatus();
        /**
         * ``ProjectResource.CloudWatchLogsConfigProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``ProjectResource.CloudWatchLogsConfigProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-status
         */
        void setStatus(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.CloudWatchLogsConfigProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-groupname
         */
        java.lang.Object getGroupName();
        /**
         * ``ProjectResource.CloudWatchLogsConfigProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-groupname
         */
        void setGroupName(final java.lang.String value);
        /**
         * ``ProjectResource.CloudWatchLogsConfigProperty.GroupName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-groupname
         */
        void setGroupName(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.CloudWatchLogsConfigProperty.StreamName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-streamname
         */
        java.lang.Object getStreamName();
        /**
         * ``ProjectResource.CloudWatchLogsConfigProperty.StreamName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-streamname
         */
        void setStreamName(final java.lang.String value);
        /**
         * ``ProjectResource.CloudWatchLogsConfigProperty.StreamName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-streamname
         */
        void setStreamName(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CloudWatchLogsConfigProperty}
         */
        final class Builder {
            private java.lang.Object _status;
            @javax.annotation.Nullable
            private java.lang.Object _groupName;
            @javax.annotation.Nullable
            private java.lang.Object _streamName;

            /**
             * Sets the value of Status
             * @param value ``ProjectResource.CloudWatchLogsConfigProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value ``ProjectResource.CloudWatchLogsConfigProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final software.amazon.awscdk.Token value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of GroupName
             * @param value ``ProjectResource.CloudWatchLogsConfigProperty.GroupName``
             * @return {@code this}
             */
            public Builder withGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this._groupName = value;
                return this;
            }
            /**
             * Sets the value of GroupName
             * @param value ``ProjectResource.CloudWatchLogsConfigProperty.GroupName``
             * @return {@code this}
             */
            public Builder withGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._groupName = value;
                return this;
            }
            /**
             * Sets the value of StreamName
             * @param value ``ProjectResource.CloudWatchLogsConfigProperty.StreamName``
             * @return {@code this}
             */
            public Builder withStreamName(@javax.annotation.Nullable final java.lang.String value) {
                this._streamName = value;
                return this;
            }
            /**
             * Sets the value of StreamName
             * @param value ``ProjectResource.CloudWatchLogsConfigProperty.StreamName``
             * @return {@code this}
             */
            public Builder withStreamName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._streamName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CloudWatchLogsConfigProperty build() {
                return new CloudWatchLogsConfigProperty() {
                    private java.lang.Object $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $groupName = _groupName;
                    @javax.annotation.Nullable
                    private java.lang.Object $streamName = _streamName;

                    @Override
                    public java.lang.Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(final software.amazon.awscdk.Token value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public java.lang.Object getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$groupName = value;
                    }

                    @Override
                    public void setGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$groupName = value;
                    }

                    @Override
                    public java.lang.Object getStreamName() {
                        return this.$streamName;
                    }

                    @Override
                    public void setStreamName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$streamName = value;
                    }

                    @Override
                    public void setStreamName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$streamName = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.CloudWatchLogsConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.CloudWatchLogsConfigProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-status
             */
            @Override
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.CloudWatchLogsConfigProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``ProjectResource.CloudWatchLogsConfigProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-status
             */
            @Override
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``ProjectResource.CloudWatchLogsConfigProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-groupname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getGroupName() {
                return this.jsiiGet("groupName", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.CloudWatchLogsConfigProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-groupname
             */
            @Override
            public void setGroupName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("groupName", value);
            }

            /**
             * ``ProjectResource.CloudWatchLogsConfigProperty.GroupName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-groupname
             */
            @Override
            public void setGroupName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("groupName", value);
            }

            /**
             * ``ProjectResource.CloudWatchLogsConfigProperty.StreamName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-streamname
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getStreamName() {
                return this.jsiiGet("streamName", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.CloudWatchLogsConfigProperty.StreamName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-streamname
             */
            @Override
            public void setStreamName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("streamName", value);
            }

            /**
             * ``ProjectResource.CloudWatchLogsConfigProperty.StreamName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-streamname
             */
            @Override
            public void setStreamName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("streamName", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html
     */
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.EnvironmentProperty.ComputeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-computetype
         */
        java.lang.Object getComputeType();
        /**
         * ``ProjectResource.EnvironmentProperty.ComputeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-computetype
         */
        void setComputeType(final java.lang.String value);
        /**
         * ``ProjectResource.EnvironmentProperty.ComputeType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-computetype
         */
        void setComputeType(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.EnvironmentProperty.Image``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-image
         */
        java.lang.Object getImage();
        /**
         * ``ProjectResource.EnvironmentProperty.Image``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-image
         */
        void setImage(final java.lang.String value);
        /**
         * ``ProjectResource.EnvironmentProperty.Image``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-image
         */
        void setImage(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.EnvironmentProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-type
         */
        java.lang.Object getType();
        /**
         * ``ProjectResource.EnvironmentProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-type
         */
        void setType(final java.lang.String value);
        /**
         * ``ProjectResource.EnvironmentProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.EnvironmentProperty.Certificate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-certificate
         */
        java.lang.Object getCertificate();
        /**
         * ``ProjectResource.EnvironmentProperty.Certificate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-certificate
         */
        void setCertificate(final java.lang.String value);
        /**
         * ``ProjectResource.EnvironmentProperty.Certificate``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-certificate
         */
        void setCertificate(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.EnvironmentProperty.EnvironmentVariables``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-environmentvariables
         */
        java.lang.Object getEnvironmentVariables();
        /**
         * ``ProjectResource.EnvironmentProperty.EnvironmentVariables``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-environmentvariables
         */
        void setEnvironmentVariables(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.EnvironmentProperty.EnvironmentVariables``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-environmentvariables
         */
        void setEnvironmentVariables(final java.util.List<java.lang.Object> value);
        /**
         * ``ProjectResource.EnvironmentProperty.PrivilegedMode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-privilegedmode
         */
        java.lang.Object getPrivilegedMode();
        /**
         * ``ProjectResource.EnvironmentProperty.PrivilegedMode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-privilegedmode
         */
        void setPrivilegedMode(final java.lang.Boolean value);
        /**
         * ``ProjectResource.EnvironmentProperty.PrivilegedMode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-privilegedmode
         */
        void setPrivilegedMode(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EnvironmentProperty}
         */
        final class Builder {
            private java.lang.Object _computeType;
            private java.lang.Object _image;
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _certificate;
            @javax.annotation.Nullable
            private java.lang.Object _environmentVariables;
            @javax.annotation.Nullable
            private java.lang.Object _privilegedMode;

            /**
             * Sets the value of ComputeType
             * @param value ``ProjectResource.EnvironmentProperty.ComputeType``
             * @return {@code this}
             */
            public Builder withComputeType(final java.lang.String value) {
                this._computeType = java.util.Objects.requireNonNull(value, "computeType is required");
                return this;
            }
            /**
             * Sets the value of ComputeType
             * @param value ``ProjectResource.EnvironmentProperty.ComputeType``
             * @return {@code this}
             */
            public Builder withComputeType(final software.amazon.awscdk.Token value) {
                this._computeType = java.util.Objects.requireNonNull(value, "computeType is required");
                return this;
            }
            /**
             * Sets the value of Image
             * @param value ``ProjectResource.EnvironmentProperty.Image``
             * @return {@code this}
             */
            public Builder withImage(final java.lang.String value) {
                this._image = java.util.Objects.requireNonNull(value, "image is required");
                return this;
            }
            /**
             * Sets the value of Image
             * @param value ``ProjectResource.EnvironmentProperty.Image``
             * @return {@code this}
             */
            public Builder withImage(final software.amazon.awscdk.Token value) {
                this._image = java.util.Objects.requireNonNull(value, "image is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``ProjectResource.EnvironmentProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``ProjectResource.EnvironmentProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Certificate
             * @param value ``ProjectResource.EnvironmentProperty.Certificate``
             * @return {@code this}
             */
            public Builder withCertificate(@javax.annotation.Nullable final java.lang.String value) {
                this._certificate = value;
                return this;
            }
            /**
             * Sets the value of Certificate
             * @param value ``ProjectResource.EnvironmentProperty.Certificate``
             * @return {@code this}
             */
            public Builder withCertificate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._certificate = value;
                return this;
            }
            /**
             * Sets the value of EnvironmentVariables
             * @param value ``ProjectResource.EnvironmentProperty.EnvironmentVariables``
             * @return {@code this}
             */
            public Builder withEnvironmentVariables(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._environmentVariables = value;
                return this;
            }
            /**
             * Sets the value of EnvironmentVariables
             * @param value ``ProjectResource.EnvironmentProperty.EnvironmentVariables``
             * @return {@code this}
             */
            public Builder withEnvironmentVariables(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._environmentVariables = value;
                return this;
            }
            /**
             * Sets the value of PrivilegedMode
             * @param value ``ProjectResource.EnvironmentProperty.PrivilegedMode``
             * @return {@code this}
             */
            public Builder withPrivilegedMode(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._privilegedMode = value;
                return this;
            }
            /**
             * Sets the value of PrivilegedMode
             * @param value ``ProjectResource.EnvironmentProperty.PrivilegedMode``
             * @return {@code this}
             */
            public Builder withPrivilegedMode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._privilegedMode = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EnvironmentProperty build() {
                return new EnvironmentProperty() {
                    private java.lang.Object $computeType = java.util.Objects.requireNonNull(_computeType, "computeType is required");
                    private java.lang.Object $image = java.util.Objects.requireNonNull(_image, "image is required");
                    private java.lang.Object $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $certificate = _certificate;
                    @javax.annotation.Nullable
                    private java.lang.Object $environmentVariables = _environmentVariables;
                    @javax.annotation.Nullable
                    private java.lang.Object $privilegedMode = _privilegedMode;

                    @Override
                    public java.lang.Object getComputeType() {
                        return this.$computeType;
                    }

                    @Override
                    public void setComputeType(final java.lang.String value) {
                        this.$computeType = java.util.Objects.requireNonNull(value, "computeType is required");
                    }

                    @Override
                    public void setComputeType(final software.amazon.awscdk.Token value) {
                        this.$computeType = java.util.Objects.requireNonNull(value, "computeType is required");
                    }

                    @Override
                    public java.lang.Object getImage() {
                        return this.$image;
                    }

                    @Override
                    public void setImage(final java.lang.String value) {
                        this.$image = java.util.Objects.requireNonNull(value, "image is required");
                    }

                    @Override
                    public void setImage(final software.amazon.awscdk.Token value) {
                        this.$image = java.util.Objects.requireNonNull(value, "image is required");
                    }

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(final java.lang.String value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(final software.amazon.awscdk.Token value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public java.lang.Object getCertificate() {
                        return this.$certificate;
                    }

                    @Override
                    public void setCertificate(@javax.annotation.Nullable final java.lang.String value) {
                        this.$certificate = value;
                    }

                    @Override
                    public void setCertificate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$certificate = value;
                    }

                    @Override
                    public java.lang.Object getEnvironmentVariables() {
                        return this.$environmentVariables;
                    }

                    @Override
                    public void setEnvironmentVariables(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$environmentVariables = value;
                    }

                    @Override
                    public void setEnvironmentVariables(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$environmentVariables = value;
                    }

                    @Override
                    public java.lang.Object getPrivilegedMode() {
                        return this.$privilegedMode;
                    }

                    @Override
                    public void setPrivilegedMode(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$privilegedMode = value;
                    }

                    @Override
                    public void setPrivilegedMode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$privilegedMode = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.EnvironmentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.ComputeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-computetype
             */
            @Override
            public java.lang.Object getComputeType() {
                return this.jsiiGet("computeType", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.ComputeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-computetype
             */
            @Override
            public void setComputeType(final java.lang.String value) {
                this.jsiiSet("computeType", java.util.Objects.requireNonNull(value, "computeType is required"));
            }

            /**
             * ``ProjectResource.EnvironmentProperty.ComputeType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-computetype
             */
            @Override
            public void setComputeType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("computeType", java.util.Objects.requireNonNull(value, "computeType is required"));
            }

            /**
             * ``ProjectResource.EnvironmentProperty.Image``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-image
             */
            @Override
            public java.lang.Object getImage() {
                return this.jsiiGet("image", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.Image``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-image
             */
            @Override
            public void setImage(final java.lang.String value) {
                this.jsiiSet("image", java.util.Objects.requireNonNull(value, "image is required"));
            }

            /**
             * ``ProjectResource.EnvironmentProperty.Image``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-image
             */
            @Override
            public void setImage(final software.amazon.awscdk.Token value) {
                this.jsiiSet("image", java.util.Objects.requireNonNull(value, "image is required"));
            }

            /**
             * ``ProjectResource.EnvironmentProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-type
             */
            @Override
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-type
             */
            @Override
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.EnvironmentProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-type
             */
            @Override
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.EnvironmentProperty.Certificate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-certificate
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCertificate() {
                return this.jsiiGet("certificate", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.Certificate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-certificate
             */
            @Override
            public void setCertificate(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("certificate", value);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.Certificate``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-certificate
             */
            @Override
            public void setCertificate(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("certificate", value);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.EnvironmentVariables``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-environmentvariables
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnvironmentVariables() {
                return this.jsiiGet("environmentVariables", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.EnvironmentVariables``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-environmentvariables
             */
            @Override
            public void setEnvironmentVariables(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("environmentVariables", value);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.EnvironmentVariables``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-environmentvariables
             */
            @Override
            public void setEnvironmentVariables(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("environmentVariables", value);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.PrivilegedMode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-privilegedmode
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPrivilegedMode() {
                return this.jsiiGet("privilegedMode", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.PrivilegedMode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-privilegedmode
             */
            @Override
            public void setPrivilegedMode(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("privilegedMode", value);
            }

            /**
             * ``ProjectResource.EnvironmentProperty.PrivilegedMode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-privilegedmode
             */
            @Override
            public void setPrivilegedMode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("privilegedMode", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html
     */
    public static interface EnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.EnvironmentVariableProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-name
         */
        java.lang.Object getName();
        /**
         * ``ProjectResource.EnvironmentVariableProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-name
         */
        void setName(final java.lang.String value);
        /**
         * ``ProjectResource.EnvironmentVariableProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-name
         */
        void setName(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.EnvironmentVariableProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-value
         */
        java.lang.Object getValue();
        /**
         * ``ProjectResource.EnvironmentVariableProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``ProjectResource.EnvironmentVariableProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-value
         */
        void setValue(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.EnvironmentVariableProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-type
         */
        java.lang.Object getType();
        /**
         * ``ProjectResource.EnvironmentVariableProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-type
         */
        void setType(final java.lang.String value);
        /**
         * ``ProjectResource.EnvironmentVariableProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-type
         */
        void setType(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link EnvironmentVariableProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EnvironmentVariableProperty}
         */
        final class Builder {
            private java.lang.Object _name;
            private java.lang.Object _value;
            @javax.annotation.Nullable
            private java.lang.Object _type;

            /**
             * Sets the value of Name
             * @param value ``ProjectResource.EnvironmentVariableProperty.Name``
             * @return {@code this}
             */
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``ProjectResource.EnvironmentVariableProperty.Name``
             * @return {@code this}
             */
            public Builder withName(final software.amazon.awscdk.Token value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``ProjectResource.EnvironmentVariableProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final java.lang.String value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``ProjectResource.EnvironmentVariableProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(final software.amazon.awscdk.Token value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``ProjectResource.EnvironmentVariableProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``ProjectResource.EnvironmentVariableProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._type = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EnvironmentVariableProperty build() {
                return new EnvironmentVariableProperty() {
                    private java.lang.Object $name = java.util.Objects.requireNonNull(_name, "name is required");
                    private java.lang.Object $value = java.util.Objects.requireNonNull(_value, "value is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $type = _type;

                    @Override
                    public java.lang.Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(final java.lang.String value) {
                        this.$name = java.util.Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public void setName(final software.amazon.awscdk.Token value) {
                        this.$name = java.util.Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public java.lang.Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(final java.lang.String value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                    @Override
                    public void setValue(final software.amazon.awscdk.Token value) {
                        this.$value = java.util.Objects.requireNonNull(value, "value is required");
                    }

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$type = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.EnvironmentVariableProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.EnvironmentVariableProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-name
             */
            @Override
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.EnvironmentVariableProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-name
             */
            @Override
            public void setName(final java.lang.String value) {
                this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
            }

            /**
             * ``ProjectResource.EnvironmentVariableProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-name
             */
            @Override
            public void setName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
            }

            /**
             * ``ProjectResource.EnvironmentVariableProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-value
             */
            @Override
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.EnvironmentVariableProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-value
             */
            @Override
            public void setValue(final java.lang.String value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }

            /**
             * ``ProjectResource.EnvironmentVariableProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-value
             */
            @Override
            public void setValue(final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", java.util.Objects.requireNonNull(value, "value is required"));
            }

            /**
             * ``ProjectResource.EnvironmentVariableProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.EnvironmentVariableProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``ProjectResource.EnvironmentVariableProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html
     */
    public static interface LogsConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.LogsConfigProperty.CloudWatchLogs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-cloudwatchlogs
         */
        java.lang.Object getCloudWatchLogs();
        /**
         * ``ProjectResource.LogsConfigProperty.CloudWatchLogs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-cloudwatchlogs
         */
        void setCloudWatchLogs(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.LogsConfigProperty.CloudWatchLogs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-cloudwatchlogs
         */
        void setCloudWatchLogs(final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.CloudWatchLogsConfigProperty value);
        /**
         * ``ProjectResource.LogsConfigProperty.S3Logs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-s3logs
         */
        java.lang.Object getS3Logs();
        /**
         * ``ProjectResource.LogsConfigProperty.S3Logs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-s3logs
         */
        void setS3Logs(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.LogsConfigProperty.S3Logs``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-s3logs
         */
        void setS3Logs(final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.S3LogsConfigProperty value);

        /**
         * @return a {@link Builder} of {@link LogsConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LogsConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _cloudWatchLogs;
            @javax.annotation.Nullable
            private java.lang.Object _s3Logs;

            /**
             * Sets the value of CloudWatchLogs
             * @param value ``ProjectResource.LogsConfigProperty.CloudWatchLogs``
             * @return {@code this}
             */
            public Builder withCloudWatchLogs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._cloudWatchLogs = value;
                return this;
            }
            /**
             * Sets the value of CloudWatchLogs
             * @param value ``ProjectResource.LogsConfigProperty.CloudWatchLogs``
             * @return {@code this}
             */
            public Builder withCloudWatchLogs(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.CloudWatchLogsConfigProperty value) {
                this._cloudWatchLogs = value;
                return this;
            }
            /**
             * Sets the value of S3Logs
             * @param value ``ProjectResource.LogsConfigProperty.S3Logs``
             * @return {@code this}
             */
            public Builder withS3Logs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._s3Logs = value;
                return this;
            }
            /**
             * Sets the value of S3Logs
             * @param value ``ProjectResource.LogsConfigProperty.S3Logs``
             * @return {@code this}
             */
            public Builder withS3Logs(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.S3LogsConfigProperty value) {
                this._s3Logs = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LogsConfigProperty build() {
                return new LogsConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $cloudWatchLogs = _cloudWatchLogs;
                    @javax.annotation.Nullable
                    private java.lang.Object $s3Logs = _s3Logs;

                    @Override
                    public java.lang.Object getCloudWatchLogs() {
                        return this.$cloudWatchLogs;
                    }

                    @Override
                    public void setCloudWatchLogs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$cloudWatchLogs = value;
                    }

                    @Override
                    public void setCloudWatchLogs(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.CloudWatchLogsConfigProperty value) {
                        this.$cloudWatchLogs = value;
                    }

                    @Override
                    public java.lang.Object getS3Logs() {
                        return this.$s3Logs;
                    }

                    @Override
                    public void setS3Logs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$s3Logs = value;
                    }

                    @Override
                    public void setS3Logs(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.S3LogsConfigProperty value) {
                        this.$s3Logs = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.LogsConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.LogsConfigProperty.CloudWatchLogs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-cloudwatchlogs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCloudWatchLogs() {
                return this.jsiiGet("cloudWatchLogs", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.LogsConfigProperty.CloudWatchLogs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-cloudwatchlogs
             */
            @Override
            public void setCloudWatchLogs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cloudWatchLogs", value);
            }

            /**
             * ``ProjectResource.LogsConfigProperty.CloudWatchLogs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-cloudwatchlogs
             */
            @Override
            public void setCloudWatchLogs(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.CloudWatchLogsConfigProperty value) {
                this.jsiiSet("cloudWatchLogs", value);
            }

            /**
             * ``ProjectResource.LogsConfigProperty.S3Logs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-s3logs
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getS3Logs() {
                return this.jsiiGet("s3Logs", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.LogsConfigProperty.S3Logs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-s3logs
             */
            @Override
            public void setS3Logs(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Logs", value);
            }

            /**
             * ``ProjectResource.LogsConfigProperty.S3Logs``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-s3logs
             */
            @Override
            public void setS3Logs(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.S3LogsConfigProperty value) {
                this.jsiiSet("s3Logs", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html
     */
    public static interface ProjectCacheProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.ProjectCacheProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-type
         */
        java.lang.Object getType();
        /**
         * ``ProjectResource.ProjectCacheProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-type
         */
        void setType(final java.lang.String value);
        /**
         * ``ProjectResource.ProjectCacheProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.ProjectCacheProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-location
         */
        java.lang.Object getLocation();
        /**
         * ``ProjectResource.ProjectCacheProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-location
         */
        void setLocation(final java.lang.String value);
        /**
         * ``ProjectResource.ProjectCacheProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-location
         */
        void setLocation(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ProjectCacheProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProjectCacheProperty}
         */
        final class Builder {
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _location;

            /**
             * Sets the value of Type
             * @param value ``ProjectResource.ProjectCacheProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``ProjectResource.ProjectCacheProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Location
             * @param value ``ProjectResource.ProjectCacheProperty.Location``
             * @return {@code this}
             */
            public Builder withLocation(@javax.annotation.Nullable final java.lang.String value) {
                this._location = value;
                return this;
            }
            /**
             * Sets the value of Location
             * @param value ``ProjectResource.ProjectCacheProperty.Location``
             * @return {@code this}
             */
            public Builder withLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._location = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectCacheProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProjectCacheProperty build() {
                return new ProjectCacheProperty() {
                    private java.lang.Object $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $location = _location;

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(final java.lang.String value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(final software.amazon.awscdk.Token value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public java.lang.Object getLocation() {
                        return this.$location;
                    }

                    @Override
                    public void setLocation(@javax.annotation.Nullable final java.lang.String value) {
                        this.$location = value;
                    }

                    @Override
                    public void setLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$location = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.ProjectCacheProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.ProjectCacheProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-type
             */
            @Override
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ProjectCacheProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-type
             */
            @Override
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.ProjectCacheProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-type
             */
            @Override
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.ProjectCacheProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-location
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLocation() {
                return this.jsiiGet("location", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ProjectCacheProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-location
             */
            @Override
            public void setLocation(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("location", value);
            }

            /**
             * ``ProjectResource.ProjectCacheProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-location
             */
            @Override
            public void setLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("location", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html
     */
    public static interface ProjectTriggersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.ProjectTriggersProperty.Webhook``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-webhook
         */
        java.lang.Object getWebhook();
        /**
         * ``ProjectResource.ProjectTriggersProperty.Webhook``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-webhook
         */
        void setWebhook(final java.lang.Boolean value);
        /**
         * ``ProjectResource.ProjectTriggersProperty.Webhook``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-webhook
         */
        void setWebhook(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ProjectTriggersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ProjectTriggersProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _webhook;

            /**
             * Sets the value of Webhook
             * @param value ``ProjectResource.ProjectTriggersProperty.Webhook``
             * @return {@code this}
             */
            public Builder withWebhook(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._webhook = value;
                return this;
            }
            /**
             * Sets the value of Webhook
             * @param value ``ProjectResource.ProjectTriggersProperty.Webhook``
             * @return {@code this}
             */
            public Builder withWebhook(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._webhook = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectTriggersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ProjectTriggersProperty build() {
                return new ProjectTriggersProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $webhook = _webhook;

                    @Override
                    public java.lang.Object getWebhook() {
                        return this.$webhook;
                    }

                    @Override
                    public void setWebhook(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$webhook = value;
                    }

                    @Override
                    public void setWebhook(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$webhook = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.ProjectTriggersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.ProjectTriggersProperty.Webhook``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-webhook
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getWebhook() {
                return this.jsiiGet("webhook", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.ProjectTriggersProperty.Webhook``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-webhook
             */
            @Override
            public void setWebhook(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("webhook", value);
            }

            /**
             * ``ProjectResource.ProjectTriggersProperty.Webhook``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-webhook
             */
            @Override
            public void setWebhook(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("webhook", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html
     */
    public static interface S3LogsConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.S3LogsConfigProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-status
         */
        java.lang.Object getStatus();
        /**
         * ``ProjectResource.S3LogsConfigProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-status
         */
        void setStatus(final java.lang.String value);
        /**
         * ``ProjectResource.S3LogsConfigProperty.Status``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-status
         */
        void setStatus(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.S3LogsConfigProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-location
         */
        java.lang.Object getLocation();
        /**
         * ``ProjectResource.S3LogsConfigProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-location
         */
        void setLocation(final java.lang.String value);
        /**
         * ``ProjectResource.S3LogsConfigProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-location
         */
        void setLocation(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link S3LogsConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3LogsConfigProperty}
         */
        final class Builder {
            private java.lang.Object _status;
            @javax.annotation.Nullable
            private java.lang.Object _location;

            /**
             * Sets the value of Status
             * @param value ``ProjectResource.S3LogsConfigProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final java.lang.String value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Status
             * @param value ``ProjectResource.S3LogsConfigProperty.Status``
             * @return {@code this}
             */
            public Builder withStatus(final software.amazon.awscdk.Token value) {
                this._status = java.util.Objects.requireNonNull(value, "status is required");
                return this;
            }
            /**
             * Sets the value of Location
             * @param value ``ProjectResource.S3LogsConfigProperty.Location``
             * @return {@code this}
             */
            public Builder withLocation(@javax.annotation.Nullable final java.lang.String value) {
                this._location = value;
                return this;
            }
            /**
             * Sets the value of Location
             * @param value ``ProjectResource.S3LogsConfigProperty.Location``
             * @return {@code this}
             */
            public Builder withLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._location = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LogsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3LogsConfigProperty build() {
                return new S3LogsConfigProperty() {
                    private java.lang.Object $status = java.util.Objects.requireNonNull(_status, "status is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $location = _location;

                    @Override
                    public java.lang.Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(final java.lang.String value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(final software.amazon.awscdk.Token value) {
                        this.$status = java.util.Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public java.lang.Object getLocation() {
                        return this.$location;
                    }

                    @Override
                    public void setLocation(@javax.annotation.Nullable final java.lang.String value) {
                        this.$location = value;
                    }

                    @Override
                    public void setLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$location = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.S3LogsConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.S3LogsConfigProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-status
             */
            @Override
            public java.lang.Object getStatus() {
                return this.jsiiGet("status", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.S3LogsConfigProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-status
             */
            @Override
            public void setStatus(final java.lang.String value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``ProjectResource.S3LogsConfigProperty.Status``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-status
             */
            @Override
            public void setStatus(final software.amazon.awscdk.Token value) {
                this.jsiiSet("status", java.util.Objects.requireNonNull(value, "status is required"));
            }

            /**
             * ``ProjectResource.S3LogsConfigProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-location
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLocation() {
                return this.jsiiGet("location", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.S3LogsConfigProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-location
             */
            @Override
            public void setLocation(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("location", value);
            }

            /**
             * ``ProjectResource.S3LogsConfigProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-location
             */
            @Override
            public void setLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("location", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html
     */
    public static interface SourceAuthProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.SourceAuthProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-type
         */
        java.lang.Object getType();
        /**
         * ``ProjectResource.SourceAuthProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-type
         */
        void setType(final java.lang.String value);
        /**
         * ``ProjectResource.SourceAuthProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.SourceAuthProperty.Resource``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-resource
         */
        java.lang.Object getResource();
        /**
         * ``ProjectResource.SourceAuthProperty.Resource``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-resource
         */
        void setResource(final java.lang.String value);
        /**
         * ``ProjectResource.SourceAuthProperty.Resource``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-resource
         */
        void setResource(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link SourceAuthProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceAuthProperty}
         */
        final class Builder {
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _resource;

            /**
             * Sets the value of Type
             * @param value ``ProjectResource.SourceAuthProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``ProjectResource.SourceAuthProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Resource
             * @param value ``ProjectResource.SourceAuthProperty.Resource``
             * @return {@code this}
             */
            public Builder withResource(@javax.annotation.Nullable final java.lang.String value) {
                this._resource = value;
                return this;
            }
            /**
             * Sets the value of Resource
             * @param value ``ProjectResource.SourceAuthProperty.Resource``
             * @return {@code this}
             */
            public Builder withResource(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._resource = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceAuthProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SourceAuthProperty build() {
                return new SourceAuthProperty() {
                    private java.lang.Object $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $resource = _resource;

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(final java.lang.String value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(final software.amazon.awscdk.Token value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public java.lang.Object getResource() {
                        return this.$resource;
                    }

                    @Override
                    public void setResource(@javax.annotation.Nullable final java.lang.String value) {
                        this.$resource = value;
                    }

                    @Override
                    public void setResource(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$resource = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.SourceAuthProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.SourceAuthProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-type
             */
            @Override
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceAuthProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-type
             */
            @Override
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.SourceAuthProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-type
             */
            @Override
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.SourceAuthProperty.Resource``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-resource
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getResource() {
                return this.jsiiGet("resource", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceAuthProperty.Resource``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-resource
             */
            @Override
            public void setResource(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resource", value);
            }

            /**
             * ``ProjectResource.SourceAuthProperty.Resource``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-resource
             */
            @Override
            public void setResource(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("resource", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html
     */
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.SourceProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-type
         */
        java.lang.Object getType();
        /**
         * ``ProjectResource.SourceProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-type
         */
        void setType(final java.lang.String value);
        /**
         * ``ProjectResource.SourceProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.SourceProperty.Auth``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-auth
         */
        java.lang.Object getAuth();
        /**
         * ``ProjectResource.SourceProperty.Auth``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-auth
         */
        void setAuth(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.SourceProperty.Auth``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-auth
         */
        void setAuth(final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.SourceAuthProperty value);
        /**
         * ``ProjectResource.SourceProperty.BuildSpec``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildspec
         */
        java.lang.Object getBuildSpec();
        /**
         * ``ProjectResource.SourceProperty.BuildSpec``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildspec
         */
        void setBuildSpec(final java.lang.String value);
        /**
         * ``ProjectResource.SourceProperty.BuildSpec``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildspec
         */
        void setBuildSpec(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.SourceProperty.GitCloneDepth``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitclonedepth
         */
        java.lang.Object getGitCloneDepth();
        /**
         * ``ProjectResource.SourceProperty.GitCloneDepth``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitclonedepth
         */
        void setGitCloneDepth(final java.lang.Number value);
        /**
         * ``ProjectResource.SourceProperty.GitCloneDepth``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitclonedepth
         */
        void setGitCloneDepth(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.SourceProperty.InsecureSsl``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-insecuressl
         */
        java.lang.Object getInsecureSsl();
        /**
         * ``ProjectResource.SourceProperty.InsecureSsl``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-insecuressl
         */
        void setInsecureSsl(final java.lang.Boolean value);
        /**
         * ``ProjectResource.SourceProperty.InsecureSsl``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-insecuressl
         */
        void setInsecureSsl(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.SourceProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-location
         */
        java.lang.Object getLocation();
        /**
         * ``ProjectResource.SourceProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-location
         */
        void setLocation(final java.lang.String value);
        /**
         * ``ProjectResource.SourceProperty.Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-location
         */
        void setLocation(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.SourceProperty.ReportBuildStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-reportbuildstatus
         */
        java.lang.Object getReportBuildStatus();
        /**
         * ``ProjectResource.SourceProperty.ReportBuildStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-reportbuildstatus
         */
        void setReportBuildStatus(final java.lang.Boolean value);
        /**
         * ``ProjectResource.SourceProperty.ReportBuildStatus``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-reportbuildstatus
         */
        void setReportBuildStatus(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.SourceProperty.SourceIdentifier``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-sourceidentifier
         */
        java.lang.Object getSourceIdentifier();
        /**
         * ``ProjectResource.SourceProperty.SourceIdentifier``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-sourceidentifier
         */
        void setSourceIdentifier(final java.lang.String value);
        /**
         * ``ProjectResource.SourceProperty.SourceIdentifier``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-sourceidentifier
         */
        void setSourceIdentifier(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceProperty}
         */
        final class Builder {
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _auth;
            @javax.annotation.Nullable
            private java.lang.Object _buildSpec;
            @javax.annotation.Nullable
            private java.lang.Object _gitCloneDepth;
            @javax.annotation.Nullable
            private java.lang.Object _insecureSsl;
            @javax.annotation.Nullable
            private java.lang.Object _location;
            @javax.annotation.Nullable
            private java.lang.Object _reportBuildStatus;
            @javax.annotation.Nullable
            private java.lang.Object _sourceIdentifier;

            /**
             * Sets the value of Type
             * @param value ``ProjectResource.SourceProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``ProjectResource.SourceProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Auth
             * @param value ``ProjectResource.SourceProperty.Auth``
             * @return {@code this}
             */
            public Builder withAuth(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._auth = value;
                return this;
            }
            /**
             * Sets the value of Auth
             * @param value ``ProjectResource.SourceProperty.Auth``
             * @return {@code this}
             */
            public Builder withAuth(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.SourceAuthProperty value) {
                this._auth = value;
                return this;
            }
            /**
             * Sets the value of BuildSpec
             * @param value ``ProjectResource.SourceProperty.BuildSpec``
             * @return {@code this}
             */
            public Builder withBuildSpec(@javax.annotation.Nullable final java.lang.String value) {
                this._buildSpec = value;
                return this;
            }
            /**
             * Sets the value of BuildSpec
             * @param value ``ProjectResource.SourceProperty.BuildSpec``
             * @return {@code this}
             */
            public Builder withBuildSpec(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._buildSpec = value;
                return this;
            }
            /**
             * Sets the value of GitCloneDepth
             * @param value ``ProjectResource.SourceProperty.GitCloneDepth``
             * @return {@code this}
             */
            public Builder withGitCloneDepth(@javax.annotation.Nullable final java.lang.Number value) {
                this._gitCloneDepth = value;
                return this;
            }
            /**
             * Sets the value of GitCloneDepth
             * @param value ``ProjectResource.SourceProperty.GitCloneDepth``
             * @return {@code this}
             */
            public Builder withGitCloneDepth(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._gitCloneDepth = value;
                return this;
            }
            /**
             * Sets the value of InsecureSsl
             * @param value ``ProjectResource.SourceProperty.InsecureSsl``
             * @return {@code this}
             */
            public Builder withInsecureSsl(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._insecureSsl = value;
                return this;
            }
            /**
             * Sets the value of InsecureSsl
             * @param value ``ProjectResource.SourceProperty.InsecureSsl``
             * @return {@code this}
             */
            public Builder withInsecureSsl(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._insecureSsl = value;
                return this;
            }
            /**
             * Sets the value of Location
             * @param value ``ProjectResource.SourceProperty.Location``
             * @return {@code this}
             */
            public Builder withLocation(@javax.annotation.Nullable final java.lang.String value) {
                this._location = value;
                return this;
            }
            /**
             * Sets the value of Location
             * @param value ``ProjectResource.SourceProperty.Location``
             * @return {@code this}
             */
            public Builder withLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._location = value;
                return this;
            }
            /**
             * Sets the value of ReportBuildStatus
             * @param value ``ProjectResource.SourceProperty.ReportBuildStatus``
             * @return {@code this}
             */
            public Builder withReportBuildStatus(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._reportBuildStatus = value;
                return this;
            }
            /**
             * Sets the value of ReportBuildStatus
             * @param value ``ProjectResource.SourceProperty.ReportBuildStatus``
             * @return {@code this}
             */
            public Builder withReportBuildStatus(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._reportBuildStatus = value;
                return this;
            }
            /**
             * Sets the value of SourceIdentifier
             * @param value ``ProjectResource.SourceProperty.SourceIdentifier``
             * @return {@code this}
             */
            public Builder withSourceIdentifier(@javax.annotation.Nullable final java.lang.String value) {
                this._sourceIdentifier = value;
                return this;
            }
            /**
             * Sets the value of SourceIdentifier
             * @param value ``ProjectResource.SourceProperty.SourceIdentifier``
             * @return {@code this}
             */
            public Builder withSourceIdentifier(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sourceIdentifier = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SourceProperty build() {
                return new SourceProperty() {
                    private java.lang.Object $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $auth = _auth;
                    @javax.annotation.Nullable
                    private java.lang.Object $buildSpec = _buildSpec;
                    @javax.annotation.Nullable
                    private java.lang.Object $gitCloneDepth = _gitCloneDepth;
                    @javax.annotation.Nullable
                    private java.lang.Object $insecureSsl = _insecureSsl;
                    @javax.annotation.Nullable
                    private java.lang.Object $location = _location;
                    @javax.annotation.Nullable
                    private java.lang.Object $reportBuildStatus = _reportBuildStatus;
                    @javax.annotation.Nullable
                    private java.lang.Object $sourceIdentifier = _sourceIdentifier;

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(final java.lang.String value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(final software.amazon.awscdk.Token value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public java.lang.Object getAuth() {
                        return this.$auth;
                    }

                    @Override
                    public void setAuth(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$auth = value;
                    }

                    @Override
                    public void setAuth(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.SourceAuthProperty value) {
                        this.$auth = value;
                    }

                    @Override
                    public java.lang.Object getBuildSpec() {
                        return this.$buildSpec;
                    }

                    @Override
                    public void setBuildSpec(@javax.annotation.Nullable final java.lang.String value) {
                        this.$buildSpec = value;
                    }

                    @Override
                    public void setBuildSpec(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$buildSpec = value;
                    }

                    @Override
                    public java.lang.Object getGitCloneDepth() {
                        return this.$gitCloneDepth;
                    }

                    @Override
                    public void setGitCloneDepth(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$gitCloneDepth = value;
                    }

                    @Override
                    public void setGitCloneDepth(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$gitCloneDepth = value;
                    }

                    @Override
                    public java.lang.Object getInsecureSsl() {
                        return this.$insecureSsl;
                    }

                    @Override
                    public void setInsecureSsl(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$insecureSsl = value;
                    }

                    @Override
                    public void setInsecureSsl(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$insecureSsl = value;
                    }

                    @Override
                    public java.lang.Object getLocation() {
                        return this.$location;
                    }

                    @Override
                    public void setLocation(@javax.annotation.Nullable final java.lang.String value) {
                        this.$location = value;
                    }

                    @Override
                    public void setLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$location = value;
                    }

                    @Override
                    public java.lang.Object getReportBuildStatus() {
                        return this.$reportBuildStatus;
                    }

                    @Override
                    public void setReportBuildStatus(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$reportBuildStatus = value;
                    }

                    @Override
                    public void setReportBuildStatus(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$reportBuildStatus = value;
                    }

                    @Override
                    public java.lang.Object getSourceIdentifier() {
                        return this.$sourceIdentifier;
                    }

                    @Override
                    public void setSourceIdentifier(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sourceIdentifier = value;
                    }

                    @Override
                    public void setSourceIdentifier(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sourceIdentifier = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.SourceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.SourceProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-type
             */
            @Override
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-type
             */
            @Override
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.SourceProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-type
             */
            @Override
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ProjectResource.SourceProperty.Auth``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-auth
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuth() {
                return this.jsiiGet("auth", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceProperty.Auth``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-auth
             */
            @Override
            public void setAuth(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("auth", value);
            }

            /**
             * ``ProjectResource.SourceProperty.Auth``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-auth
             */
            @Override
            public void setAuth(@javax.annotation.Nullable final software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.SourceAuthProperty value) {
                this.jsiiSet("auth", value);
            }

            /**
             * ``ProjectResource.SourceProperty.BuildSpec``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildspec
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getBuildSpec() {
                return this.jsiiGet("buildSpec", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceProperty.BuildSpec``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildspec
             */
            @Override
            public void setBuildSpec(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("buildSpec", value);
            }

            /**
             * ``ProjectResource.SourceProperty.BuildSpec``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildspec
             */
            @Override
            public void setBuildSpec(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("buildSpec", value);
            }

            /**
             * ``ProjectResource.SourceProperty.GitCloneDepth``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitclonedepth
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getGitCloneDepth() {
                return this.jsiiGet("gitCloneDepth", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceProperty.GitCloneDepth``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitclonedepth
             */
            @Override
            public void setGitCloneDepth(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("gitCloneDepth", value);
            }

            /**
             * ``ProjectResource.SourceProperty.GitCloneDepth``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitclonedepth
             */
            @Override
            public void setGitCloneDepth(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("gitCloneDepth", value);
            }

            /**
             * ``ProjectResource.SourceProperty.InsecureSsl``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-insecuressl
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInsecureSsl() {
                return this.jsiiGet("insecureSsl", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceProperty.InsecureSsl``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-insecuressl
             */
            @Override
            public void setInsecureSsl(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("insecureSsl", value);
            }

            /**
             * ``ProjectResource.SourceProperty.InsecureSsl``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-insecuressl
             */
            @Override
            public void setInsecureSsl(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("insecureSsl", value);
            }

            /**
             * ``ProjectResource.SourceProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-location
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getLocation() {
                return this.jsiiGet("location", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-location
             */
            @Override
            public void setLocation(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("location", value);
            }

            /**
             * ``ProjectResource.SourceProperty.Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-location
             */
            @Override
            public void setLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("location", value);
            }

            /**
             * ``ProjectResource.SourceProperty.ReportBuildStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-reportbuildstatus
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getReportBuildStatus() {
                return this.jsiiGet("reportBuildStatus", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceProperty.ReportBuildStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-reportbuildstatus
             */
            @Override
            public void setReportBuildStatus(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("reportBuildStatus", value);
            }

            /**
             * ``ProjectResource.SourceProperty.ReportBuildStatus``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-reportbuildstatus
             */
            @Override
            public void setReportBuildStatus(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("reportBuildStatus", value);
            }

            /**
             * ``ProjectResource.SourceProperty.SourceIdentifier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-sourceidentifier
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSourceIdentifier() {
                return this.jsiiGet("sourceIdentifier", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.SourceProperty.SourceIdentifier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-sourceidentifier
             */
            @Override
            public void setSourceIdentifier(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sourceIdentifier", value);
            }

            /**
             * ``ProjectResource.SourceProperty.SourceIdentifier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-sourceidentifier
             */
            @Override
            public void setSourceIdentifier(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sourceIdentifier", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html
     */
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ProjectResource.VpcConfigProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-securitygroupids
         */
        java.lang.Object getSecurityGroupIds();
        /**
         * ``ProjectResource.VpcConfigProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-securitygroupids
         */
        void setSecurityGroupIds(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.VpcConfigProperty.SecurityGroupIds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-securitygroupids
         */
        void setSecurityGroupIds(final java.util.List<java.lang.Object> value);
        /**
         * ``ProjectResource.VpcConfigProperty.Subnets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-subnets
         */
        java.lang.Object getSubnets();
        /**
         * ``ProjectResource.VpcConfigProperty.Subnets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-subnets
         */
        void setSubnets(final software.amazon.awscdk.Token value);
        /**
         * ``ProjectResource.VpcConfigProperty.Subnets``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-subnets
         */
        void setSubnets(final java.util.List<java.lang.Object> value);
        /**
         * ``ProjectResource.VpcConfigProperty.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-vpcid
         */
        java.lang.Object getVpcId();
        /**
         * ``ProjectResource.VpcConfigProperty.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-vpcid
         */
        void setVpcId(final java.lang.String value);
        /**
         * ``ProjectResource.VpcConfigProperty.VpcId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-vpcid
         */
        void setVpcId(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VpcConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _securityGroupIds;
            @javax.annotation.Nullable
            private java.lang.Object _subnets;
            @javax.annotation.Nullable
            private java.lang.Object _vpcId;

            /**
             * Sets the value of SecurityGroupIds
             * @param value ``ProjectResource.VpcConfigProperty.SecurityGroupIds``
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._securityGroupIds = value;
                return this;
            }
            /**
             * Sets the value of SecurityGroupIds
             * @param value ``ProjectResource.VpcConfigProperty.SecurityGroupIds``
             * @return {@code this}
             */
            public Builder withSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._securityGroupIds = value;
                return this;
            }
            /**
             * Sets the value of Subnets
             * @param value ``ProjectResource.VpcConfigProperty.Subnets``
             * @return {@code this}
             */
            public Builder withSubnets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._subnets = value;
                return this;
            }
            /**
             * Sets the value of Subnets
             * @param value ``ProjectResource.VpcConfigProperty.Subnets``
             * @return {@code this}
             */
            public Builder withSubnets(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._subnets = value;
                return this;
            }
            /**
             * Sets the value of VpcId
             * @param value ``ProjectResource.VpcConfigProperty.VpcId``
             * @return {@code this}
             */
            public Builder withVpcId(@javax.annotation.Nullable final java.lang.String value) {
                this._vpcId = value;
                return this;
            }
            /**
             * Sets the value of VpcId
             * @param value ``ProjectResource.VpcConfigProperty.VpcId``
             * @return {@code this}
             */
            public Builder withVpcId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._vpcId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public VpcConfigProperty build() {
                return new VpcConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $securityGroupIds = _securityGroupIds;
                    @javax.annotation.Nullable
                    private java.lang.Object $subnets = _subnets;
                    @javax.annotation.Nullable
                    private java.lang.Object $vpcId = _vpcId;

                    @Override
                    public java.lang.Object getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public void setSecurityGroupIds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public void setSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public java.lang.Object getSubnets() {
                        return this.$subnets;
                    }

                    @Override
                    public void setSubnets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$subnets = value;
                    }

                    @Override
                    public void setSubnets(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$subnets = value;
                    }

                    @Override
                    public java.lang.Object getVpcId() {
                        return this.$vpcId;
                    }

                    @Override
                    public void setVpcId(@javax.annotation.Nullable final java.lang.String value) {
                        this.$vpcId = value;
                    }

                    @Override
                    public void setVpcId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$vpcId = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.cloudformation.ProjectResource.VpcConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ProjectResource.VpcConfigProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-securitygroupids
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSecurityGroupIds() {
                return this.jsiiGet("securityGroupIds", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.VpcConfigProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-securitygroupids
             */
            @Override
            public void setSecurityGroupIds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("securityGroupIds", value);
            }

            /**
             * ``ProjectResource.VpcConfigProperty.SecurityGroupIds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-securitygroupids
             */
            @Override
            public void setSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("securityGroupIds", value);
            }

            /**
             * ``ProjectResource.VpcConfigProperty.Subnets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-subnets
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSubnets() {
                return this.jsiiGet("subnets", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.VpcConfigProperty.Subnets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-subnets
             */
            @Override
            public void setSubnets(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("subnets", value);
            }

            /**
             * ``ProjectResource.VpcConfigProperty.Subnets``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-subnets
             */
            @Override
            public void setSubnets(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("subnets", value);
            }

            /**
             * ``ProjectResource.VpcConfigProperty.VpcId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-vpcid
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVpcId() {
                return this.jsiiGet("vpcId", java.lang.Object.class);
            }

            /**
             * ``ProjectResource.VpcConfigProperty.VpcId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-vpcid
             */
            @Override
            public void setVpcId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("vpcId", value);
            }

            /**
             * ``ProjectResource.VpcConfigProperty.VpcId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-vpcid
             */
            @Override
            public void setVpcId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("vpcId", value);
            }
        }
    }
}
