/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awscdk.assets.Asset;
import software.amazon.awscdk.services.codebuild.BuildArtifacts;
import software.amazon.awscdk.services.codebuild.BuildEnvironment;
import software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable;
import software.amazon.awscdk.services.codebuild.BuildSource;
import software.amazon.awscdk.services.codebuild.CommonProjectProps;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.kms.EncryptionKeyRef;
import software.amazon.awscdk.services.s3.BucketRef;
import software.amazon.jsii.JsiiSerializable;

public interface ProjectProps
extends JsiiSerializable,
CommonProjectProps {
    public BuildArtifacts getArtifacts();

    public void setArtifacts(BuildArtifacts var1);

    public List<BuildArtifacts> getSecondaryArtifacts();

    public void setSecondaryArtifacts(List<BuildArtifacts> var1);

    public List<BuildSource> getSecondarySources();

    public void setSecondarySources(List<BuildSource> var1);

    public BuildSource getSource();

    public void setSource(BuildSource var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private BuildArtifacts _artifacts;
        @Nullable
        private List<BuildArtifacts> _secondaryArtifacts;
        @Nullable
        private List<BuildSource> _secondarySources;
        @Nullable
        private BuildSource _source;
        @Nullable
        private Boolean _badge;
        @Nullable
        private Asset _buildScriptAsset;
        @Nullable
        private String _buildScriptAssetEntrypoint;
        @Nullable
        private Object _buildSpec;
        @Nullable
        private BucketRef _cacheBucket;
        @Nullable
        private String _cacheDir;
        @Nullable
        private String _description;
        @Nullable
        private EncryptionKeyRef _encryptionKey;
        @Nullable
        private BuildEnvironment _environment;
        @Nullable
        private Map<String, BuildEnvironmentVariable> _environmentVariables;
        @Nullable
        private String _projectName;
        @Nullable
        private Role _role;
        @Nullable
        private Number _timeout;

        public Builder withArtifacts(@Nullable BuildArtifacts value) {
            this._artifacts = value;
            return this;
        }

        public Builder withSecondaryArtifacts(@Nullable List<BuildArtifacts> value) {
            this._secondaryArtifacts = value;
            return this;
        }

        public Builder withSecondarySources(@Nullable List<BuildSource> value) {
            this._secondarySources = value;
            return this;
        }

        public Builder withSource(@Nullable BuildSource value) {
            this._source = value;
            return this;
        }

        public Builder withBadge(@Nullable Boolean value) {
            this._badge = value;
            return this;
        }

        public Builder withBuildScriptAsset(@Nullable Asset value) {
            this._buildScriptAsset = value;
            return this;
        }

        public Builder withBuildScriptAssetEntrypoint(@Nullable String value) {
            this._buildScriptAssetEntrypoint = value;
            return this;
        }

        public Builder withBuildSpec(@Nullable Object value) {
            this._buildSpec = value;
            return this;
        }

        public Builder withCacheBucket(@Nullable BucketRef value) {
            this._cacheBucket = value;
            return this;
        }

        public Builder withCacheDir(@Nullable String value) {
            this._cacheDir = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withEncryptionKey(@Nullable EncryptionKeyRef value) {
            this._encryptionKey = value;
            return this;
        }

        public Builder withEnvironment(@Nullable BuildEnvironment value) {
            this._environment = value;
            return this;
        }

        public Builder withEnvironmentVariables(@Nullable Map<String, BuildEnvironmentVariable> value) {
            this._environmentVariables = value;
            return this;
        }

        public Builder withProjectName(@Nullable String value) {
            this._projectName = value;
            return this;
        }

        public Builder withRole(@Nullable Role value) {
            this._role = value;
            return this;
        }

        public Builder withTimeout(@Nullable Number value) {
            this._timeout = value;
            return this;
        }

        public ProjectProps build() {
            return new ProjectProps(){
                @Nullable
                private BuildArtifacts $artifacts;
                @Nullable
                private List<BuildArtifacts> $secondaryArtifacts;
                @Nullable
                private List<BuildSource> $secondarySources;
                @Nullable
                private BuildSource $source;
                @Nullable
                private Boolean $badge;
                @Nullable
                private Asset $buildScriptAsset;
                @Nullable
                private String $buildScriptAssetEntrypoint;
                @Nullable
                private Object $buildSpec;
                @Nullable
                private BucketRef $cacheBucket;
                @Nullable
                private String $cacheDir;
                @Nullable
                private String $description;
                @Nullable
                private EncryptionKeyRef $encryptionKey;
                @Nullable
                private BuildEnvironment $environment;
                @Nullable
                private Map<String, BuildEnvironmentVariable> $environmentVariables;
                @Nullable
                private String $projectName;
                @Nullable
                private Role $role;
                @Nullable
                private Number $timeout;
                {
                    this.$artifacts = _artifacts;
                    this.$secondaryArtifacts = _secondaryArtifacts;
                    this.$secondarySources = _secondarySources;
                    this.$source = _source;
                    this.$badge = _badge;
                    this.$buildScriptAsset = _buildScriptAsset;
                    this.$buildScriptAssetEntrypoint = _buildScriptAssetEntrypoint;
                    this.$buildSpec = _buildSpec;
                    this.$cacheBucket = _cacheBucket;
                    this.$cacheDir = _cacheDir;
                    this.$description = _description;
                    this.$encryptionKey = _encryptionKey;
                    this.$environment = _environment;
                    this.$environmentVariables = _environmentVariables;
                    this.$projectName = _projectName;
                    this.$role = _role;
                    this.$timeout = _timeout;
                }

                @Override
                public BuildArtifacts getArtifacts() {
                    return this.$artifacts;
                }

                @Override
                public void setArtifacts(@Nullable BuildArtifacts value) {
                    this.$artifacts = value;
                }

                @Override
                public List<BuildArtifacts> getSecondaryArtifacts() {
                    return this.$secondaryArtifacts;
                }

                @Override
                public void setSecondaryArtifacts(@Nullable List<BuildArtifacts> value) {
                    this.$secondaryArtifacts = value;
                }

                @Override
                public List<BuildSource> getSecondarySources() {
                    return this.$secondarySources;
                }

                @Override
                public void setSecondarySources(@Nullable List<BuildSource> value) {
                    this.$secondarySources = value;
                }

                @Override
                public BuildSource getSource() {
                    return this.$source;
                }

                @Override
                public void setSource(@Nullable BuildSource value) {
                    this.$source = value;
                }

                @Override
                public Boolean getBadge() {
                    return this.$badge;
                }

                @Override
                public void setBadge(@Nullable Boolean value) {
                    this.$badge = value;
                }

                @Override
                public Asset getBuildScriptAsset() {
                    return this.$buildScriptAsset;
                }

                @Override
                public void setBuildScriptAsset(@Nullable Asset value) {
                    this.$buildScriptAsset = value;
                }

                @Override
                public String getBuildScriptAssetEntrypoint() {
                    return this.$buildScriptAssetEntrypoint;
                }

                @Override
                public void setBuildScriptAssetEntrypoint(@Nullable String value) {
                    this.$buildScriptAssetEntrypoint = value;
                }

                @Override
                public Object getBuildSpec() {
                    return this.$buildSpec;
                }

                @Override
                public void setBuildSpec(@Nullable Object value) {
                    this.$buildSpec = value;
                }

                @Override
                public BucketRef getCacheBucket() {
                    return this.$cacheBucket;
                }

                @Override
                public void setCacheBucket(@Nullable BucketRef value) {
                    this.$cacheBucket = value;
                }

                @Override
                public String getCacheDir() {
                    return this.$cacheDir;
                }

                @Override
                public void setCacheDir(@Nullable String value) {
                    this.$cacheDir = value;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public void setDescription(@Nullable String value) {
                    this.$description = value;
                }

                @Override
                public EncryptionKeyRef getEncryptionKey() {
                    return this.$encryptionKey;
                }

                @Override
                public void setEncryptionKey(@Nullable EncryptionKeyRef value) {
                    this.$encryptionKey = value;
                }

                @Override
                public BuildEnvironment getEnvironment() {
                    return this.$environment;
                }

                @Override
                public void setEnvironment(@Nullable BuildEnvironment value) {
                    this.$environment = value;
                }

                @Override
                public Map<String, BuildEnvironmentVariable> getEnvironmentVariables() {
                    return this.$environmentVariables;
                }

                @Override
                public void setEnvironmentVariables(@Nullable Map<String, BuildEnvironmentVariable> value) {
                    this.$environmentVariables = value;
                }

                @Override
                public String getProjectName() {
                    return this.$projectName;
                }

                @Override
                public void setProjectName(@Nullable String value) {
                    this.$projectName = value;
                }

                @Override
                public Role getRole() {
                    return this.$role;
                }

                @Override
                public void setRole(@Nullable Role value) {
                    this.$role = value;
                }

                @Override
                public Number getTimeout() {
                    return this.$timeout;
                }

                @Override
                public void setTimeout(@Nullable Number value) {
                    this.$timeout = value;
                }
            };
        }
    }
}

