/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.codebuild.BuildSourceProps;
import software.amazon.awscdk.services.s3.BucketRef;
import software.amazon.jsii.JsiiSerializable;

public interface S3BucketSourceProps
extends JsiiSerializable,
BuildSourceProps {
    public BucketRef getBucket();

    public void setBucket(BucketRef var1);

    public String getPath();

    public void setPath(String var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BucketRef _bucket;
        private String _path;
        @Nullable
        private String _identifier;

        public Builder withBucket(BucketRef value) {
            this._bucket = Objects.requireNonNull(value, "bucket is required");
            return this;
        }

        public Builder withPath(String value) {
            this._path = Objects.requireNonNull(value, "path is required");
            return this;
        }

        public Builder withIdentifier(@Nullable String value) {
            this._identifier = value;
            return this;
        }

        public S3BucketSourceProps build() {
            return new S3BucketSourceProps(){
                private BucketRef $bucket;
                private String $path;
                @Nullable
                private String $identifier;
                {
                    this.$bucket = Objects.requireNonNull(_bucket, "bucket is required");
                    this.$path = Objects.requireNonNull(_path, "path is required");
                    this.$identifier = _identifier;
                }

                @Override
                public BucketRef getBucket() {
                    return this.$bucket;
                }

                @Override
                public void setBucket(BucketRef value) {
                    this.$bucket = Objects.requireNonNull(value, "bucket is required");
                }

                @Override
                public String getPath() {
                    return this.$path;
                }

                @Override
                public void setPath(String value) {
                    this.$path = Objects.requireNonNull(value, "path is required");
                }

                @Override
                public String getIdentifier() {
                    return this.$identifier;
                }

                @Override
                public void setIdentifier(@Nullable String value) {
                    this.$identifier = value;
                }
            };
        }
    }
}

