/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild.cloudformation;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import software.amazon.awscdk.Construct;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.codebuild.;
import software.amazon.awscdk.services.codebuild.cloudformation.ProjectResourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-codebuild.cloudformation.ProjectResource")
public class ProjectResource
extends Resource {
    public static final String RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(ProjectResource.class, (String)"resourceTypeName", String.class);

    protected ProjectResource(JsiiObject.InitializationMode mode) {
        super(mode);
    }

    public ProjectResource(Construct parent, String name, ProjectResourceProps properties) {
        super(JsiiObject.InitializationMode.Jsii);
        JsiiEngine.getInstance().createNewObject((Object)this, Stream.concat(Stream.concat(Stream.of(Objects.requireNonNull(parent, "parent is required")), Stream.of(Objects.requireNonNull(name, "name is required"))), Stream.of(Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    protected Map<String, Object> renderProperties(Object properties) {
        return (Map)this.jsiiCall("renderProperties", Map.class, Stream.of(Objects.requireNonNull(properties, "properties is required")).toArray());
    }

    public String getProjectArn() {
        return (String)this.jsiiGet("projectArn", String.class);
    }

    public String getProjectName() {
        return (String)this.jsiiGet("projectName", String.class);
    }

    public ProjectResourceProps getPropertyOverrides() {
        return (ProjectResourceProps)this.jsiiGet("propertyOverrides", ProjectResourceProps.class);
    }

    public static interface VpcConfigProperty
    extends JsiiSerializable {
        public Object getSecurityGroupIds();

        public void setSecurityGroupIds(Token var1);

        public void setSecurityGroupIds(List<Object> var1);

        public Object getSubnets();

        public void setSubnets(Token var1);

        public void setSubnets(List<Object> var1);

        public Object getVpcId();

        public void setVpcId(String var1);

        public void setVpcId(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _securityGroupIds;
            @Nullable
            private Object _subnets;
            @Nullable
            private Object _vpcId;

            public Builder withSecurityGroupIds(@Nullable Token value) {
                this._securityGroupIds = value;
                return this;
            }

            public Builder withSecurityGroupIds(@Nullable List<Object> value) {
                this._securityGroupIds = value;
                return this;
            }

            public Builder withSubnets(@Nullable Token value) {
                this._subnets = value;
                return this;
            }

            public Builder withSubnets(@Nullable List<Object> value) {
                this._subnets = value;
                return this;
            }

            public Builder withVpcId(@Nullable String value) {
                this._vpcId = value;
                return this;
            }

            public Builder withVpcId(@Nullable Token value) {
                this._vpcId = value;
                return this;
            }

            public VpcConfigProperty build() {
                return new VpcConfigProperty(){
                    @Nullable
                    private Object $securityGroupIds;
                    @Nullable
                    private Object $subnets;
                    @Nullable
                    private Object $vpcId;
                    {
                        this.$securityGroupIds = _securityGroupIds;
                        this.$subnets = _subnets;
                        this.$vpcId = _vpcId;
                    }

                    @Override
                    public Object getSecurityGroupIds() {
                        return this.$securityGroupIds;
                    }

                    @Override
                    public void setSecurityGroupIds(@Nullable Token value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public void setSecurityGroupIds(@Nullable List<Object> value) {
                        this.$securityGroupIds = value;
                    }

                    @Override
                    public Object getSubnets() {
                        return this.$subnets;
                    }

                    @Override
                    public void setSubnets(@Nullable Token value) {
                        this.$subnets = value;
                    }

                    @Override
                    public void setSubnets(@Nullable List<Object> value) {
                        this.$subnets = value;
                    }

                    @Override
                    public Object getVpcId() {
                        return this.$vpcId;
                    }

                    @Override
                    public void setVpcId(@Nullable String value) {
                        this.$vpcId = value;
                    }

                    @Override
                    public void setVpcId(@Nullable Token value) {
                        this.$vpcId = value;
                    }
                };
            }
        }
    }

    public static interface SourceProperty
    extends JsiiSerializable {
        public Object getType();

        public void setType(String var1);

        public void setType(Token var1);

        public Object getAuth();

        public void setAuth(Token var1);

        public void setAuth(SourceAuthProperty var1);

        public Object getBuildSpec();

        public void setBuildSpec(String var1);

        public void setBuildSpec(Token var1);

        public Object getGitCloneDepth();

        public void setGitCloneDepth(Number var1);

        public void setGitCloneDepth(Token var1);

        public Object getInsecureSsl();

        public void setInsecureSsl(Boolean var1);

        public void setInsecureSsl(Token var1);

        public Object getLocation();

        public void setLocation(String var1);

        public void setLocation(Token var1);

        public Object getReportBuildStatus();

        public void setReportBuildStatus(Boolean var1);

        public void setReportBuildStatus(Token var1);

        public Object getSourceIdentifier();

        public void setSourceIdentifier(String var1);

        public void setSourceIdentifier(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _type;
            @Nullable
            private Object _auth;
            @Nullable
            private Object _buildSpec;
            @Nullable
            private Object _gitCloneDepth;
            @Nullable
            private Object _insecureSsl;
            @Nullable
            private Object _location;
            @Nullable
            private Object _reportBuildStatus;
            @Nullable
            private Object _sourceIdentifier;

            public Builder withType(String value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withType(Token value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withAuth(@Nullable Token value) {
                this._auth = value;
                return this;
            }

            public Builder withAuth(@Nullable SourceAuthProperty value) {
                this._auth = value;
                return this;
            }

            public Builder withBuildSpec(@Nullable String value) {
                this._buildSpec = value;
                return this;
            }

            public Builder withBuildSpec(@Nullable Token value) {
                this._buildSpec = value;
                return this;
            }

            public Builder withGitCloneDepth(@Nullable Number value) {
                this._gitCloneDepth = value;
                return this;
            }

            public Builder withGitCloneDepth(@Nullable Token value) {
                this._gitCloneDepth = value;
                return this;
            }

            public Builder withInsecureSsl(@Nullable Boolean value) {
                this._insecureSsl = value;
                return this;
            }

            public Builder withInsecureSsl(@Nullable Token value) {
                this._insecureSsl = value;
                return this;
            }

            public Builder withLocation(@Nullable String value) {
                this._location = value;
                return this;
            }

            public Builder withLocation(@Nullable Token value) {
                this._location = value;
                return this;
            }

            public Builder withReportBuildStatus(@Nullable Boolean value) {
                this._reportBuildStatus = value;
                return this;
            }

            public Builder withReportBuildStatus(@Nullable Token value) {
                this._reportBuildStatus = value;
                return this;
            }

            public Builder withSourceIdentifier(@Nullable String value) {
                this._sourceIdentifier = value;
                return this;
            }

            public Builder withSourceIdentifier(@Nullable Token value) {
                this._sourceIdentifier = value;
                return this;
            }

            public SourceProperty build() {
                return new SourceProperty(){
                    private Object $type;
                    @Nullable
                    private Object $auth;
                    @Nullable
                    private Object $buildSpec;
                    @Nullable
                    private Object $gitCloneDepth;
                    @Nullable
                    private Object $insecureSsl;
                    @Nullable
                    private Object $location;
                    @Nullable
                    private Object $reportBuildStatus;
                    @Nullable
                    private Object $sourceIdentifier;
                    {
                        this.$type = Objects.requireNonNull(_type, "type is required");
                        this.$auth = _auth;
                        this.$buildSpec = _buildSpec;
                        this.$gitCloneDepth = _gitCloneDepth;
                        this.$insecureSsl = _insecureSsl;
                        this.$location = _location;
                        this.$reportBuildStatus = _reportBuildStatus;
                        this.$sourceIdentifier = _sourceIdentifier;
                    }

                    @Override
                    public Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(String value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(Token value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public Object getAuth() {
                        return this.$auth;
                    }

                    @Override
                    public void setAuth(@Nullable Token value) {
                        this.$auth = value;
                    }

                    @Override
                    public void setAuth(@Nullable SourceAuthProperty value) {
                        this.$auth = value;
                    }

                    @Override
                    public Object getBuildSpec() {
                        return this.$buildSpec;
                    }

                    @Override
                    public void setBuildSpec(@Nullable String value) {
                        this.$buildSpec = value;
                    }

                    @Override
                    public void setBuildSpec(@Nullable Token value) {
                        this.$buildSpec = value;
                    }

                    @Override
                    public Object getGitCloneDepth() {
                        return this.$gitCloneDepth;
                    }

                    @Override
                    public void setGitCloneDepth(@Nullable Number value) {
                        this.$gitCloneDepth = value;
                    }

                    @Override
                    public void setGitCloneDepth(@Nullable Token value) {
                        this.$gitCloneDepth = value;
                    }

                    @Override
                    public Object getInsecureSsl() {
                        return this.$insecureSsl;
                    }

                    @Override
                    public void setInsecureSsl(@Nullable Boolean value) {
                        this.$insecureSsl = value;
                    }

                    @Override
                    public void setInsecureSsl(@Nullable Token value) {
                        this.$insecureSsl = value;
                    }

                    @Override
                    public Object getLocation() {
                        return this.$location;
                    }

                    @Override
                    public void setLocation(@Nullable String value) {
                        this.$location = value;
                    }

                    @Override
                    public void setLocation(@Nullable Token value) {
                        this.$location = value;
                    }

                    @Override
                    public Object getReportBuildStatus() {
                        return this.$reportBuildStatus;
                    }

                    @Override
                    public void setReportBuildStatus(@Nullable Boolean value) {
                        this.$reportBuildStatus = value;
                    }

                    @Override
                    public void setReportBuildStatus(@Nullable Token value) {
                        this.$reportBuildStatus = value;
                    }

                    @Override
                    public Object getSourceIdentifier() {
                        return this.$sourceIdentifier;
                    }

                    @Override
                    public void setSourceIdentifier(@Nullable String value) {
                        this.$sourceIdentifier = value;
                    }

                    @Override
                    public void setSourceIdentifier(@Nullable Token value) {
                        this.$sourceIdentifier = value;
                    }
                };
            }
        }
    }

    public static interface SourceAuthProperty
    extends JsiiSerializable {
        public Object getType();

        public void setType(String var1);

        public void setType(Token var1);

        public Object getResource();

        public void setResource(String var1);

        public void setResource(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _type;
            @Nullable
            private Object _resource;

            public Builder withType(String value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withType(Token value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withResource(@Nullable String value) {
                this._resource = value;
                return this;
            }

            public Builder withResource(@Nullable Token value) {
                this._resource = value;
                return this;
            }

            public SourceAuthProperty build() {
                return new SourceAuthProperty(){
                    private Object $type;
                    @Nullable
                    private Object $resource;
                    {
                        this.$type = Objects.requireNonNull(_type, "type is required");
                        this.$resource = _resource;
                    }

                    @Override
                    public Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(String value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(Token value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public Object getResource() {
                        return this.$resource;
                    }

                    @Override
                    public void setResource(@Nullable String value) {
                        this.$resource = value;
                    }

                    @Override
                    public void setResource(@Nullable Token value) {
                        this.$resource = value;
                    }
                };
            }
        }
    }

    public static interface S3LogsConfigProperty
    extends JsiiSerializable {
        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(Token var1);

        public Object getLocation();

        public void setLocation(String var1);

        public void setLocation(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _status;
            @Nullable
            private Object _location;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withStatus(Token value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withLocation(@Nullable String value) {
                this._location = value;
                return this;
            }

            public Builder withLocation(@Nullable Token value) {
                this._location = value;
                return this;
            }

            public S3LogsConfigProperty build() {
                return new S3LogsConfigProperty(){
                    private Object $status;
                    @Nullable
                    private Object $location;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                        this.$location = _location;
                    }

                    @Override
                    public Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(Token value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public Object getLocation() {
                        return this.$location;
                    }

                    @Override
                    public void setLocation(@Nullable String value) {
                        this.$location = value;
                    }

                    @Override
                    public void setLocation(@Nullable Token value) {
                        this.$location = value;
                    }
                };
            }
        }
    }

    public static interface ProjectTriggersProperty
    extends JsiiSerializable {
        public Object getWebhook();

        public void setWebhook(Boolean var1);

        public void setWebhook(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _webhook;

            public Builder withWebhook(@Nullable Boolean value) {
                this._webhook = value;
                return this;
            }

            public Builder withWebhook(@Nullable Token value) {
                this._webhook = value;
                return this;
            }

            public ProjectTriggersProperty build() {
                return new ProjectTriggersProperty(){
                    @Nullable
                    private Object $webhook;
                    {
                        this.$webhook = _webhook;
                    }

                    @Override
                    public Object getWebhook() {
                        return this.$webhook;
                    }

                    @Override
                    public void setWebhook(@Nullable Boolean value) {
                        this.$webhook = value;
                    }

                    @Override
                    public void setWebhook(@Nullable Token value) {
                        this.$webhook = value;
                    }
                };
            }
        }
    }

    public static interface ProjectCacheProperty
    extends JsiiSerializable {
        public Object getType();

        public void setType(String var1);

        public void setType(Token var1);

        public Object getLocation();

        public void setLocation(String var1);

        public void setLocation(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _type;
            @Nullable
            private Object _location;

            public Builder withType(String value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withType(Token value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withLocation(@Nullable String value) {
                this._location = value;
                return this;
            }

            public Builder withLocation(@Nullable Token value) {
                this._location = value;
                return this;
            }

            public ProjectCacheProperty build() {
                return new ProjectCacheProperty(){
                    private Object $type;
                    @Nullable
                    private Object $location;
                    {
                        this.$type = Objects.requireNonNull(_type, "type is required");
                        this.$location = _location;
                    }

                    @Override
                    public Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(String value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(Token value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public Object getLocation() {
                        return this.$location;
                    }

                    @Override
                    public void setLocation(@Nullable String value) {
                        this.$location = value;
                    }

                    @Override
                    public void setLocation(@Nullable Token value) {
                        this.$location = value;
                    }
                };
            }
        }
    }

    public static interface LogsConfigProperty
    extends JsiiSerializable {
        public Object getCloudWatchLogs();

        public void setCloudWatchLogs(Token var1);

        public void setCloudWatchLogs(CloudWatchLogsConfigProperty var1);

        public Object getS3Logs();

        public void setS3Logs(Token var1);

        public void setS3Logs(S3LogsConfigProperty var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            @Nullable
            private Object _cloudWatchLogs;
            @Nullable
            private Object _s3Logs;

            public Builder withCloudWatchLogs(@Nullable Token value) {
                this._cloudWatchLogs = value;
                return this;
            }

            public Builder withCloudWatchLogs(@Nullable CloudWatchLogsConfigProperty value) {
                this._cloudWatchLogs = value;
                return this;
            }

            public Builder withS3Logs(@Nullable Token value) {
                this._s3Logs = value;
                return this;
            }

            public Builder withS3Logs(@Nullable S3LogsConfigProperty value) {
                this._s3Logs = value;
                return this;
            }

            public LogsConfigProperty build() {
                return new LogsConfigProperty(){
                    @Nullable
                    private Object $cloudWatchLogs;
                    @Nullable
                    private Object $s3Logs;
                    {
                        this.$cloudWatchLogs = _cloudWatchLogs;
                        this.$s3Logs = _s3Logs;
                    }

                    @Override
                    public Object getCloudWatchLogs() {
                        return this.$cloudWatchLogs;
                    }

                    @Override
                    public void setCloudWatchLogs(@Nullable Token value) {
                        this.$cloudWatchLogs = value;
                    }

                    @Override
                    public void setCloudWatchLogs(@Nullable CloudWatchLogsConfigProperty value) {
                        this.$cloudWatchLogs = value;
                    }

                    @Override
                    public Object getS3Logs() {
                        return this.$s3Logs;
                    }

                    @Override
                    public void setS3Logs(@Nullable Token value) {
                        this.$s3Logs = value;
                    }

                    @Override
                    public void setS3Logs(@Nullable S3LogsConfigProperty value) {
                        this.$s3Logs = value;
                    }
                };
            }
        }
    }

    public static interface EnvironmentVariableProperty
    extends JsiiSerializable {
        public Object getName();

        public void setName(String var1);

        public void setName(Token var1);

        public Object getValue();

        public void setValue(String var1);

        public void setValue(Token var1);

        public Object getType();

        public void setType(String var1);

        public void setType(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _name;
            private Object _value;
            @Nullable
            private Object _type;

            public Builder withName(String value) {
                this._name = Objects.requireNonNull(value, "name is required");
                return this;
            }

            public Builder withName(Token value) {
                this._name = Objects.requireNonNull(value, "name is required");
                return this;
            }

            public Builder withValue(String value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public Builder withValue(Token value) {
                this._value = Objects.requireNonNull(value, "value is required");
                return this;
            }

            public Builder withType(@Nullable String value) {
                this._type = value;
                return this;
            }

            public Builder withType(@Nullable Token value) {
                this._type = value;
                return this;
            }

            public EnvironmentVariableProperty build() {
                return new EnvironmentVariableProperty(){
                    private Object $name;
                    private Object $value;
                    @Nullable
                    private Object $type;
                    {
                        this.$name = Objects.requireNonNull(_name, "name is required");
                        this.$value = Objects.requireNonNull(_value, "value is required");
                        this.$type = _type;
                    }

                    @Override
                    public Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(String value) {
                        this.$name = Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public void setName(Token value) {
                        this.$name = Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(String value) {
                        this.$value = Objects.requireNonNull(value, "value is required");
                    }

                    @Override
                    public void setValue(Token value) {
                        this.$value = Objects.requireNonNull(value, "value is required");
                    }

                    @Override
                    public Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@Nullable String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@Nullable Token value) {
                        this.$type = value;
                    }
                };
            }
        }
    }

    public static interface EnvironmentProperty
    extends JsiiSerializable {
        public Object getComputeType();

        public void setComputeType(String var1);

        public void setComputeType(Token var1);

        public Object getImage();

        public void setImage(String var1);

        public void setImage(Token var1);

        public Object getType();

        public void setType(String var1);

        public void setType(Token var1);

        public Object getCertificate();

        public void setCertificate(String var1);

        public void setCertificate(Token var1);

        public Object getEnvironmentVariables();

        public void setEnvironmentVariables(Token var1);

        public void setEnvironmentVariables(List<Object> var1);

        public Object getPrivilegedMode();

        public void setPrivilegedMode(Boolean var1);

        public void setPrivilegedMode(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _computeType;
            private Object _image;
            private Object _type;
            @Nullable
            private Object _certificate;
            @Nullable
            private Object _environmentVariables;
            @Nullable
            private Object _privilegedMode;

            public Builder withComputeType(String value) {
                this._computeType = Objects.requireNonNull(value, "computeType is required");
                return this;
            }

            public Builder withComputeType(Token value) {
                this._computeType = Objects.requireNonNull(value, "computeType is required");
                return this;
            }

            public Builder withImage(String value) {
                this._image = Objects.requireNonNull(value, "image is required");
                return this;
            }

            public Builder withImage(Token value) {
                this._image = Objects.requireNonNull(value, "image is required");
                return this;
            }

            public Builder withType(String value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withType(Token value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withCertificate(@Nullable String value) {
                this._certificate = value;
                return this;
            }

            public Builder withCertificate(@Nullable Token value) {
                this._certificate = value;
                return this;
            }

            public Builder withEnvironmentVariables(@Nullable Token value) {
                this._environmentVariables = value;
                return this;
            }

            public Builder withEnvironmentVariables(@Nullable List<Object> value) {
                this._environmentVariables = value;
                return this;
            }

            public Builder withPrivilegedMode(@Nullable Boolean value) {
                this._privilegedMode = value;
                return this;
            }

            public Builder withPrivilegedMode(@Nullable Token value) {
                this._privilegedMode = value;
                return this;
            }

            public EnvironmentProperty build() {
                return new EnvironmentProperty(){
                    private Object $computeType;
                    private Object $image;
                    private Object $type;
                    @Nullable
                    private Object $certificate;
                    @Nullable
                    private Object $environmentVariables;
                    @Nullable
                    private Object $privilegedMode;
                    {
                        this.$computeType = Objects.requireNonNull(_computeType, "computeType is required");
                        this.$image = Objects.requireNonNull(_image, "image is required");
                        this.$type = Objects.requireNonNull(_type, "type is required");
                        this.$certificate = _certificate;
                        this.$environmentVariables = _environmentVariables;
                        this.$privilegedMode = _privilegedMode;
                    }

                    @Override
                    public Object getComputeType() {
                        return this.$computeType;
                    }

                    @Override
                    public void setComputeType(String value) {
                        this.$computeType = Objects.requireNonNull(value, "computeType is required");
                    }

                    @Override
                    public void setComputeType(Token value) {
                        this.$computeType = Objects.requireNonNull(value, "computeType is required");
                    }

                    @Override
                    public Object getImage() {
                        return this.$image;
                    }

                    @Override
                    public void setImage(String value) {
                        this.$image = Objects.requireNonNull(value, "image is required");
                    }

                    @Override
                    public void setImage(Token value) {
                        this.$image = Objects.requireNonNull(value, "image is required");
                    }

                    @Override
                    public Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(String value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(Token value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public Object getCertificate() {
                        return this.$certificate;
                    }

                    @Override
                    public void setCertificate(@Nullable String value) {
                        this.$certificate = value;
                    }

                    @Override
                    public void setCertificate(@Nullable Token value) {
                        this.$certificate = value;
                    }

                    @Override
                    public Object getEnvironmentVariables() {
                        return this.$environmentVariables;
                    }

                    @Override
                    public void setEnvironmentVariables(@Nullable Token value) {
                        this.$environmentVariables = value;
                    }

                    @Override
                    public void setEnvironmentVariables(@Nullable List<Object> value) {
                        this.$environmentVariables = value;
                    }

                    @Override
                    public Object getPrivilegedMode() {
                        return this.$privilegedMode;
                    }

                    @Override
                    public void setPrivilegedMode(@Nullable Boolean value) {
                        this.$privilegedMode = value;
                    }

                    @Override
                    public void setPrivilegedMode(@Nullable Token value) {
                        this.$privilegedMode = value;
                    }
                };
            }
        }
    }

    public static interface CloudWatchLogsConfigProperty
    extends JsiiSerializable {
        public Object getStatus();

        public void setStatus(String var1);

        public void setStatus(Token var1);

        public Object getGroupName();

        public void setGroupName(String var1);

        public void setGroupName(Token var1);

        public Object getStreamName();

        public void setStreamName(String var1);

        public void setStreamName(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _status;
            @Nullable
            private Object _groupName;
            @Nullable
            private Object _streamName;

            public Builder withStatus(String value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withStatus(Token value) {
                this._status = Objects.requireNonNull(value, "status is required");
                return this;
            }

            public Builder withGroupName(@Nullable String value) {
                this._groupName = value;
                return this;
            }

            public Builder withGroupName(@Nullable Token value) {
                this._groupName = value;
                return this;
            }

            public Builder withStreamName(@Nullable String value) {
                this._streamName = value;
                return this;
            }

            public Builder withStreamName(@Nullable Token value) {
                this._streamName = value;
                return this;
            }

            public CloudWatchLogsConfigProperty build() {
                return new CloudWatchLogsConfigProperty(){
                    private Object $status;
                    @Nullable
                    private Object $groupName;
                    @Nullable
                    private Object $streamName;
                    {
                        this.$status = Objects.requireNonNull(_status, "status is required");
                        this.$groupName = _groupName;
                        this.$streamName = _streamName;
                    }

                    @Override
                    public Object getStatus() {
                        return this.$status;
                    }

                    @Override
                    public void setStatus(String value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public void setStatus(Token value) {
                        this.$status = Objects.requireNonNull(value, "status is required");
                    }

                    @Override
                    public Object getGroupName() {
                        return this.$groupName;
                    }

                    @Override
                    public void setGroupName(@Nullable String value) {
                        this.$groupName = value;
                    }

                    @Override
                    public void setGroupName(@Nullable Token value) {
                        this.$groupName = value;
                    }

                    @Override
                    public Object getStreamName() {
                        return this.$streamName;
                    }

                    @Override
                    public void setStreamName(@Nullable String value) {
                        this.$streamName = value;
                    }

                    @Override
                    public void setStreamName(@Nullable Token value) {
                        this.$streamName = value;
                    }
                };
            }
        }
    }

    public static interface ArtifactsProperty
    extends JsiiSerializable {
        public Object getType();

        public void setType(String var1);

        public void setType(Token var1);

        public Object getArtifactIdentifier();

        public void setArtifactIdentifier(String var1);

        public void setArtifactIdentifier(Token var1);

        public Object getEncryptionDisabled();

        public void setEncryptionDisabled(Boolean var1);

        public void setEncryptionDisabled(Token var1);

        public Object getLocation();

        public void setLocation(String var1);

        public void setLocation(Token var1);

        public Object getName();

        public void setName(String var1);

        public void setName(Token var1);

        public Object getNamespaceType();

        public void setNamespaceType(String var1);

        public void setNamespaceType(Token var1);

        public Object getOverrideArtifactName();

        public void setOverrideArtifactName(Boolean var1);

        public void setOverrideArtifactName(Token var1);

        public Object getPackaging();

        public void setPackaging(String var1);

        public void setPackaging(Token var1);

        public Object getPath();

        public void setPath(String var1);

        public void setPath(Token var1);

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object _type;
            @Nullable
            private Object _artifactIdentifier;
            @Nullable
            private Object _encryptionDisabled;
            @Nullable
            private Object _location;
            @Nullable
            private Object _name;
            @Nullable
            private Object _namespaceType;
            @Nullable
            private Object _overrideArtifactName;
            @Nullable
            private Object _packaging;
            @Nullable
            private Object _path;

            public Builder withType(String value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withType(Token value) {
                this._type = Objects.requireNonNull(value, "type is required");
                return this;
            }

            public Builder withArtifactIdentifier(@Nullable String value) {
                this._artifactIdentifier = value;
                return this;
            }

            public Builder withArtifactIdentifier(@Nullable Token value) {
                this._artifactIdentifier = value;
                return this;
            }

            public Builder withEncryptionDisabled(@Nullable Boolean value) {
                this._encryptionDisabled = value;
                return this;
            }

            public Builder withEncryptionDisabled(@Nullable Token value) {
                this._encryptionDisabled = value;
                return this;
            }

            public Builder withLocation(@Nullable String value) {
                this._location = value;
                return this;
            }

            public Builder withLocation(@Nullable Token value) {
                this._location = value;
                return this;
            }

            public Builder withName(@Nullable String value) {
                this._name = value;
                return this;
            }

            public Builder withName(@Nullable Token value) {
                this._name = value;
                return this;
            }

            public Builder withNamespaceType(@Nullable String value) {
                this._namespaceType = value;
                return this;
            }

            public Builder withNamespaceType(@Nullable Token value) {
                this._namespaceType = value;
                return this;
            }

            public Builder withOverrideArtifactName(@Nullable Boolean value) {
                this._overrideArtifactName = value;
                return this;
            }

            public Builder withOverrideArtifactName(@Nullable Token value) {
                this._overrideArtifactName = value;
                return this;
            }

            public Builder withPackaging(@Nullable String value) {
                this._packaging = value;
                return this;
            }

            public Builder withPackaging(@Nullable Token value) {
                this._packaging = value;
                return this;
            }

            public Builder withPath(@Nullable String value) {
                this._path = value;
                return this;
            }

            public Builder withPath(@Nullable Token value) {
                this._path = value;
                return this;
            }

            public ArtifactsProperty build() {
                return new ArtifactsProperty(){
                    private Object $type;
                    @Nullable
                    private Object $artifactIdentifier;
                    @Nullable
                    private Object $encryptionDisabled;
                    @Nullable
                    private Object $location;
                    @Nullable
                    private Object $name;
                    @Nullable
                    private Object $namespaceType;
                    @Nullable
                    private Object $overrideArtifactName;
                    @Nullable
                    private Object $packaging;
                    @Nullable
                    private Object $path;
                    {
                        this.$type = Objects.requireNonNull(_type, "type is required");
                        this.$artifactIdentifier = _artifactIdentifier;
                        this.$encryptionDisabled = _encryptionDisabled;
                        this.$location = _location;
                        this.$name = _name;
                        this.$namespaceType = _namespaceType;
                        this.$overrideArtifactName = _overrideArtifactName;
                        this.$packaging = _packaging;
                        this.$path = _path;
                    }

                    @Override
                    public Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(String value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(Token value) {
                        this.$type = Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public Object getArtifactIdentifier() {
                        return this.$artifactIdentifier;
                    }

                    @Override
                    public void setArtifactIdentifier(@Nullable String value) {
                        this.$artifactIdentifier = value;
                    }

                    @Override
                    public void setArtifactIdentifier(@Nullable Token value) {
                        this.$artifactIdentifier = value;
                    }

                    @Override
                    public Object getEncryptionDisabled() {
                        return this.$encryptionDisabled;
                    }

                    @Override
                    public void setEncryptionDisabled(@Nullable Boolean value) {
                        this.$encryptionDisabled = value;
                    }

                    @Override
                    public void setEncryptionDisabled(@Nullable Token value) {
                        this.$encryptionDisabled = value;
                    }

                    @Override
                    public Object getLocation() {
                        return this.$location;
                    }

                    @Override
                    public void setLocation(@Nullable String value) {
                        this.$location = value;
                    }

                    @Override
                    public void setLocation(@Nullable Token value) {
                        this.$location = value;
                    }

                    @Override
                    public Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@Nullable String value) {
                        this.$name = value;
                    }

                    @Override
                    public void setName(@Nullable Token value) {
                        this.$name = value;
                    }

                    @Override
                    public Object getNamespaceType() {
                        return this.$namespaceType;
                    }

                    @Override
                    public void setNamespaceType(@Nullable String value) {
                        this.$namespaceType = value;
                    }

                    @Override
                    public void setNamespaceType(@Nullable Token value) {
                        this.$namespaceType = value;
                    }

                    @Override
                    public Object getOverrideArtifactName() {
                        return this.$overrideArtifactName;
                    }

                    @Override
                    public void setOverrideArtifactName(@Nullable Boolean value) {
                        this.$overrideArtifactName = value;
                    }

                    @Override
                    public void setOverrideArtifactName(@Nullable Token value) {
                        this.$overrideArtifactName = value;
                    }

                    @Override
                    public Object getPackaging() {
                        return this.$packaging;
                    }

                    @Override
                    public void setPackaging(@Nullable String value) {
                        this.$packaging = value;
                    }

                    @Override
                    public void setPackaging(@Nullable Token value) {
                        this.$packaging = value;
                    }

                    @Override
                    public Object getPath() {
                        return this.$path;
                    }

                    @Override
                    public void setPath(@Nullable String value) {
                        this.$path = value;
                    }

                    @Override
                    public void setPath(@Nullable Token value) {
                        this.$path = value;
                    }
                };
            }
        }
    }
}

