package software.amazon.awscdk.services.codebuild;

/**
 * FileSystemLocation provider definition for a CodeBuild Project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Project.Builder.create(this, "MyProject")
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")))
 *         .fileSystemLocations(List.of(FileSystemLocation.efs(EfsFileSystemLocationProps.builder()
 *                 .identifier("myidentifier2")
 *                 .location("myclodation.mydnsroot.com:/loc")
 *                 .mountPoint("/media")
 *                 .mountOptions("opts")
 *                 .build())))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:21.994Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.FileSystemLocation")
public class FileSystemLocation extends software.amazon.jsii.JsiiObject {

    protected FileSystemLocation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileSystemLocation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FileSystemLocation() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * EFS file system provider.
     * <p>
     * @param props the EFS File System location property. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IFileSystemLocation efs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.EfsFileSystemLocationProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.FileSystemLocation.class, "efs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IFileSystemLocation.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
}
