/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.codebuild.$Module;
import software.amazon.awscdk.services.codebuild.BuildEnvironment;
import software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable;
import software.amazon.awscdk.services.codebuild.BuildSpec;
import software.amazon.awscdk.services.codebuild.Cache;
import software.amazon.awscdk.services.codebuild.IFileSystemLocation;
import software.amazon.awscdk.services.codebuild.PipelineProjectProps;
import software.amazon.awscdk.services.codebuild.Project;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-codebuild.PipelineProject")
public class PipelineProject
extends Project {
    protected PipelineProject(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PipelineProject(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public PipelineProject(@NotNull Construct scope, @NotNull String id, @Nullable PipelineProjectProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public PipelineProject(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private PipelineProjectProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.props().allowAllOutbound(allowAllOutbound);
            return this;
        }

        public Builder badge(Boolean badge) {
            this.props().badge(badge);
            return this;
        }

        public Builder buildSpec(BuildSpec buildSpec) {
            this.props().buildSpec(buildSpec);
            return this;
        }

        public Builder cache(Cache cache) {
            this.props().cache(cache);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder environment(BuildEnvironment environment) {
            this.props().environment(environment);
            return this;
        }

        public Builder environmentVariables(Map<String, BuildEnvironmentVariable> environmentVariables) {
            this.props().environmentVariables(environmentVariables);
            return this;
        }

        public Builder fileSystemLocations(List<IFileSystemLocation> fileSystemLocations) {
            this.props().fileSystemLocations(fileSystemLocations);
            return this;
        }

        public Builder grantReportGroupPermissions(Boolean grantReportGroupPermissions) {
            this.props().grantReportGroupPermissions(grantReportGroupPermissions);
            return this;
        }

        public Builder projectName(String projectName) {
            this.props().projectName(projectName);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public Builder securityGroups(List<ISecurityGroup> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props().subnetSelection(subnetSelection);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public PipelineProject build() {
            return new PipelineProject(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private PipelineProjectProps.Builder props() {
            if (this.props == null) {
                this.props = new PipelineProjectProps.Builder();
            }
            return this.props;
        }
    }
}

