/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.codebuild.;
import software.amazon.awscdk.services.codebuild.BindToCodePipelineOptions;
import software.amazon.awscdk.services.codebuild.BuildEnvironment;
import software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable;
import software.amazon.awscdk.services.codebuild.BuildSpec;
import software.amazon.awscdk.services.codebuild.Cache;
import software.amazon.awscdk.services.codebuild.CfnProject;
import software.amazon.awscdk.services.codebuild.IArtifacts;
import software.amazon.awscdk.services.codebuild.IFileSystemLocation;
import software.amazon.awscdk.services.codebuild.IProject;
import software.amazon.awscdk.services.codebuild.ISource;
import software.amazon.awscdk.services.codebuild.ProjectProps;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.events.OnEventOptions;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-codebuild.Project")
public class Project
extends Resource
implements IProject {
    protected Project(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Project(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Project(@NotNull Construct scope, @NotNull String id, @NotNull ProjectProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IProject fromProjectArn(@NotNull Construct scope, @NotNull String id, @NotNull String projectArn) {
        return (IProject)JsiiObject.jsiiStaticCall(Project.class, (String)"fromProjectArn", IProject.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(projectArn, "projectArn is required")});
    }

    @NotNull
    public static IProject fromProjectName(@NotNull Construct scope, @NotNull String id, @NotNull String projectName) {
        return (IProject)JsiiObject.jsiiStaticCall(Project.class, (String)"fromProjectName", IProject.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(projectName, "projectName is required")});
    }

    @NotNull
    public static List<CfnProject.EnvironmentVariableProperty> serializeEnvVariables(@NotNull Map<String, BuildEnvironmentVariable> environmentVariables) {
        return Collections.unmodifiableList((List)JsiiObject.jsiiStaticCall(Project.class, (String)"serializeEnvVariables", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnProject.EnvironmentVariableProperty.class)), (Object[])new Object[]{Objects.requireNonNull(environmentVariables, "environmentVariables is required")}));
    }

    public void addFileSystemLocation(@NotNull IFileSystemLocation fileSystemLocation) {
        this.jsiiCall("addFileSystemLocation", NativeType.VOID, new Object[]{Objects.requireNonNull(fileSystemLocation, "fileSystemLocation is required")});
    }

    public void addSecondaryArtifact(@NotNull IArtifacts secondaryArtifact) {
        this.jsiiCall("addSecondaryArtifact", NativeType.VOID, new Object[]{Objects.requireNonNull(secondaryArtifact, "secondaryArtifact is required")});
    }

    public void addSecondarySource(@NotNull ISource secondarySource) {
        this.jsiiCall("addSecondarySource", NativeType.VOID, new Object[]{Objects.requireNonNull(secondarySource, "secondarySource is required")});
    }

    @Override
    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void bindToCodePipeline(@NotNull Construct _scope, @NotNull BindToCodePipelineOptions options) {
        this.jsiiCall("bindToCodePipeline", NativeType.VOID, new Object[]{Objects.requireNonNull(_scope, "_scope is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricBuilds(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricBuilds", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricBuilds() {
        return (Metric)this.jsiiCall("metricBuilds", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricDuration(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricDuration", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricDuration() {
        return (Metric)this.jsiiCall("metricDuration", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricFailedBuilds(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricFailedBuilds", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricFailedBuilds() {
        return (Metric)this.jsiiCall("metricFailedBuilds", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSucceededBuilds(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricSucceededBuilds", Metric.class, new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSucceededBuilds() {
        return (Metric)this.jsiiCall("metricSucceededBuilds", Metric.class, new Object[0]);
    }

    @Override
    @NotNull
    public Rule onBuildFailed(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onBuildFailed", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onBuildFailed(@NotNull String id) {
        return (Rule)this.jsiiCall("onBuildFailed", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onBuildStarted(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onBuildStarted", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onBuildStarted(@NotNull String id) {
        return (Rule)this.jsiiCall("onBuildStarted", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onBuildSucceeded(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onBuildSucceeded", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onBuildSucceeded(@NotNull String id) {
        return (Rule)this.jsiiCall("onBuildSucceeded", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id) {
        return (Rule)this.jsiiCall("onEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onPhaseChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onPhaseChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onPhaseChange(@NotNull String id) {
        return (Rule)this.jsiiCall("onPhaseChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onStateChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id) {
        return (Rule)this.jsiiCall("onStateChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)this.jsiiGet("grantPrincipal", IPrincipal.class);
    }

    @Override
    @NotNull
    public String getProjectArn() {
        return (String)this.jsiiGet("projectArn", String.class);
    }

    @Override
    @NotNull
    public String getProjectName() {
        return (String)this.jsiiGet("projectName", String.class);
    }

    @Override
    @Nullable
    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final ProjectProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ProjectProps.Builder();
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        public Builder badge(Boolean badge) {
            this.props.badge(badge);
            return this;
        }

        public Builder buildSpec(BuildSpec buildSpec) {
            this.props.buildSpec(buildSpec);
            return this;
        }

        public Builder cache(Cache cache) {
            this.props.cache(cache);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder environment(BuildEnvironment environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environmentVariables(Map<String, BuildEnvironmentVariable> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        public Builder fileSystemLocations(List<IFileSystemLocation> fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }

        public Builder grantReportGroupPermissions(Boolean grantReportGroupPermissions) {
            this.props.grantReportGroupPermissions(grantReportGroupPermissions);
            return this;
        }

        public Builder projectName(String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder securityGroups(List<ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder artifacts(IArtifacts artifacts) {
            this.props.artifacts(artifacts);
            return this;
        }

        public Builder secondaryArtifacts(List<IArtifacts> secondaryArtifacts) {
            this.props.secondaryArtifacts(secondaryArtifacts);
            return this;
        }

        public Builder secondarySources(List<ISource> secondarySources) {
            this.props.secondarySources(secondarySources);
            return this;
        }

        public Builder source(ISource source) {
            this.props.source(source);
            return this;
        }

        public Project build() {
            return new Project(this.scope, this.id, this.props.build());
        }
    }
}

