/**
 * <h1>AWS::CodeGuruProfiler Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Amazon CodeGuru Profiler collects runtime performance data from your live applications, and provides recommendations that can help you fine-tune your application performance.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Import to your project:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codeguruprofiler.*;
 * </pre></blockquote>
 * <p>
 * <h2>Basic usage</h2>
 * <p>
 * Here's how to setup a profiling group and give your compute role permissions to publish to the profiling group to the profiling agent can publish profiling information:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * // The execution role of your application that publishes to the ProfilingGroup via CodeGuru Profiler Profiling Agent. (the following is merely an example)
 * Object publishAppRole = Role.Builder.create(stack, "PublishAppRole")
 *         .assumedBy(new AccountRootPrincipal())
 *         .build();
 * 
 * Object profilingGroup = new ProfilingGroup(stack, "MyProfilingGroup");
 * profilingGroup.grantPublish(publishAppRole);
 * </pre></blockquote>
 * <p>
 * <h2>Compute Platform configuration</h2>
 * <p>
 * Code Guru Profiler supports multiple compute environments.
 * They can be configured when creating a Profiling Group by using the <code>computePlatform</code> property:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Object profilingGroup = ProfilingGroup.Builder.create(stack, "MyProfilingGroup")
 *         .computePlatform(ComputePlatform.getAWS_LAMBDA())
 *         .build();
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.codeguruprofiler;
