package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of the {@link LambdaInvokeAction Lambda invoke CodePipeline Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-29T20:31:33.550Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.actions.$Module.class, fqn = "@aws-cdk/aws-codepipeline-actions.LambdaInvokeActionProps")
@software.amazon.jsii.Jsii.Proxy(LambdaInvokeActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaInvokeActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * The lambda function to invoke.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getLambda();

    /**
     * The optional input Artifacts of the Action.
     * <p>
     * A Lambda Action can have up to 5 inputs.
     * The inputs will appear in the event passed to the Lambda,
     * under the <code>'CodePipeline.job'.data.inputArtifacts</code> path.
     * <p>
     * Default: the Action will not have any inputs
     * <p>
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getInputs() {
        return null;
    }

    /**
     * The optional names of the output Artifacts of the Action.
     * <p>
     * A Lambda Action can have up to 5 outputs.
     * The outputs will appear in the event passed to the Lambda,
     * under the <code>'CodePipeline.job'.data.outputArtifacts</code> path.
     * It is the responsibility of the Lambda to upload ZIP files with the Artifact contents to the provided locations.
     * <p>
     * Default: the Action will not have any outputs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getOutputs() {
        return null;
    }

    /**
     * A set of key-value pairs that will be accessible to the invoked Lambda inside the event that the Pipeline will call it with.
     * <p>
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-invoke-lambda-function.html#actions-invoke-lambda-function-json-event-example
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getUserParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaInvokeActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaInvokeActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaInvokeActionProps> {
        private software.amazon.awscdk.services.lambda.IFunction lambda;
        private java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> inputs;
        private java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> outputs;
        private java.util.Map<java.lang.String, java.lang.Object> userParameters;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.lang.String actionName;
        private java.lang.Number runOrder;
        private java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link LambdaInvokeActionProps#getLambda}
         * @param lambda The lambda function to invoke. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambda(software.amazon.awscdk.services.lambda.IFunction lambda) {
            this.lambda = lambda;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeActionProps#getInputs}
         * @param inputs The optional input Artifacts of the Action.
         *               A Lambda Action can have up to 5 inputs.
         *               The inputs will appear in the event passed to the Lambda,
         *               under the <code>'CodePipeline.job'.data.inputArtifacts</code> path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder inputs(java.util.List<? extends software.amazon.awscdk.services.codepipeline.Artifact> inputs) {
            this.inputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)inputs;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeActionProps#getOutputs}
         * @param outputs The optional names of the output Artifacts of the Action.
         *                A Lambda Action can have up to 5 outputs.
         *                The outputs will appear in the event passed to the Lambda,
         *                under the <code>'CodePipeline.job'.data.outputArtifacts</code> path.
         *                It is the responsibility of the Lambda to upload ZIP files with the Artifact contents to the provided locations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder outputs(java.util.List<? extends software.amazon.awscdk.services.codepipeline.Artifact> outputs) {
            this.outputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)outputs;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeActionProps#getUserParameters}
         * @param userParameters A set of key-value pairs that will be accessible to the invoked Lambda inside the event that the Pipeline will call it with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder userParameters(java.util.Map<java.lang.String, ? extends java.lang.Object> userParameters) {
            this.userParameters = (java.util.Map<java.lang.String, java.lang.Object>)userParameters;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your {&#64;link IAction.bind}
         *             method in the {&#64;link ActionBindOptions.role} property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link LambdaInvokeActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaInvokeActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaInvokeActionProps build() {
            return new Jsii$Proxy(lambda, inputs, outputs, userParameters, role, actionName, runOrder, variablesNamespace);
        }
    }

    /**
     * An implementation for {@link LambdaInvokeActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaInvokeActionProps {
        private final software.amazon.awscdk.services.lambda.IFunction lambda;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> inputs;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> outputs;
        private final java.util.Map<java.lang.String, java.lang.Object> userParameters;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lambda = software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.inputs = software.amazon.jsii.Kernel.get(this, "inputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class)));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class)));
            this.userParameters = software.amazon.jsii.Kernel.get(this, "userParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.lambda.IFunction lambda, final java.util.List<? extends software.amazon.awscdk.services.codepipeline.Artifact> inputs, final java.util.List<? extends software.amazon.awscdk.services.codepipeline.Artifact> outputs, final java.util.Map<java.lang.String, ? extends java.lang.Object> userParameters, final software.amazon.awscdk.services.iam.IRole role, final java.lang.String actionName, final java.lang.Number runOrder, final java.lang.String variablesNamespace) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lambda = java.util.Objects.requireNonNull(lambda, "lambda is required");
            this.inputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)inputs;
            this.outputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)outputs;
            this.userParameters = (java.util.Map<java.lang.String, java.lang.Object>)userParameters;
            this.role = role;
            this.actionName = java.util.Objects.requireNonNull(actionName, "actionName is required");
            this.runOrder = runOrder;
            this.variablesNamespace = variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getLambda() {
            return this.lambda;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getInputs() {
            return this.inputs;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getOutputs() {
            return this.outputs;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getUserParameters() {
            return this.userParameters;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lambda", om.valueToTree(this.getLambda()));
            if (this.getInputs() != null) {
                data.set("inputs", om.valueToTree(this.getInputs()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getUserParameters() != null) {
                data.set("userParameters", om.valueToTree(this.getUserParameters()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline-actions.LambdaInvokeActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaInvokeActionProps.Jsii$Proxy that = (LambdaInvokeActionProps.Jsii$Proxy) o;

            if (!lambda.equals(that.lambda)) return false;
            if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            if (this.userParameters != null ? !this.userParameters.equals(that.userParameters) : that.userParameters != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.lambda.hashCode();
            result = 31 * result + (this.inputs != null ? this.inputs.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.userParameters != null ? this.userParameters.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
