package software.amazon.awscdk.services.codepipeline.actions;

/**
 * How should the S3 Action detect changes.
 * <p>
 * This is the type of the {&#64;link S3SourceAction.trigger} property.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-29T20:31:34.868Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.actions.$Module.class, fqn = "@aws-cdk/aws-codepipeline-actions.S3Trigger")
public enum S3Trigger {
    /**
     * The Action will never detect changes - the Pipeline it's part of will only begin a run when explicitly started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * CodePipeline will poll S3 to detect changes.
     * <p>
     * This is the default method of detecting changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POLL,
    /**
     * CodePipeline will use CloudWatch Events to be notified of changes.
     * <p>
     * Note that the Bucket that the Action uses needs to be part of a CloudTrail Trail
     * for the events to be delivered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EVENTS,
}
