package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of the {@link ServiceCatalogDeployActionBeta1 ServiceCatalog deploy CodePipeline Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-29T20:31:34.868Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.actions.$Module.class, fqn = "@aws-cdk/aws-codepipeline-actions.ServiceCatalogDeployActionBeta1Props")
@software.amazon.jsii.Jsii.Proxy(ServiceCatalogDeployActionBeta1Props.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceCatalogDeployActionBeta1Props extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * The identifier of the product in the Service Catalog.
     * <p>
     * This product must already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProductId();

    /**
     * The name of the version of the Service Catalog product to be deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProductVersionName();

    /**
     * The path to the cloudformation artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ArtifactPath getTemplatePath();

    /**
     * The optional description of this version of the Service Catalog product.
     * <p>
     * Default: ''
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProductVersionDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServiceCatalogDeployActionBeta1Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceCatalogDeployActionBeta1Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceCatalogDeployActionBeta1Props> {
        private java.lang.String productId;
        private java.lang.String productVersionName;
        private software.amazon.awscdk.services.codepipeline.ArtifactPath templatePath;
        private java.lang.String productVersionDescription;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.lang.String actionName;
        private java.lang.Number runOrder;
        private java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link ServiceCatalogDeployActionBeta1Props#getProductId}
         * @param productId The identifier of the product in the Service Catalog. This parameter is required.
         *                  This product must already exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productId(java.lang.String productId) {
            this.productId = productId;
            return this;
        }

        /**
         * Sets the value of {@link ServiceCatalogDeployActionBeta1Props#getProductVersionName}
         * @param productVersionName The name of the version of the Service Catalog product to be deployed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productVersionName(java.lang.String productVersionName) {
            this.productVersionName = productVersionName;
            return this;
        }

        /**
         * Sets the value of {@link ServiceCatalogDeployActionBeta1Props#getTemplatePath}
         * @param templatePath The path to the cloudformation artifact. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templatePath(software.amazon.awscdk.services.codepipeline.ArtifactPath templatePath) {
            this.templatePath = templatePath;
            return this;
        }

        /**
         * Sets the value of {@link ServiceCatalogDeployActionBeta1Props#getProductVersionDescription}
         * @param productVersionDescription The optional description of this version of the Service Catalog product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productVersionDescription(java.lang.String productVersionDescription) {
            this.productVersionDescription = productVersionDescription;
            return this;
        }

        /**
         * Sets the value of {@link ServiceCatalogDeployActionBeta1Props#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your {&#64;link IAction.bind}
         *             method in the {&#64;link ActionBindOptions.role} property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ServiceCatalogDeployActionBeta1Props#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link ServiceCatalogDeployActionBeta1Props#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link ServiceCatalogDeployActionBeta1Props#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceCatalogDeployActionBeta1Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceCatalogDeployActionBeta1Props build() {
            return new Jsii$Proxy(productId, productVersionName, templatePath, productVersionDescription, role, actionName, runOrder, variablesNamespace);
        }
    }

    /**
     * An implementation for {@link ServiceCatalogDeployActionBeta1Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceCatalogDeployActionBeta1Props {
        private final java.lang.String productId;
        private final java.lang.String productVersionName;
        private final software.amazon.awscdk.services.codepipeline.ArtifactPath templatePath;
        private final java.lang.String productVersionDescription;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.productId = software.amazon.jsii.Kernel.get(this, "productId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productVersionName = software.amazon.jsii.Kernel.get(this, "productVersionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templatePath = software.amazon.jsii.Kernel.get(this, "templatePath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ArtifactPath.class));
            this.productVersionDescription = software.amazon.jsii.Kernel.get(this, "productVersionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String productId, final java.lang.String productVersionName, final software.amazon.awscdk.services.codepipeline.ArtifactPath templatePath, final java.lang.String productVersionDescription, final software.amazon.awscdk.services.iam.IRole role, final java.lang.String actionName, final java.lang.Number runOrder, final java.lang.String variablesNamespace) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.productId = java.util.Objects.requireNonNull(productId, "productId is required");
            this.productVersionName = java.util.Objects.requireNonNull(productVersionName, "productVersionName is required");
            this.templatePath = java.util.Objects.requireNonNull(templatePath, "templatePath is required");
            this.productVersionDescription = productVersionDescription;
            this.role = role;
            this.actionName = java.util.Objects.requireNonNull(actionName, "actionName is required");
            this.runOrder = runOrder;
            this.variablesNamespace = variablesNamespace;
        }

        @Override
        public final java.lang.String getProductId() {
            return this.productId;
        }

        @Override
        public final java.lang.String getProductVersionName() {
            return this.productVersionName;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.ArtifactPath getTemplatePath() {
            return this.templatePath;
        }

        @Override
        public final java.lang.String getProductVersionDescription() {
            return this.productVersionDescription;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("productId", om.valueToTree(this.getProductId()));
            data.set("productVersionName", om.valueToTree(this.getProductVersionName()));
            data.set("templatePath", om.valueToTree(this.getTemplatePath()));
            if (this.getProductVersionDescription() != null) {
                data.set("productVersionDescription", om.valueToTree(this.getProductVersionDescription()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline-actions.ServiceCatalogDeployActionBeta1Props"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceCatalogDeployActionBeta1Props.Jsii$Proxy that = (ServiceCatalogDeployActionBeta1Props.Jsii$Proxy) o;

            if (!productId.equals(that.productId)) return false;
            if (!productVersionName.equals(that.productVersionName)) return false;
            if (!templatePath.equals(that.templatePath)) return false;
            if (this.productVersionDescription != null ? !this.productVersionDescription.equals(that.productVersionDescription) : that.productVersionDescription != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.productId.hashCode();
            result = 31 * result + (this.productVersionName.hashCode());
            result = 31 * result + (this.templatePath.hashCode());
            result = 31 * result + (this.productVersionDescription != null ? this.productVersionDescription.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
