/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.CloudFormationExecuteChangeSetActionProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiSerializable;

public interface CloudFormationExecuteChangeSetActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    public String getChangeSetName();

    public String getStackName();

    public String getAccount();

    public Artifact getOutput();

    public String getOutputFileName();

    public String getRegion();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String changeSetName;
        private String stackName;
        private String account;
        private Artifact output;
        private String outputFileName;
        private String region;
        private IRole role;
        private String actionName;
        private Number runOrder;

        public Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder output(Artifact output) {
            this.output = output;
            return this;
        }

        public Builder outputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public CloudFormationExecuteChangeSetActionProps build() {
            return new Jsii.Proxy(this.changeSetName, this.stackName, this.account, this.output, this.outputFileName, this.region, this.role, this.actionName, this.runOrder, null);
        }
    }
}

