/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import software.amazon.awscdk.services.codecommit.IRepository;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceActionProps;
import software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiSerializable;

public interface CodeCommitSourceActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    public Artifact getOutput();

    public IRepository getRepository();

    public String getBranch();

    public CodeCommitTrigger getTrigger();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Artifact output;
        private IRepository repository;
        private String branch;
        private CodeCommitTrigger trigger;
        private IRole role;
        private String actionName;
        private Number runOrder;

        public Builder output(Artifact output) {
            this.output = output;
            return this;
        }

        public Builder repository(IRepository repository) {
            this.repository = repository;
            return this;
        }

        public Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder trigger(CodeCommitTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public CodeCommitSourceActionProps build() {
            return new Jsii.Proxy(this.output, this.repository, this.branch, this.trigger, this.role, this.actionName, this.runOrder, null);
        }
    }
}

