/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.ArtifactPath;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.EcsDeployActionProps;
import software.amazon.awscdk.services.ecs.BaseService;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiSerializable;

public interface EcsDeployActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    public BaseService getService();

    public ArtifactPath getImageFile();

    public Artifact getInput();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BaseService service;
        private ArtifactPath imageFile;
        private Artifact input;
        private IRole role;
        private String actionName;
        private Number runOrder;

        public Builder service(BaseService service) {
            this.service = service;
            return this;
        }

        public Builder imageFile(ArtifactPath imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        public Builder input(Artifact input) {
            this.input = input;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public EcsDeployActionProps build() {
            return new Jsii.Proxy(this.service, this.imageFile, this.input, this.role, this.actionName, this.runOrder, null);
        }
    }
}

