/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import software.amazon.awscdk.core.SecretValue;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonActionProps;
import software.amazon.awscdk.services.codepipeline.actions.GitHubSourceActionProps;
import software.amazon.awscdk.services.codepipeline.actions.GitHubTrigger;
import software.amazon.jsii.JsiiSerializable;

public interface GitHubSourceActionProps
extends JsiiSerializable,
CommonActionProps {
    public SecretValue getOauthToken();

    public Artifact getOutput();

    public String getOwner();

    public String getRepo();

    public String getBranch();

    public GitHubTrigger getTrigger();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SecretValue oauthToken;
        private Artifact output;
        private String owner;
        private String repo;
        private String branch;
        private GitHubTrigger trigger;
        private String actionName;
        private Number runOrder;

        public Builder oauthToken(SecretValue oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        public Builder output(Artifact output) {
            this.output = output;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder repo(String repo) {
            this.repo = repo;
            return this;
        }

        public Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder trigger(GitHubTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public GitHubSourceActionProps build() {
            return new Jsii.Proxy(this.oauthToken, this.output, this.owner, this.repo, this.branch, this.trigger, this.actionName, this.runOrder, null);
        }
    }
}

