/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.S3SourceActionProps;
import software.amazon.awscdk.services.codepipeline.actions.S3Trigger;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiSerializable;

public interface S3SourceActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    public IBucket getBucket();

    public String getBucketKey();

    public Artifact getOutput();

    public S3Trigger getTrigger();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket bucket;
        private String bucketKey;
        private Artifact output;
        private S3Trigger trigger;
        private IRole role;
        private String actionName;
        private Number runOrder;

        public Builder bucket(IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder bucketKey(String bucketKey) {
            this.bucketKey = bucketKey;
            return this;
        }

        public Builder output(Artifact output) {
            this.output = output;
            return this;
        }

        public Builder trigger(S3Trigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public S3SourceActionProps build() {
            return new Jsii.Proxy(this.bucket, this.bucketKey, this.output, this.trigger, this.role, this.actionName, this.runOrder, null);
        }
    }
}

