package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The type of the CodeBuild action that determines its CodePipeline Category - Build, or Test.
 * <p>
 * The default is Build.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * PipelineProject project;
 * Artifact sourceOutput = new Artifact();
 * CodeBuildAction testAction = CodeBuildAction.Builder.create()
 *         .actionName("IntegrationTest")
 *         .project(project)
 *         .input(sourceOutput)
 *         .type(CodeBuildActionType.TEST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-10T17:06:03.225Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.actions.$Module.class, fqn = "@aws-cdk/aws-codepipeline-actions.CodeBuildActionType")
public enum CodeBuildActionType {
    /**
     * The action will have the Build Category.
     * <p>
     * This is the default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD,
    /**
     * The action will have the Test Category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEST,
}
