/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import java.util.List;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.;
import software.amazon.awscdk.services.codepipeline.actions.CacheControl;
import software.amazon.awscdk.services.codepipeline.actions.S3DeployActionProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.s3.BucketAccessControl;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-codepipeline-actions.S3DeployActionProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface S3DeployActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    public IBucket getBucket();

    public Artifact getInput();

    default public BucketAccessControl getAccessControl() {
        return null;
    }

    default public List<CacheControl> getCacheControl() {
        return null;
    }

    default public Boolean getExtract() {
        return null;
    }

    default public String getObjectKey() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket bucket;
        private Artifact input;
        private BucketAccessControl accessControl;
        private List<CacheControl> cacheControl;
        private Boolean extract;
        private String objectKey;
        private IRole role;
        private String actionName;
        private Number runOrder;
        private String variablesNamespace;

        public Builder bucket(IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder input(Artifact input) {
            this.input = input;
            return this;
        }

        public Builder accessControl(BucketAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        public Builder cacheControl(List<CacheControl> cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder extract(Boolean extract) {
            this.extract = extract;
            return this;
        }

        public Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public Builder variablesNamespace(String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        public S3DeployActionProps build() {
            return new Jsii.Proxy(this.bucket, this.input, this.accessControl, this.cacheControl, this.extract, this.objectKey, this.role, this.actionName, this.runOrder, this.variablesNamespace, null);
        }
    }
}

