/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import java.util.List;
import software.amazon.awscdk.services.codebuild.IProject;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.CodeBuildActionProps;
import software.amazon.awscdk.services.codepipeline.actions.CodeBuildActionType;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiSerializable;

public interface CodeBuildActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    public Artifact getInput();

    public IProject getProject();

    public List<Artifact> getExtraInputs();

    public List<Artifact> getOutputs();

    public CodeBuildActionType getType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Artifact input;
        private IProject project;
        private List<Artifact> extraInputs;
        private List<Artifact> outputs;
        private CodeBuildActionType type;
        private IRole role;
        private String actionName;
        private Number runOrder;

        public Builder input(Artifact input) {
            this.input = input;
            return this;
        }

        public Builder project(IProject project) {
            this.project = project;
            return this;
        }

        public Builder extraInputs(List<Artifact> extraInputs) {
            this.extraInputs = extraInputs;
            return this;
        }

        public Builder outputs(List<Artifact> outputs) {
            this.outputs = outputs;
            return this;
        }

        public Builder type(CodeBuildActionType type) {
            this.type = type;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public CodeBuildActionProps build() {
            return new Jsii.Proxy(this.input, this.project, this.extraInputs, this.outputs, this.type, this.role, this.actionName, this.runOrder, null);
        }
    }
}

