/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.EcrSourceActionProps;
import software.amazon.awscdk.services.ecr.IRepository;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiSerializable;

public interface EcrSourceActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    public Artifact getOutput();

    public IRepository getRepository();

    public String getImageTag();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Artifact output;
        private IRepository repository;
        private String imageTag;
        private IRole role;
        private String actionName;
        private Number runOrder;

        public Builder output(Artifact output) {
            this.output = output;
            return this;
        }

        public Builder repository(IRepository repository) {
            this.repository = repository;
            return this;
        }

        public Builder imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public EcrSourceActionProps build() {
            return new Jsii.Proxy(this.output, this.repository, this.imageTag, this.role, this.actionName, this.runOrder, null);
        }
    }
}

