/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import java.util.List;
import java.util.Map;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.LambdaInvokeActionProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.JsiiSerializable;

public interface LambdaInvokeActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    public IFunction getLambda();

    public List<Artifact> getInputs();

    public List<Artifact> getOutputs();

    public Map<String, Object> getUserParameters();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IFunction lambda;
        private List<Artifact> inputs;
        private List<Artifact> outputs;
        private Map<String, Object> userParameters;
        private IRole role;
        private String actionName;
        private Number runOrder;

        public Builder lambda(IFunction lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder inputs(List<Artifact> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder outputs(List<Artifact> outputs) {
            this.outputs = outputs;
            return this;
        }

        public Builder userParameters(Map<String, Object> userParameters) {
            this.userParameters = userParameters;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public LambdaInvokeActionProps build() {
            return new Jsii.Proxy(this.lambda, this.inputs, this.outputs, this.userParameters, this.role, this.actionName, this.runOrder, null);
        }
    }
}

