/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.CommonAwsActionProps;
import software.amazon.awscdk.services.codepipeline.actions.S3DeployActionProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiSerializable;

public interface S3DeployActionProps
extends JsiiSerializable,
CommonAwsActionProps {
    public IBucket getBucket();

    public Artifact getInput();

    public Boolean getExtract();

    public String getObjectKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket bucket;
        private Artifact input;
        private Boolean extract;
        private String objectKey;
        private IRole role;
        private String actionName;
        private Number runOrder;

        public Builder bucket(IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder input(Artifact input) {
            this.input = input;
            return this;
        }

        public Builder extract(Boolean extract) {
            this.extract = extract;
            return this;
        }

        public Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public S3DeployActionProps build() {
            return new Jsii.Proxy(this.bucket, this.input, this.extract, this.objectKey, this.role, this.actionName, this.runOrder, null);
        }
    }
}

