package software.amazon.awscdk.services.codepipeline.api;

/**
 * Low-level class for generic CodePipeline Actions.
 * It is recommended that concrete types are used instead, such as {@link codecommit.PipelineSourceAction} or
 * {@link codebuild.PipelineBuildAction}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.10 (build 35934ad)", date = "2018-11-12T19:56:57.175Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.api.$Module.class, fqn = "@aws-cdk/aws-codepipeline-api.Action")
public abstract class Action extends software.amazon.awscdk.Construct {
    protected Action(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    protected software.amazon.awscdk.services.codepipeline.api.Action addInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact artifact) {
        return this.jsiiCall("addInputArtifact", software.amazon.awscdk.services.codepipeline.api.Action.class, java.util.stream.Stream.of(artifact).toArray());
    }

    protected software.amazon.awscdk.services.codepipeline.api.Action addInputArtifact() {
        return this.jsiiCall("addInputArtifact", software.amazon.awscdk.services.codepipeline.api.Action.class);
    }

    protected software.amazon.awscdk.services.codepipeline.api.Artifact addOutputArtifact(@javax.annotation.Nullable final java.lang.String name) {
        return this.jsiiCall("addOutputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class, java.util.stream.Stream.of(name).toArray());
    }

    protected software.amazon.awscdk.services.codepipeline.api.Artifact addOutputArtifact() {
        return this.jsiiCall("addOutputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
    }

    public software.amazon.awscdk.services.events.EventRule onStateChange(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target, @javax.annotation.Nullable final software.amazon.awscdk.services.events.EventRuleProps options) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)), java.util.stream.Stream.of(options)).toArray());
    }

    public software.amazon.awscdk.services.events.EventRule onStateChange(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IEventRuleTarget target) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")), java.util.stream.Stream.of(target)).toArray());
    }

    public software.amazon.awscdk.services.events.EventRule onStateChange(final java.lang.String name) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.EventRule.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required")).toArray());
    }

    /**
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @Override
    public java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    /**
     * The category of the action.
     * The category defines which action type the owner
     * (the entity that performs the action) performs.
     */
    public software.amazon.awscdk.services.codepipeline.api.ActionCategory getCategory() {
        return this.jsiiGet("category", software.amazon.awscdk.services.codepipeline.api.ActionCategory.class);
    }

    public java.lang.String getOwner() {
        return this.jsiiGet("owner", java.lang.String.class);
    }

    /**
     * The service provider that the action calls.
     */
    public java.lang.String getProvider() {
        return this.jsiiGet("provider", java.lang.String.class);
    }

    /**
     * The order in which AWS CodePipeline runs this action.
     * For more information, see the AWS CodePipeline User Guide.
     * 
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    public java.lang.Number getRunOrder() {
        return this.jsiiGet("runOrder", java.lang.Number.class);
    }

    public java.lang.String getVersion() {
        return this.jsiiGet("version", java.lang.String.class);
    }

    /**
     * The action's configuration. These are key-value pairs that specify input values for an action.
     * For more information, see the AWS CodePipeline User Guide.
     * 
     * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    @javax.annotation.Nullable
    public java.lang.Object getConfiguration() {
        return this.jsiiGet("configuration", java.lang.Object.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.codepipeline.api.Action {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
    }
}
