package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a `CfnLocationFSxONTAP`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationFSxONTAPProps cfnLocationFSxONTAPProps = CfnLocationFSxONTAPProps.builder()
 *         .protocol(ProtocolProperty.builder()
 *                 .nfs(NFSProperty.builder()
 *                         .mountOptions(NfsMountOptionsProperty.builder()
 *                                 .version("version")
 *                                 .build())
 *                         .build())
 *                 .smb(SMBProperty.builder()
 *                         .mountOptions(SmbMountOptionsProperty.builder()
 *                                 .version("version")
 *                                 .build())
 *                         .password("password")
 *                         .user("user")
 *                         // the properties below are optional
 *                         .domain("domain")
 *                         .build())
 *                 .build())
 *         .securityGroupArns(List.of("securityGroupArns"))
 *         .storageVirtualMachineArn("storageVirtualMachineArn")
 *         // the properties below are optional
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:12.822Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.datasync.$Module.class, fqn = "@aws-cdk/aws-datasync.CfnLocationFSxONTAPProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocationFSxONTAPProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocationFSxONTAPProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getProtocol();

    /**
     * Specifies the Amazon Resource Names (ARNs) of the security groups that DataSync can use to access your FSx for ONTAP file system.
     * <p>
     * You must configure the security groups to allow outbound traffic on the following ports (depending on the protocol that you're using):
     * <p>
     * <ul>
     * <li><em>Network File System (NFS)</em> : TCP ports 111, 635, and 2049</li>
     * <li><em>Server Message Block (SMB)</em> : TCP port 445</li>
     * </ul>
     * <p>
     * Your file system's security groups must also allow inbound traffic on the same port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupArns();

    /**
     * Specifies the ARN of the storage virtual machine (SVM) in your file system where you want to copy data to or from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStorageVirtualMachineArn();

    /**
     * Specifies a path to the file share in the SVM where you'll copy your data.
     * <p>
     * You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares). For example, your mount path might be <code>/vol1</code> , <code>/vol1/tree1</code> , or <code>/share1</code> .
     * <p>
     * <blockquote>
     * <p>
     * Don't specify a junction path in the SVM's root volume. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP storage virtual machines</a> in the <em>Amazon FSx for NetApp ONTAP User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return null;
    }

    /**
     * Specifies labels that help you categorize, filter, and search for your AWS resources.
     * <p>
     * We recommend creating at least a name tag for your location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocationFSxONTAPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocationFSxONTAPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocationFSxONTAPProps> {
        java.lang.Object protocol;
        java.util.List<java.lang.String> securityGroupArns;
        java.lang.String storageVirtualMachineArn;
        java.lang.String subdirectory;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLocationFSxONTAPProps#getProtocol}
         * @param protocol Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.core.IResolvable protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxONTAPProps#getProtocol}
         * @param protocol Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP.ProtocolProperty protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxONTAPProps#getSecurityGroupArns}
         * @param securityGroupArns Specifies the Amazon Resource Names (ARNs) of the security groups that DataSync can use to access your FSx for ONTAP file system. This parameter is required.
         *                          You must configure the security groups to allow outbound traffic on the following ports (depending on the protocol that you're using):
         *                          <p>
         *                          <ul>
         *                          <li><em>Network File System (NFS)</em> : TCP ports 111, 635, and 2049</li>
         *                          <li><em>Server Message Block (SMB)</em> : TCP port 445</li>
         *                          </ul>
         *                          <p>
         *                          Your file system's security groups must also allow inbound traffic on the same port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupArns(java.util.List<java.lang.String> securityGroupArns) {
            this.securityGroupArns = securityGroupArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxONTAPProps#getStorageVirtualMachineArn}
         * @param storageVirtualMachineArn Specifies the ARN of the storage virtual machine (SVM) in your file system where you want to copy data to or from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageVirtualMachineArn(java.lang.String storageVirtualMachineArn) {
            this.storageVirtualMachineArn = storageVirtualMachineArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxONTAPProps#getSubdirectory}
         * @param subdirectory Specifies a path to the file share in the SVM where you'll copy your data.
         *                     You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares). For example, your mount path might be <code>/vol1</code> , <code>/vol1/tree1</code> , or <code>/share1</code> .
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     Don't specify a junction path in the SVM's root volume. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing FSx for ONTAP storage virtual machines</a> in the <em>Amazon FSx for NetApp ONTAP User Guide</em> .
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(java.lang.String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationFSxONTAPProps#getTags}
         * @param tags Specifies labels that help you categorize, filter, and search for your AWS resources.
         *             We recommend creating at least a name tag for your location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocationFSxONTAPProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocationFSxONTAPProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocationFSxONTAPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocationFSxONTAPProps {
        private final java.lang.Object protocol;
        private final java.util.List<java.lang.String> securityGroupArns;
        private final java.lang.String storageVirtualMachineArn;
        private final java.lang.String subdirectory;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityGroupArns = software.amazon.jsii.Kernel.get(this, "securityGroupArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.storageVirtualMachineArn = software.amazon.jsii.Kernel.get(this, "storageVirtualMachineArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            this.securityGroupArns = java.util.Objects.requireNonNull(builder.securityGroupArns, "securityGroupArns is required");
            this.storageVirtualMachineArn = java.util.Objects.requireNonNull(builder.storageVirtualMachineArn, "storageVirtualMachineArn is required");
            this.subdirectory = builder.subdirectory;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupArns() {
            return this.securityGroupArns;
        }

        @Override
        public final java.lang.String getStorageVirtualMachineArn() {
            return this.storageVirtualMachineArn;
        }

        @Override
        public final java.lang.String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("protocol", om.valueToTree(this.getProtocol()));
            data.set("securityGroupArns", om.valueToTree(this.getSecurityGroupArns()));
            data.set("storageVirtualMachineArn", om.valueToTree(this.getStorageVirtualMachineArn()));
            if (this.getSubdirectory() != null) {
                data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-datasync.CfnLocationFSxONTAPProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocationFSxONTAPProps.Jsii$Proxy that = (CfnLocationFSxONTAPProps.Jsii$Proxy) o;

            if (!protocol.equals(that.protocol)) return false;
            if (!securityGroupArns.equals(that.securityGroupArns)) return false;
            if (!storageVirtualMachineArn.equals(that.storageVirtualMachineArn)) return false;
            if (this.subdirectory != null ? !this.subdirectory.equals(that.subdirectory) : that.subdirectory != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.protocol.hashCode();
            result = 31 * result + (this.securityGroupArns.hashCode());
            result = 31 * result + (this.storageVirtualMachineArn.hashCode());
            result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
