package software.amazon.awscdk.services.datasync;

/**
 * A CloudFormation `AWS::DataSync::LocationSMB`.
 * <p>
 * The <code>AWS::DataSync::LocationSMB</code> resource specifies a Server Message Block (SMB) location.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationSMB cfnLocationSMB = CfnLocationSMB.Builder.create(this, "MyCfnLocationSMB")
 *         .agentArns(List.of("agentArns"))
 *         .user("user")
 *         // the properties below are optional
 *         .domain("domain")
 *         .mountOptions(MountOptionsProperty.builder()
 *                 .version("version")
 *                 .build())
 *         .password("password")
 *         .serverHostname("serverHostname")
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:12.849Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.datasync.$Module.class, fqn = "@aws-cdk/aws-datasync.CfnLocationSMB")
public class CfnLocationSMB extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnLocationSMB(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLocationSMB(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.datasync.CfnLocationSMB.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DataSync::LocationSMB`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLocationSMB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datasync.CfnLocationSMBProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the specified SMB file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLocationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URI of the specified SMB location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLocationUri() {
        return software.amazon.jsii.Kernel.get(this, "attrLocationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies labels that help you categorize, filter, and search for your AWS resources.
     * <p>
     * We recommend creating at least a name tag for your location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The Amazon Resource Names (ARNs) of agents to use for a Server Message Block (SMB) location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAgentArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "agentArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Amazon Resource Names (ARNs) of agents to use for a Server Message Block (SMB) location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentArns(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "agentArns", java.util.Objects.requireNonNull(value, "agentArns is required"));
    }

    /**
     * The user who can mount the share and has the permissions to access files and folders in the SMB share.
     * <p>
     * For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#SMBuser">user</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUser() {
        return software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user who can mount the share and has the permissions to access files and folders in the SMB share.
     * <p>
     * For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#SMBuser">user</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUser(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "user", java.util.Objects.requireNonNull(value, "user is required"));
    }

    /**
     * Specifies the Windows domain name that your SMB file server belongs to.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the Windows domain name that your SMB file server belongs to.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domain", value);
    }

    /**
     * Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMountOptions() {
        return software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMountOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mountOptions", value);
    }

    /**
     * Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMountOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnLocationSMB.MountOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "mountOptions", value);
    }

    /**
     * The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "password", value);
    }

    /**
     * Specifies the Domain Name Service (DNS) name or IP address of the SMB file server that your DataSync agent will mount.
     * <p>
     * <blockquote>
     * <p>
     * You can't specify an IP version 6 (IPv6) address.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerHostname() {
        return software.amazon.jsii.Kernel.get(this, "serverHostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the Domain Name Service (DNS) name or IP address of the SMB file server that your DataSync agent will mount.
     * <p>
     * <blockquote>
     * <p>
     * You can't specify an IP version 6 (IPv6) address.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerHostname(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverHostname", value);
    }

    /**
     * The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination.
     * <p>
     * The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.
     * <p>
     * <blockquote>
     * <p>
     * <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code> .
     * <p>
     * </blockquote>
     * <p>
     * To transfer all the data in the folder you specified, DataSync must have permissions to mount the SMB share, as well as to access all the data in that share. To ensure this, either make sure that the user name and password specified belongs to the user who can mount the share, and who has the appropriate permissions for all of the files and directories that you want DataSync to access, or use credentials of a member of the Backup Operators group to mount the share. Doing either one enables the agent to access the data. For the agent to access directories, you must additionally enable all execute access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination.
     * <p>
     * The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.
     * <p>
     * <blockquote>
     * <p>
     * <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code> .
     * <p>
     * </blockquote>
     * <p>
     * To transfer all the data in the folder you specified, DataSync must have permissions to mount the SMB share, as well as to access all the data in that share. To ensure this, either make sure that the user name and password specified belongs to the user who can mount the share, and who has the appropriate permissions for all of the files and directories that you want DataSync to access, or use credentials of a member of the Backup Operators group to mount the share. Doing either one enables the agent to access the data. For the agent to access directories, you must additionally enable all execute access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubdirectory(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "subdirectory", value);
    }
    /**
     * Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * MountOptionsProperty mountOptionsProperty = MountOptionsProperty.builder()
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.datasync.$Module.class, fqn = "@aws-cdk/aws-datasync.CfnLocationSMB.MountOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(MountOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MountOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * By default, DataSync automatically chooses an SMB protocol version based on negotiation with your SMB file server.
         * <p>
         * You also can configure DataSync to use a specific SMB version, but we recommend doing this only if DataSync has trouble negotiating with the SMB file server automatically.
         * <p>
         * These are the following options for configuring the SMB version:
         * <p>
         * <ul>
         * <li><code>AUTOMATIC</code> (default): DataSync and the SMB file server negotiate the highest version of SMB that they mutually support between 2.1 and 3.1.1.</li>
         * </ul>
         * <p>
         * This is the recommended option. If you instead choose a specific version that your file server doesn't support, you may get an <code>Operation Not Supported</code> error.
         * <p>
         * <ul>
         * <li><code>SMB3</code> : Restricts the protocol negotiation to only SMB version 3.0.2.</li>
         * <li><code>SMB2</code> : Restricts the protocol negotiation to only SMB version 2.1.</li>
         * <li><code>SMB2_0</code> : Restricts the protocol negotiation to only SMB version 2.0.</li>
         * <li><code>SMB1</code> : Restricts the protocol negotiation to only SMB version 1.0.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The <code>SMB1</code> option isn't available when <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateLocationFsxOntap.html">creating an Amazon FSx for NetApp ONTAP location</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MountOptionsProperty> {
            java.lang.String version;

            /**
             * Sets the value of {@link MountOptionsProperty#getVersion}
             * @param version By default, DataSync automatically chooses an SMB protocol version based on negotiation with your SMB file server.
             *                You also can configure DataSync to use a specific SMB version, but we recommend doing this only if DataSync has trouble negotiating with the SMB file server automatically.
             *                <p>
             *                These are the following options for configuring the SMB version:
             *                <p>
             *                <ul>
             *                <li><code>AUTOMATIC</code> (default): DataSync and the SMB file server negotiate the highest version of SMB that they mutually support between 2.1 and 3.1.1.</li>
             *                </ul>
             *                <p>
             *                This is the recommended option. If you instead choose a specific version that your file server doesn't support, you may get an <code>Operation Not Supported</code> error.
             *                <p>
             *                <ul>
             *                <li><code>SMB3</code> : Restricts the protocol negotiation to only SMB version 3.0.2.</li>
             *                <li><code>SMB2</code> : Restricts the protocol negotiation to only SMB version 2.1.</li>
             *                <li><code>SMB2_0</code> : Restricts the protocol negotiation to only SMB version 2.0.</li>
             *                <li><code>SMB1</code> : Restricts the protocol negotiation to only SMB version 1.0.</li>
             *                </ul>
             *                <p>
             *                <blockquote>
             *                <p>
             *                The <code>SMB1</code> option isn't available when <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateLocationFsxOntap.html">creating an Amazon FSx for NetApp ONTAP location</a> .
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MountOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MountOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MountOptionsProperty {
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-datasync.CfnLocationSMB.MountOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MountOptionsProperty.Jsii$Proxy that = (MountOptionsProperty.Jsii$Proxy) o;

                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.version != null ? this.version.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.datasync.CfnLocationSMB}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.datasync.CfnLocationSMB> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.datasync.CfnLocationSMBProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.datasync.CfnLocationSMBProps.Builder();
        }

        /**
         * The Amazon Resource Names (ARNs) of agents to use for a Server Message Block (SMB) location.
         * <p>
         * @return {@code this}
         * @param agentArns The Amazon Resource Names (ARNs) of agents to use for a Server Message Block (SMB) location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentArns(final java.util.List<java.lang.String> agentArns) {
            this.props.agentArns(agentArns);
            return this;
        }

        /**
         * The user who can mount the share and has the permissions to access files and folders in the SMB share.
         * <p>
         * For information about choosing a user name that ensures sufficient permissions to files, folders, and metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#SMBuser">user</a> .
         * <p>
         * @return {@code this}
         * @param user The user who can mount the share and has the permissions to access files and folders in the SMB share. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(final java.lang.String user) {
            this.props.user(user);
            return this;
        }

        /**
         * Specifies the Windows domain name that your SMB file server belongs to.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">required permissions</a> for SMB locations.
         * <p>
         * @return {@code this}
         * @param domain Specifies the Windows domain name that your SMB file server belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props.domain(domain);
            return this;
        }

        /**
         * Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
         * <p>
         * @return {@code this}
         * @param mountOptions Specifies the version of the SMB protocol that DataSync uses to access your SMB file server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountOptions(final software.amazon.awscdk.core.IResolvable mountOptions) {
            this.props.mountOptions(mountOptions);
            return this;
        }
        /**
         * Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
         * <p>
         * @return {@code this}
         * @param mountOptions Specifies the version of the SMB protocol that DataSync uses to access your SMB file server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountOptions(final software.amazon.awscdk.services.datasync.CfnLocationSMB.MountOptionsProperty mountOptions) {
            this.props.mountOptions(mountOptions);
            return this;
        }

        /**
         * The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
         * <p>
         * @return {@code this}
         * @param password The password of the user who can mount the share and has the permissions to access files and folders in the SMB share. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(final java.lang.String password) {
            this.props.password(password);
            return this;
        }

        /**
         * Specifies the Domain Name Service (DNS) name or IP address of the SMB file server that your DataSync agent will mount.
         * <p>
         * <blockquote>
         * <p>
         * You can't specify an IP version 6 (IPv6) address.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param serverHostname Specifies the Domain Name Service (DNS) name or IP address of the SMB file server that your DataSync agent will mount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverHostname(final java.lang.String serverHostname) {
            this.props.serverHostname(serverHostname);
            return this;
        }

        /**
         * The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination.
         * <p>
         * The SMB path should be a path that's exported by the SMB server, or a subdirectory of that path. The path should be such that it can be mounted by other SMB clients in your network.
         * <p>
         * <blockquote>
         * <p>
         * <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code> .
         * <p>
         * </blockquote>
         * <p>
         * To transfer all the data in the folder you specified, DataSync must have permissions to mount the SMB share, as well as to access all the data in that share. To ensure this, either make sure that the user name and password specified belongs to the user who can mount the share, and who has the appropriate permissions for all of the files and directories that you want DataSync to access, or use credentials of a member of the Backup Operators group to mount the share. Doing either one enables the agent to access the data. For the agent to access directories, you must additionally enable all execute access.
         * <p>
         * @return {@code this}
         * @param subdirectory The subdirectory in the SMB file system that is used to read data from the SMB source location or write data to the SMB destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(final java.lang.String subdirectory) {
            this.props.subdirectory(subdirectory);
            return this;
        }

        /**
         * Specifies labels that help you categorize, filter, and search for your AWS resources.
         * <p>
         * We recommend creating at least a name tag for your location.
         * <p>
         * @return {@code this}
         * @param tags Specifies labels that help you categorize, filter, and search for your AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.datasync.CfnLocationSMB}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.datasync.CfnLocationSMB build() {
            return new software.amazon.awscdk.services.datasync.CfnLocationSMB(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
