package software.amazon.awscdk.services.ecs.patterns;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:20:57.462Z")
public interface ScheduledEc2TaskProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The cluster where your service will be deployed.
     */
    software.amazon.awscdk.services.ecs.ICluster getCluster();
    /**
     * The image to start.
     */
    software.amazon.awscdk.services.ecs.ContainerImage getImage();
    /**
     * The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
     * 
     * For more information, see Schedule Expression Syntax for
     * Rules in the Amazon CloudWatch User Guide.
     * 
     * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html
     */
    java.lang.String getScheduleExpression();
    /**
     * The CMD value to pass to the container.
     * 
     * A string with commands delimited by commas.
     * 
     * Default: none
     */
    java.util.List<java.lang.String> getCommand();
    /**
     * The minimum number of CPU units to reserve for the container.
     * 
     * Default: none
     */
    java.lang.Number getCpu();
    /**
     * Number of desired copies of running tasks.
     * 
     * Default: 1
     */
    java.lang.Number getDesiredTaskCount();
    /**
     * The environment variables to pass to the container.
     * 
     * Default: none
     */
    java.util.Map<java.lang.String, java.lang.String> getEnvironment();
    /**
     * The hard limit (in MiB) of memory to present to the container.
     * 
     * If your container attempts to exceed the allocated memory, the container
     * is terminated.
     * 
     * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
     * 
     * Default: - No memory limit.
     */
    java.lang.Number getMemoryLimitMiB();
    /**
     * The soft limit (in MiB) of memory to reserve for the container.
     * 
     * When system memory is under contention, Docker attempts to keep the
     * container memory within the limit. If the container requires more memory,
     * it can consume up to the value specified by the Memory property or all of
     * the available memory on the container instance—whichever comes first.
     * 
     * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
     * 
     * Default: - No memory reserved.
     */
    java.lang.Number getMemoryReservationMiB();

    /**
     * @return a {@link Builder} of {@link ScheduledEc2TaskProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ScheduledEc2TaskProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.ecs.ICluster _cluster;
        private software.amazon.awscdk.services.ecs.ContainerImage _image;
        private java.lang.String _scheduleExpression;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _command;
        @javax.annotation.Nullable
        private java.lang.Number _cpu;
        @javax.annotation.Nullable
        private java.lang.Number _desiredTaskCount;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _environment;
        @javax.annotation.Nullable
        private java.lang.Number _memoryLimitMiB;
        @javax.annotation.Nullable
        private java.lang.Number _memoryReservationMiB;

        /**
         * Sets the value of Cluster
         * @param value The cluster where your service will be deployed.
         * @return {@code this}
         */
        public Builder withCluster(final software.amazon.awscdk.services.ecs.ICluster value) {
            this._cluster = java.util.Objects.requireNonNull(value, "cluster is required");
            return this;
        }
        /**
         * Sets the value of Image
         * @param value The image to start.
         * @return {@code this}
         */
        public Builder withImage(final software.amazon.awscdk.services.ecs.ContainerImage value) {
            this._image = java.util.Objects.requireNonNull(value, "image is required");
            return this;
        }
        /**
         * Sets the value of ScheduleExpression
         * @param value The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
         * @return {@code this}
         */
        public Builder withScheduleExpression(final java.lang.String value) {
            this._scheduleExpression = java.util.Objects.requireNonNull(value, "scheduleExpression is required");
            return this;
        }
        /**
         * Sets the value of Command
         * @param value The CMD value to pass to the container.
         * @return {@code this}
         */
        public Builder withCommand(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._command = value;
            return this;
        }
        /**
         * Sets the value of Cpu
         * @param value The minimum number of CPU units to reserve for the container.
         * @return {@code this}
         */
        public Builder withCpu(@javax.annotation.Nullable final java.lang.Number value) {
            this._cpu = value;
            return this;
        }
        /**
         * Sets the value of DesiredTaskCount
         * @param value Number of desired copies of running tasks.
         * @return {@code this}
         */
        public Builder withDesiredTaskCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._desiredTaskCount = value;
            return this;
        }
        /**
         * Sets the value of Environment
         * @param value The environment variables to pass to the container.
         * @return {@code this}
         */
        public Builder withEnvironment(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._environment = value;
            return this;
        }
        /**
         * Sets the value of MemoryLimitMiB
         * @param value The hard limit (in MiB) of memory to present to the container.
         * @return {@code this}
         */
        public Builder withMemoryLimitMiB(@javax.annotation.Nullable final java.lang.Number value) {
            this._memoryLimitMiB = value;
            return this;
        }
        /**
         * Sets the value of MemoryReservationMiB
         * @param value The soft limit (in MiB) of memory to reserve for the container.
         * @return {@code this}
         */
        public Builder withMemoryReservationMiB(@javax.annotation.Nullable final java.lang.Number value) {
            this._memoryReservationMiB = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledEc2TaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ScheduledEc2TaskProps build() {
            return new ScheduledEc2TaskProps() {
                private final software.amazon.awscdk.services.ecs.ICluster $cluster = java.util.Objects.requireNonNull(_cluster, "cluster is required");
                private final software.amazon.awscdk.services.ecs.ContainerImage $image = java.util.Objects.requireNonNull(_image, "image is required");
                private final java.lang.String $scheduleExpression = java.util.Objects.requireNonNull(_scheduleExpression, "scheduleExpression is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $command = _command;
                @javax.annotation.Nullable
                private final java.lang.Number $cpu = _cpu;
                @javax.annotation.Nullable
                private final java.lang.Number $desiredTaskCount = _desiredTaskCount;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $environment = _environment;
                @javax.annotation.Nullable
                private final java.lang.Number $memoryLimitMiB = _memoryLimitMiB;
                @javax.annotation.Nullable
                private final java.lang.Number $memoryReservationMiB = _memoryReservationMiB;

                @Override
                public software.amazon.awscdk.services.ecs.ICluster getCluster() {
                    return this.$cluster;
                }

                @Override
                public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
                    return this.$image;
                }

                @Override
                public java.lang.String getScheduleExpression() {
                    return this.$scheduleExpression;
                }

                @Override
                public java.util.List<java.lang.String> getCommand() {
                    return this.$command;
                }

                @Override
                public java.lang.Number getCpu() {
                    return this.$cpu;
                }

                @Override
                public java.lang.Number getDesiredTaskCount() {
                    return this.$desiredTaskCount;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
                    return this.$environment;
                }

                @Override
                public java.lang.Number getMemoryLimitMiB() {
                    return this.$memoryLimitMiB;
                }

                @Override
                public java.lang.Number getMemoryReservationMiB() {
                    return this.$memoryReservationMiB;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("cluster", om.valueToTree(this.getCluster()));
                    obj.set("image", om.valueToTree(this.getImage()));
                    obj.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                    obj.set("command", om.valueToTree(this.getCommand()));
                    obj.set("cpu", om.valueToTree(this.getCpu()));
                    obj.set("desiredTaskCount", om.valueToTree(this.getDesiredTaskCount()));
                    obj.set("environment", om.valueToTree(this.getEnvironment()));
                    obj.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
                    obj.set("memoryReservationMiB", om.valueToTree(this.getMemoryReservationMiB()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The cluster where your service will be deployed.
         */
        @Override
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
        }

        /**
         * The image to start.
         */
        @Override
        public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.jsiiGet("image", software.amazon.awscdk.services.ecs.ContainerImage.class);
        }

        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
         * 
         * For more information, see Schedule Expression Syntax for
         * Rules in the Amazon CloudWatch User Guide.
         * 
         * @see http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html
         */
        @Override
        public java.lang.String getScheduleExpression() {
            return this.jsiiGet("scheduleExpression", java.lang.String.class);
        }

        /**
         * The CMD value to pass to the container.
         * 
         * A string with commands delimited by commas.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getCommand() {
            return this.jsiiGet("command", java.util.List.class);
        }

        /**
         * The minimum number of CPU units to reserve for the container.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getCpu() {
            return this.jsiiGet("cpu", java.lang.Number.class);
        }

        /**
         * Number of desired copies of running tasks.
         * 
         * Default: 1
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getDesiredTaskCount() {
            return this.jsiiGet("desiredTaskCount", java.lang.Number.class);
        }

        /**
         * The environment variables to pass to the container.
         * 
         * Default: none
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.jsiiGet("environment", java.util.Map.class);
        }

        /**
         * The hard limit (in MiB) of memory to present to the container.
         * 
         * If your container attempts to exceed the allocated memory, the container
         * is terminated.
         * 
         * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * 
         * Default: - No memory limit.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getMemoryLimitMiB() {
            return this.jsiiGet("memoryLimitMiB", java.lang.Number.class);
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         * 
         * When system memory is under contention, Docker attempts to keep the
         * container memory within the limit. If the container requires more memory,
         * it can consume up to the value specified by the Memory property or all of
         * the available memory on the container instance—whichever comes first.
         * 
         * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * 
         * Default: - No memory reserved.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getMemoryReservationMiB() {
            return this.jsiiGet("memoryReservationMiB", java.lang.Number.class);
        }
    }
}
