package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the base ApplicationLoadBalancedEc2Service or ApplicationLoadBalancedFargateService service.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:21.898Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ApplicationLoadBalancedServiceBaseProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationLoadBalancedServiceBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancedServiceBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Certificate Manager certificate to associate with the load balancer.
     * <p>
     * Setting this option will set the load balancer protocol to HTTPS.
     * <p>
     * Default: - No certificate associated with the load balancer, if using
     * the HTTP protocol. For HTTPS, a DNS-validated certificate will be
     * created for the load balancer's specified domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
        return null;
    }

    /**
     * The options for configuring an Amazon ECS service to use service discovery.
     * <p>
     * Default: - AWS Cloud Map service discovery is not enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
        return null;
    }

    /**
     * The name of the cluster that hosts the service.
     * <p>
     * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
     * <p>
     * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return null;
    }

    /**
     * The desired number of instantiations of the task definition to keep running on the service.
     * <p>
     * The minimum value is 1
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCount() {
        return null;
    }

    /**
     * The domain name for the service, e.g. "api.example.com.".
     * <p>
     * Default: - No domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The Route53 hosted zone for the domain, e.g. "example.com.".
     * <p>
     * Default: - No Route53 hosted domain zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
        return null;
    }

    /**
     * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableEcsManagedTags() {
        return null;
    }

    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     * <p>
     * Default: - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getHealthCheckGracePeriod() {
        return null;
    }

    /**
     * Listener port of the application load balancer that will serve traffic to the service.
     * <p>
     * Default: - The default listener port is determined from the protocol (port 80 for HTTP,
     * port 443 for HTTPS). A domain name and zone must be also be specified if using HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getListenerPort() {
        return null;
    }

    /**
     * The application load balancer that will serve traffic to the service.
     * <p>
     * The VPC attribute of a load balancer must be specified for it to be used
     * to create a new service with this pattern.
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: - a new load balancer will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer getLoadBalancer() {
        return null;
    }

    /**
     * The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
     * <p>
     * Default: - 100 if daemon, otherwise 200
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxHealthyPercent() {
        return null;
    }

    /**
     * The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
     * <p>
     * Default: - 0 if daemon, otherwise 50
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinHealthyPercent() {
        return null;
    }

    /**
     * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     * <p>
     * Tags can only be propagated to the tasks within the service during service creation.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
        return null;
    }

    /**
     * The protocol for connections from clients to the load balancer.
     * <p>
     * The load balancer port is determined from the protocol (port 80 for
     * HTTP, port 443 for HTTPS).  A domain name and zone must be also be
     * specified if using HTTPS.
     * <p>
     * Default: HTTP. If a certificate is specified, the protocol will be
     * set by default to HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
        return null;
    }

    /**
     * Determines whether the Load Balancer will be internet-facing.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublicLoadBalancer() {
        return null;
    }

    /**
     * The name of the service.
     * <p>
     * Default: - CloudFormation-generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * The properties required to create a new task definition.
     * <p>
     * TaskDefinition or TaskImageOptions must be specified, but not both.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions getTaskImageOptions() {
        return null;
    }

    /**
     * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
     * <p>
     * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
     * <p>
     * Default: - uses the VPC defined in the cluster or creates a new VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancedServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationLoadBalancedServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private java.lang.Number desiredCount;
        private java.lang.String domainName;
        private software.amazon.awscdk.services.route53.IHostedZone domainZone;
        private java.lang.Boolean enableEcsManagedTags;
        private software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        private java.lang.Number listenerPort;
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer;
        private java.lang.Number maxHealthyPercent;
        private java.lang.Number minHealthyPercent;
        private software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private java.lang.Boolean publicLoadBalancer;
        private java.lang.String serviceName;
        private software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions taskImageOptions;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getCertificate}
         * @param certificate Certificate Manager certificate to associate with the load balancer.
         *                    Setting this option will set the load balancer protocol to HTTPS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getCloudMapOptions}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getDesiredCount}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service.
         *                     The minimum value is 1
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(java.lang.Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getDomainName}
         * @param domainName The domain name for the service, e.g. "api.example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getDomainZone}
         * @param domainZone The Route53 hosted zone for the domain, e.g. "example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainZone(software.amazon.awscdk.services.route53.IHostedZone domainZone) {
            this.domainZone = domainZone;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getHealthCheckGracePeriod}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(software.amazon.awscdk.core.Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getListenerPort}
         * @param listenerPort Listener port of the application load balancer that will serve traffic to the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerPort(java.lang.Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getLoadBalancer}
         * @param loadBalancer The application load balancer that will serve traffic to the service.
         *                     The VPC attribute of a load balancer must be specified for it to be used
         *                     to create a new service with this pattern.
         *                     <p>
         *                     [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getMaxHealthyPercent}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(java.lang.Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getMinHealthyPercent}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(java.lang.Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getProtocol}
         * @param protocol The protocol for connections from clients to the load balancer.
         *                 The load balancer port is determined from the protocol (port 80 for
         *                 HTTP, port 443 for HTTPS).  A domain name and zone must be also be
         *                 specified if using HTTPS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getPublicLoadBalancer}
         * @param publicLoadBalancer Determines whether the Load Balancer will be internet-facing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicLoadBalancer(java.lang.Boolean publicLoadBalancer) {
            this.publicLoadBalancer = publicLoadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getTaskImageOptions}
         * @param taskImageOptions The properties required to create a new task definition.
         *                         TaskDefinition or TaskImageOptions must be specified, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskImageOptions(software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedServiceBaseProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancedServiceBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationLoadBalancedServiceBaseProps build() {
            return new Jsii$Proxy(certificate, cloudMapOptions, cluster, desiredCount, domainName, domainZone, enableEcsManagedTags, healthCheckGracePeriod, listenerPort, loadBalancer, maxHealthyPercent, minHealthyPercent, propagateTags, protocol, publicLoadBalancer, serviceName, taskImageOptions, vpc);
        }
    }

    /**
     * An implementation for {@link ApplicationLoadBalancedServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancedServiceBaseProps {
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.lang.Number desiredCount;
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.route53.IHostedZone domainZone;
        private final java.lang.Boolean enableEcsManagedTags;
        private final software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        private final java.lang.Number listenerPort;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer;
        private final java.lang.Number maxHealthyPercent;
        private final java.lang.Number minHealthyPercent;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private final java.lang.Boolean publicLoadBalancer;
        private final java.lang.String serviceName;
        private final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions taskImageOptions;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificate = this.jsiiGet("certificate", software.amazon.awscdk.services.certificatemanager.ICertificate.class);
            this.cloudMapOptions = this.jsiiGet("cloudMapOptions", software.amazon.awscdk.services.ecs.CloudMapOptions.class);
            this.cluster = this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
            this.desiredCount = this.jsiiGet("desiredCount", java.lang.Number.class);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.domainZone = this.jsiiGet("domainZone", software.amazon.awscdk.services.route53.IHostedZone.class);
            this.enableEcsManagedTags = this.jsiiGet("enableECSManagedTags", java.lang.Boolean.class);
            this.healthCheckGracePeriod = this.jsiiGet("healthCheckGracePeriod", software.amazon.awscdk.core.Duration.class);
            this.listenerPort = this.jsiiGet("listenerPort", java.lang.Number.class);
            this.loadBalancer = this.jsiiGet("loadBalancer", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class);
            this.maxHealthyPercent = this.jsiiGet("maxHealthyPercent", java.lang.Number.class);
            this.minHealthyPercent = this.jsiiGet("minHealthyPercent", java.lang.Number.class);
            this.propagateTags = this.jsiiGet("propagateTags", software.amazon.awscdk.services.ecs.PropagatedTagSource.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class);
            this.publicLoadBalancer = this.jsiiGet("publicLoadBalancer", java.lang.Boolean.class);
            this.serviceName = this.jsiiGet("serviceName", java.lang.String.class);
            this.taskImageOptions = this.jsiiGet("taskImageOptions", software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.certificatemanager.ICertificate certificate, final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions, final software.amazon.awscdk.services.ecs.ICluster cluster, final java.lang.Number desiredCount, final java.lang.String domainName, final software.amazon.awscdk.services.route53.IHostedZone domainZone, final java.lang.Boolean enableEcsManagedTags, final software.amazon.awscdk.core.Duration healthCheckGracePeriod, final java.lang.Number listenerPort, final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer, final java.lang.Number maxHealthyPercent, final java.lang.Number minHealthyPercent, final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags, final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol, final java.lang.Boolean publicLoadBalancer, final java.lang.String serviceName, final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions taskImageOptions, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificate = certificate;
            this.cloudMapOptions = cloudMapOptions;
            this.cluster = cluster;
            this.desiredCount = desiredCount;
            this.domainName = domainName;
            this.domainZone = domainZone;
            this.enableEcsManagedTags = enableEcsManagedTags;
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            this.listenerPort = listenerPort;
            this.loadBalancer = loadBalancer;
            this.maxHealthyPercent = maxHealthyPercent;
            this.minHealthyPercent = minHealthyPercent;
            this.propagateTags = propagateTags;
            this.protocol = protocol;
            this.publicLoadBalancer = publicLoadBalancer;
            this.serviceName = serviceName;
            this.taskImageOptions = taskImageOptions;
            this.vpc = vpc;
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
            return this.cloudMapOptions;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public java.lang.Number getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
            return this.domainZone;
        }

        @Override
        public java.lang.Boolean getEnableEcsManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public software.amazon.awscdk.core.Duration getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public java.lang.Number getListenerPort() {
            return this.listenerPort;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public java.lang.Number getMaxHealthyPercent() {
            return this.maxHealthyPercent;
        }

        @Override
        public java.lang.Number getMinHealthyPercent() {
            return this.minHealthyPercent;
        }

        @Override
        public software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public java.lang.Boolean getPublicLoadBalancer() {
            return this.publicLoadBalancer;
        }

        @Override
        public java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions getTaskImageOptions() {
            return this.taskImageOptions;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getCloudMapOptions() != null) {
                data.set("cloudMapOptions", om.valueToTree(this.getCloudMapOptions()));
            }
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDesiredCount() != null) {
                data.set("desiredCount", om.valueToTree(this.getDesiredCount()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getDomainZone() != null) {
                data.set("domainZone", om.valueToTree(this.getDomainZone()));
            }
            if (this.getEnableEcsManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableEcsManagedTags()));
            }
            if (this.getHealthCheckGracePeriod() != null) {
                data.set("healthCheckGracePeriod", om.valueToTree(this.getHealthCheckGracePeriod()));
            }
            if (this.getListenerPort() != null) {
                data.set("listenerPort", om.valueToTree(this.getListenerPort()));
            }
            if (this.getLoadBalancer() != null) {
                data.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
            }
            if (this.getMaxHealthyPercent() != null) {
                data.set("maxHealthyPercent", om.valueToTree(this.getMaxHealthyPercent()));
            }
            if (this.getMinHealthyPercent() != null) {
                data.set("minHealthyPercent", om.valueToTree(this.getMinHealthyPercent()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getPublicLoadBalancer() != null) {
                data.set("publicLoadBalancer", om.valueToTree(this.getPublicLoadBalancer()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getTaskImageOptions() != null) {
                data.set("taskImageOptions", om.valueToTree(this.getTaskImageOptions()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.ApplicationLoadBalancedServiceBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancedServiceBaseProps.Jsii$Proxy that = (ApplicationLoadBalancedServiceBaseProps.Jsii$Proxy) o;

            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            if (this.cloudMapOptions != null ? !this.cloudMapOptions.equals(that.cloudMapOptions) : that.cloudMapOptions != null) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.desiredCount != null ? !this.desiredCount.equals(that.desiredCount) : that.desiredCount != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.domainZone != null ? !this.domainZone.equals(that.domainZone) : that.domainZone != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.healthCheckGracePeriod != null ? !this.healthCheckGracePeriod.equals(that.healthCheckGracePeriod) : that.healthCheckGracePeriod != null) return false;
            if (this.listenerPort != null ? !this.listenerPort.equals(that.listenerPort) : that.listenerPort != null) return false;
            if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) return false;
            if (this.maxHealthyPercent != null ? !this.maxHealthyPercent.equals(that.maxHealthyPercent) : that.maxHealthyPercent != null) return false;
            if (this.minHealthyPercent != null ? !this.minHealthyPercent.equals(that.minHealthyPercent) : that.minHealthyPercent != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.publicLoadBalancer != null ? !this.publicLoadBalancer.equals(that.publicLoadBalancer) : that.publicLoadBalancer != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            if (this.taskImageOptions != null ? !this.taskImageOptions.equals(that.taskImageOptions) : that.taskImageOptions != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.certificate != null ? this.certificate.hashCode() : 0;
            result = 31 * result + (this.cloudMapOptions != null ? this.cloudMapOptions.hashCode() : 0);
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.desiredCount != null ? this.desiredCount.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.domainZone != null ? this.domainZone.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.healthCheckGracePeriod != null ? this.healthCheckGracePeriod.hashCode() : 0);
            result = 31 * result + (this.listenerPort != null ? this.listenerPort.hashCode() : 0);
            result = 31 * result + (this.loadBalancer != null ? this.loadBalancer.hashCode() : 0);
            result = 31 * result + (this.maxHealthyPercent != null ? this.maxHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.minHealthyPercent != null ? this.minHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.publicLoadBalancer != null ? this.publicLoadBalancer.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.taskImageOptions != null ? this.taskImageOptions.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
