package software.amazon.awscdk.services.ecs.patterns;

/**
 * Properties to define an application load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:21.901Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ApplicationLoadBalancerProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationLoadBalancerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Listeners (at least one listener) attached to this load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> getListeners();

    /**
     * Name of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The domain name for the service, e.g. "api.example.com.".
     * <p>
     * Default: - No domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The Route53 hosted zone for the domain, e.g. "example.com.".
     * <p>
     * Default: - No Route53 hosted domain zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
        return null;
    }

    /**
     * Determines whether the Load Balancer will be internet-facing.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublicLoadBalancer() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> listeners;
        private java.lang.String name;
        private java.lang.String domainName;
        private software.amazon.awscdk.services.route53.IHostedZone domainZone;
        private java.lang.Boolean publicLoadBalancer;

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getListeners}
         * @param listeners Listeners (at least one listener) attached to this load balancer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> listeners) {
            this.listeners = listeners;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getName}
         * @param name Name of the load balancer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getDomainName}
         * @param domainName The domain name for the service, e.g. "api.example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getDomainZone}
         * @param domainZone The Route53 hosted zone for the domain, e.g. "example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainZone(software.amazon.awscdk.services.route53.IHostedZone domainZone) {
            this.domainZone = domainZone;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getPublicLoadBalancer}
         * @param publicLoadBalancer Determines whether the Load Balancer will be internet-facing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicLoadBalancer(java.lang.Boolean publicLoadBalancer) {
            this.publicLoadBalancer = publicLoadBalancer;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationLoadBalancerProps build() {
            return new Jsii$Proxy(listeners, name, domainName, domainZone, publicLoadBalancer);
        }
    }

    /**
     * An implementation for {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancerProps {
        private final java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> listeners;
        private final java.lang.String name;
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.route53.IHostedZone domainZone;
        private final java.lang.Boolean publicLoadBalancer;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listeners = this.jsiiGet("listeners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps.class)));
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.domainZone = this.jsiiGet("domainZone", software.amazon.awscdk.services.route53.IHostedZone.class);
            this.publicLoadBalancer = this.jsiiGet("publicLoadBalancer", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> listeners, final java.lang.String name, final java.lang.String domainName, final software.amazon.awscdk.services.route53.IHostedZone domainZone, final java.lang.Boolean publicLoadBalancer) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listeners = java.util.Objects.requireNonNull(listeners, "listeners is required");
            this.name = java.util.Objects.requireNonNull(name, "name is required");
            this.domainName = domainName;
            this.domainZone = domainZone;
            this.publicLoadBalancer = publicLoadBalancer;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> getListeners() {
            return this.listeners;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
            return this.domainZone;
        }

        @Override
        public java.lang.Boolean getPublicLoadBalancer() {
            return this.publicLoadBalancer;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listeners", om.valueToTree(this.getListeners()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getDomainZone() != null) {
                data.set("domainZone", om.valueToTree(this.getDomainZone()));
            }
            if (this.getPublicLoadBalancer() != null) {
                data.set("publicLoadBalancer", om.valueToTree(this.getPublicLoadBalancer()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.ApplicationLoadBalancerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancerProps.Jsii$Proxy that = (ApplicationLoadBalancerProps.Jsii$Proxy) o;

            if (!listeners.equals(that.listeners)) return false;
            if (!name.equals(that.name)) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.domainZone != null ? !this.domainZone.equals(that.domainZone) : that.domainZone != null) return false;
            return this.publicLoadBalancer != null ? this.publicLoadBalancer.equals(that.publicLoadBalancer) : that.publicLoadBalancer == null;
        }

        @Override
        public int hashCode() {
            int result = this.listeners.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.domainZone != null ? this.domainZone.hashCode() : 0);
            result = 31 * result + (this.publicLoadBalancer != null ? this.publicLoadBalancer.hashCode() : 0);
            return result;
        }
    }
}
