package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the ApplicationMultipleTargetGroupsEc2Service service.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:21.902Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ApplicationMultipleTargetGroupsEc2ServiceProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationMultipleTargetGroupsEc2ServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationMultipleTargetGroupsEc2ServiceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsServiceBaseProps {

    /**
     * The minimum number of CPU units to reserve for the container.
     * <p>
     * Valid values, which determines your range of valid values for the memory parameter:
     * <p>
     * Default: - No minimum CPU units reserved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpu() {
        return null;
    }

    /**
     * The amount (in MiB) of memory to present to the container.
     * <p>
     * If your container attempts to exceed the allocated memory, the container
     * is terminated.
     * <p>
     * At least one of memoryLimitMiB and memoryReservationMiB is required.
     * <p>
     * Default: - No memory limit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimitMiB() {
        return null;
    }

    /**
     * The soft limit (in MiB) of memory to reserve for the container.
     * <p>
     * When system memory is under heavy contention, Docker attempts to keep the
     * container memory to this soft limit. However, your container can consume more
     * memory when it needs to, up to either the hard limit specified with the memory
     * parameter (if applicable), or all of the available memory on the container
     * instance, whichever comes first.
     * <p>
     * At least one of memoryLimitMiB and memoryReservationMiB is required.
     * <p>
     * Note that this setting will be ignored if TaskImagesOptions is specified
     * <p>
     * Default: - No memory reserved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryReservationMiB() {
        return null;
    }

    /**
     * The task definition to use for tasks in the service. Only one of TaskDefinition or TaskImageOptions must be specified.
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.Ec2TaskDefinition getTaskDefinition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationMultipleTargetGroupsEc2ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationMultipleTargetGroupsEc2ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number cpu;
        private java.lang.Number memoryLimitMiB;
        private java.lang.Number memoryReservationMiB;
        private software.amazon.awscdk.services.ecs.Ec2TaskDefinition taskDefinition;
        private software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private java.lang.Number desiredCount;
        private java.lang.Boolean enableEcsManagedTags;
        private software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        private java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancerProps> loadBalancers;
        private software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private java.lang.String serviceName;
        private java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationTargetProps> targetGroups;
        private software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageProps taskImageOptions;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getCpu}
         * @param cpu The minimum number of CPU units to reserve for the container.
         *            Valid values, which determines your range of valid values for the memory parameter:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getMemoryLimitMiB}
         * @param memoryLimitMiB The amount (in MiB) of memory to present to the container.
         *                       If your container attempts to exceed the allocated memory, the container
         *                       is terminated.
         *                       <p>
         *                       At least one of memoryLimitMiB and memoryReservationMiB is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getMemoryReservationMiB}
         * @param memoryReservationMiB The soft limit (in MiB) of memory to reserve for the container.
         *                             When system memory is under heavy contention, Docker attempts to keep the
         *                             container memory to this soft limit. However, your container can consume more
         *                             memory when it needs to, up to either the hard limit specified with the memory
         *                             parameter (if applicable), or all of the available memory on the container
         *                             instance, whichever comes first.
         *                             <p>
         *                             At least one of memoryLimitMiB and memoryReservationMiB is required.
         *                             <p>
         *                             Note that this setting will be ignored if TaskImagesOptions is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryReservationMiB(java.lang.Number memoryReservationMiB) {
            this.memoryReservationMiB = memoryReservationMiB;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getTaskDefinition}
         * @param taskDefinition The task definition to use for tasks in the service. Only one of TaskDefinition or TaskImageOptions must be specified.
         *                       [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.Ec2TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getCloudMapOptions}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getDesiredCount}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(java.lang.Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getHealthCheckGracePeriod}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(software.amazon.awscdk.core.Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getLoadBalancers}
         * @param loadBalancers The application load balancer that will serve traffic to the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancers(java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancerProps> loadBalancers) {
            this.loadBalancers = loadBalancers;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getTargetGroups}
         * @param targetGroups Properties to specify ALB target groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroups(java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationTargetProps> targetGroups) {
            this.targetGroups = targetGroups;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getTaskImageOptions}
         * @param taskImageOptions The properties required to create a new task definition.
         *                         Only one of TaskDefinition or TaskImageOptions must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskImageOptions(software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageProps taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationMultipleTargetGroupsEc2ServiceProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationMultipleTargetGroupsEc2ServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationMultipleTargetGroupsEc2ServiceProps build() {
            return new Jsii$Proxy(cpu, memoryLimitMiB, memoryReservationMiB, taskDefinition, cloudMapOptions, cluster, desiredCount, enableEcsManagedTags, healthCheckGracePeriod, loadBalancers, propagateTags, serviceName, targetGroups, taskImageOptions, vpc);
        }
    }

    /**
     * An implementation for {@link ApplicationMultipleTargetGroupsEc2ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationMultipleTargetGroupsEc2ServiceProps {
        private final java.lang.Number cpu;
        private final java.lang.Number memoryLimitMiB;
        private final java.lang.Number memoryReservationMiB;
        private final software.amazon.awscdk.services.ecs.Ec2TaskDefinition taskDefinition;
        private final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.lang.Number desiredCount;
        private final java.lang.Boolean enableEcsManagedTags;
        private final software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        private final java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancerProps> loadBalancers;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final java.lang.String serviceName;
        private final java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationTargetProps> targetGroups;
        private final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageProps taskImageOptions;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cpu = this.jsiiGet("cpu", java.lang.Number.class);
            this.memoryLimitMiB = this.jsiiGet("memoryLimitMiB", java.lang.Number.class);
            this.memoryReservationMiB = this.jsiiGet("memoryReservationMiB", java.lang.Number.class);
            this.taskDefinition = this.jsiiGet("taskDefinition", software.amazon.awscdk.services.ecs.Ec2TaskDefinition.class);
            this.cloudMapOptions = this.jsiiGet("cloudMapOptions", software.amazon.awscdk.services.ecs.CloudMapOptions.class);
            this.cluster = this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
            this.desiredCount = this.jsiiGet("desiredCount", java.lang.Number.class);
            this.enableEcsManagedTags = this.jsiiGet("enableECSManagedTags", java.lang.Boolean.class);
            this.healthCheckGracePeriod = this.jsiiGet("healthCheckGracePeriod", software.amazon.awscdk.core.Duration.class);
            this.loadBalancers = this.jsiiGet("loadBalancers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancerProps.class)));
            this.propagateTags = this.jsiiGet("propagateTags", software.amazon.awscdk.services.ecs.PropagatedTagSource.class);
            this.serviceName = this.jsiiGet("serviceName", java.lang.String.class);
            this.targetGroups = this.jsiiGet("targetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ApplicationTargetProps.class)));
            this.taskImageOptions = this.jsiiGet("taskImageOptions", software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageProps.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number cpu, final java.lang.Number memoryLimitMiB, final java.lang.Number memoryReservationMiB, final software.amazon.awscdk.services.ecs.Ec2TaskDefinition taskDefinition, final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions, final software.amazon.awscdk.services.ecs.ICluster cluster, final java.lang.Number desiredCount, final java.lang.Boolean enableEcsManagedTags, final software.amazon.awscdk.core.Duration healthCheckGracePeriod, final java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancerProps> loadBalancers, final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags, final java.lang.String serviceName, final java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationTargetProps> targetGroups, final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageProps taskImageOptions, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cpu = cpu;
            this.memoryLimitMiB = memoryLimitMiB;
            this.memoryReservationMiB = memoryReservationMiB;
            this.taskDefinition = taskDefinition;
            this.cloudMapOptions = cloudMapOptions;
            this.cluster = cluster;
            this.desiredCount = desiredCount;
            this.enableEcsManagedTags = enableEcsManagedTags;
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            this.loadBalancers = loadBalancers;
            this.propagateTags = propagateTags;
            this.serviceName = serviceName;
            this.targetGroups = targetGroups;
            this.taskImageOptions = taskImageOptions;
            this.vpc = vpc;
        }

        @Override
        public java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public java.lang.Number getMemoryReservationMiB() {
            return this.memoryReservationMiB;
        }

        @Override
        public software.amazon.awscdk.services.ecs.Ec2TaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
            return this.cloudMapOptions;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public java.lang.Number getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public java.lang.Boolean getEnableEcsManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public software.amazon.awscdk.core.Duration getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancerProps> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationTargetProps> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        public software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageProps getTaskImageOptions() {
            return this.taskImageOptions;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getMemoryReservationMiB() != null) {
                data.set("memoryReservationMiB", om.valueToTree(this.getMemoryReservationMiB()));
            }
            if (this.getTaskDefinition() != null) {
                data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            }
            if (this.getCloudMapOptions() != null) {
                data.set("cloudMapOptions", om.valueToTree(this.getCloudMapOptions()));
            }
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDesiredCount() != null) {
                data.set("desiredCount", om.valueToTree(this.getDesiredCount()));
            }
            if (this.getEnableEcsManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableEcsManagedTags()));
            }
            if (this.getHealthCheckGracePeriod() != null) {
                data.set("healthCheckGracePeriod", om.valueToTree(this.getHealthCheckGracePeriod()));
            }
            if (this.getLoadBalancers() != null) {
                data.set("loadBalancers", om.valueToTree(this.getLoadBalancers()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getTargetGroups() != null) {
                data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            }
            if (this.getTaskImageOptions() != null) {
                data.set("taskImageOptions", om.valueToTree(this.getTaskImageOptions()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.ApplicationMultipleTargetGroupsEc2ServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationMultipleTargetGroupsEc2ServiceProps.Jsii$Proxy that = (ApplicationMultipleTargetGroupsEc2ServiceProps.Jsii$Proxy) o;

            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.memoryReservationMiB != null ? !this.memoryReservationMiB.equals(that.memoryReservationMiB) : that.memoryReservationMiB != null) return false;
            if (this.taskDefinition != null ? !this.taskDefinition.equals(that.taskDefinition) : that.taskDefinition != null) return false;
            if (this.cloudMapOptions != null ? !this.cloudMapOptions.equals(that.cloudMapOptions) : that.cloudMapOptions != null) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.desiredCount != null ? !this.desiredCount.equals(that.desiredCount) : that.desiredCount != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.healthCheckGracePeriod != null ? !this.healthCheckGracePeriod.equals(that.healthCheckGracePeriod) : that.healthCheckGracePeriod != null) return false;
            if (this.loadBalancers != null ? !this.loadBalancers.equals(that.loadBalancers) : that.loadBalancers != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            if (this.targetGroups != null ? !this.targetGroups.equals(that.targetGroups) : that.targetGroups != null) return false;
            if (this.taskImageOptions != null ? !this.taskImageOptions.equals(that.taskImageOptions) : that.taskImageOptions != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.cpu != null ? this.cpu.hashCode() : 0;
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.memoryReservationMiB != null ? this.memoryReservationMiB.hashCode() : 0);
            result = 31 * result + (this.taskDefinition != null ? this.taskDefinition.hashCode() : 0);
            result = 31 * result + (this.cloudMapOptions != null ? this.cloudMapOptions.hashCode() : 0);
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.desiredCount != null ? this.desiredCount.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.healthCheckGracePeriod != null ? this.healthCheckGracePeriod.hashCode() : 0);
            result = 31 * result + (this.loadBalancers != null ? this.loadBalancers.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
            result = 31 * result + (this.taskImageOptions != null ? this.taskImageOptions.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
