package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the QueueProcessingFargateService service.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:21.929Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.QueueProcessingFargateServiceProps")
@software.amazon.jsii.Jsii.Proxy(QueueProcessingFargateServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueueProcessingFargateServiceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBaseProps {

    /**
     * The number of cpu units used by the task.
     * <p>
     * Valid values, which determines your range of valid values for the memory parameter:
     * <p>
     * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
     * <p>
     * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
     * <p>
     * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
     * <p>
     * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
     * <p>
     * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
     * <p>
     * This default is set in the underlying FargateTaskDefinition construct.
     * <p>
     * Default: 256
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpu() {
        return null;
    }

    /**
     * The amount (in MiB) of memory used by the task.
     * <p>
     * This field is required and you must use one of the following values, which determines your range of valid values
     * for the cpu parameter:
     * <p>
     * 0.5GB, 1GB, 2GB - Available cpu values: 256 (.25 vCPU)
     * <p>
     * 1GB, 2GB, 3GB, 4GB - Available cpu values: 512 (.5 vCPU)
     * <p>
     * 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB - Available cpu values: 1024 (1 vCPU)
     * <p>
     * Between 4GB and 16GB in 1GB increments - Available cpu values: 2048 (2 vCPU)
     * <p>
     * Between 8GB and 30GB in 1GB increments - Available cpu values: 4096 (4 vCPU)
     * <p>
     * This default is set in the underlying FargateTaskDefinition construct.
     * <p>
     * Default: 512
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimitMiB() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QueueProcessingFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueueProcessingFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number cpu;
        private java.lang.Number memoryLimitMiB;
        private software.amazon.awscdk.services.ecs.ContainerImage image;
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private java.util.List<java.lang.String> command;
        private java.lang.Number desiredTaskCount;
        private java.lang.Boolean enableEcsManagedTags;
        private java.lang.Boolean enableLogging;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.lang.String family;
        private software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private java.lang.Number maxReceiveCount;
        private java.lang.Number maxScalingCapacity;
        private software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private software.amazon.awscdk.services.sqs.IQueue queue;
        private software.amazon.awscdk.core.Duration retentionPeriod;
        private java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private java.lang.String serviceName;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getCpu}
         * @param cpu The number of cpu units used by the task.
         *            Valid values, which determines your range of valid values for the memory parameter:
         *            <p>
         *            256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         *            <p>
         *            512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         *            <p>
         *            1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         *            <p>
         *            2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         *            <p>
         *            4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         *            <p>
         *            This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getMemoryLimitMiB}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task.
         *                       This field is required and you must use one of the following values, which determines your range of valid values
         *                       for the cpu parameter:
         *                       <p>
         *                       0.5GB, 1GB, 2GB - Available cpu values: 256 (.25 vCPU)
         *                       <p>
         *                       1GB, 2GB, 3GB, 4GB - Available cpu values: 512 (.5 vCPU)
         *                       <p>
         *                       2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB - Available cpu values: 1024 (1 vCPU)
         *                       <p>
         *                       Between 4GB and 16GB in 1GB increments - Available cpu values: 2048 (2 vCPU)
         *                       <p>
         *                       Between 8GB and 30GB in 1GB increments - Available cpu values: 4096 (4 vCPU)
         *                       <p>
         *                       This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getImage}
         * @param image The image used to start a container. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getCommand}
         * @param command The command that is passed to the container.
         *                If you provide a shell command as a single string, you have to quote command-line arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getDesiredTaskCount}
         * @param desiredTaskCount The desired number of instantiations of the task definition to keep running on the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredTaskCount(java.lang.Number desiredTaskCount) {
            this.desiredTaskCount = desiredTaskCount;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getEnableLogging}
         * @param enableLogging Flag to indicate whether to enable logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogging(java.lang.Boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getEnvironment}
         * @param environment The environment variables to pass to the container.
         *                    The variable <code>QUEUE_NAME</code> with value <code>queue.queueName</code> will
         *                    always be passed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getFamily}
         * @param family The name of a family that the task definition is registered to.
         *               A family groups multiple versions of a task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getLogDriver}
         * @param logDriver The log driver to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(software.amazon.awscdk.services.ecs.LogDriver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getMaxReceiveCount}
         * @param maxReceiveCount The maximum number of times that a message can be received by consumers.
         *                        When this value is exceeded for a message the message will be automatically sent to the Dead Letter Queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReceiveCount(java.lang.Number maxReceiveCount) {
            this.maxReceiveCount = maxReceiveCount;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getMaxScalingCapacity}
         * @param maxScalingCapacity Maximum capacity to scale to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxScalingCapacity(java.lang.Number maxScalingCapacity) {
            this.maxScalingCapacity = maxScalingCapacity;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getQueue}
         * @param queue A queue for which to process items from.
         *              If specified and this is a FIFO queue, the queue name must end in the string '.fifo'. See
         *              <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html">CreateQueue</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queue(software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getRetentionPeriod}
         * @param retentionPeriod The number of seconds that Dead Letter Queue retains a message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.core.Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getScalingSteps}
         * @param scalingSteps The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
         *                     Maps a range of metric values to a particular scaling behavior. See
         *                     <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Simple and Step Scaling Policies for Amazon EC2 Auto Scaling</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingSteps(java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps) {
            this.scalingSteps = scalingSteps;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getSecrets}
         * @param secrets The secret to expose to the container as an environment variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.secrets = secrets;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueProcessingFargateServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public QueueProcessingFargateServiceProps build() {
            return new Jsii$Proxy(cpu, memoryLimitMiB, image, cluster, command, desiredTaskCount, enableEcsManagedTags, enableLogging, environment, family, logDriver, maxReceiveCount, maxScalingCapacity, propagateTags, queue, retentionPeriod, scalingSteps, secrets, serviceName, vpc);
        }
    }

    /**
     * An implementation for {@link QueueProcessingFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueProcessingFargateServiceProps {
        private final java.lang.Number cpu;
        private final java.lang.Number memoryLimitMiB;
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.util.List<java.lang.String> command;
        private final java.lang.Number desiredTaskCount;
        private final java.lang.Boolean enableEcsManagedTags;
        private final java.lang.Boolean enableLogging;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.String family;
        private final software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private final java.lang.Number maxReceiveCount;
        private final java.lang.Number maxScalingCapacity;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private final software.amazon.awscdk.core.Duration retentionPeriod;
        private final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private final java.lang.String serviceName;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cpu = this.jsiiGet("cpu", java.lang.Number.class);
            this.memoryLimitMiB = this.jsiiGet("memoryLimitMiB", java.lang.Number.class);
            this.image = this.jsiiGet("image", software.amazon.awscdk.services.ecs.ContainerImage.class);
            this.cluster = this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
            this.command = this.jsiiGet("command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.desiredTaskCount = this.jsiiGet("desiredTaskCount", java.lang.Number.class);
            this.enableEcsManagedTags = this.jsiiGet("enableECSManagedTags", java.lang.Boolean.class);
            this.enableLogging = this.jsiiGet("enableLogging", java.lang.Boolean.class);
            this.environment = this.jsiiGet("environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.family = this.jsiiGet("family", java.lang.String.class);
            this.logDriver = this.jsiiGet("logDriver", software.amazon.awscdk.services.ecs.LogDriver.class);
            this.maxReceiveCount = this.jsiiGet("maxReceiveCount", java.lang.Number.class);
            this.maxScalingCapacity = this.jsiiGet("maxScalingCapacity", java.lang.Number.class);
            this.propagateTags = this.jsiiGet("propagateTags", software.amazon.awscdk.services.ecs.PropagatedTagSource.class);
            this.queue = this.jsiiGet("queue", software.amazon.awscdk.services.sqs.IQueue.class);
            this.retentionPeriod = this.jsiiGet("retentionPeriod", software.amazon.awscdk.core.Duration.class);
            this.scalingSteps = this.jsiiGet("scalingSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.ScalingInterval.class)));
            this.secrets = this.jsiiGet("secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
            this.serviceName = this.jsiiGet("serviceName", java.lang.String.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number cpu, final java.lang.Number memoryLimitMiB, final software.amazon.awscdk.services.ecs.ContainerImage image, final software.amazon.awscdk.services.ecs.ICluster cluster, final java.util.List<java.lang.String> command, final java.lang.Number desiredTaskCount, final java.lang.Boolean enableEcsManagedTags, final java.lang.Boolean enableLogging, final java.util.Map<java.lang.String, java.lang.String> environment, final java.lang.String family, final software.amazon.awscdk.services.ecs.LogDriver logDriver, final java.lang.Number maxReceiveCount, final java.lang.Number maxScalingCapacity, final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags, final software.amazon.awscdk.services.sqs.IQueue queue, final software.amazon.awscdk.core.Duration retentionPeriod, final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps, final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets, final java.lang.String serviceName, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cpu = cpu;
            this.memoryLimitMiB = memoryLimitMiB;
            this.image = java.util.Objects.requireNonNull(image, "image is required");
            this.cluster = cluster;
            this.command = command;
            this.desiredTaskCount = desiredTaskCount;
            this.enableEcsManagedTags = enableEcsManagedTags;
            this.enableLogging = enableLogging;
            this.environment = environment;
            this.family = family;
            this.logDriver = logDriver;
            this.maxReceiveCount = maxReceiveCount;
            this.maxScalingCapacity = maxScalingCapacity;
            this.propagateTags = propagateTags;
            this.queue = queue;
            this.retentionPeriod = retentionPeriod;
            this.scalingSteps = scalingSteps;
            this.secrets = secrets;
            this.serviceName = serviceName;
            this.vpc = vpc;
        }

        @Override
        public java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public java.lang.Number getDesiredTaskCount() {
            return this.desiredTaskCount;
        }

        @Override
        public java.lang.Boolean getEnableEcsManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public java.lang.Boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
            return this.logDriver;
        }

        @Override
        public java.lang.Number getMaxReceiveCount() {
            return this.maxReceiveCount;
        }

        @Override
        public java.lang.Number getMaxScalingCapacity() {
            return this.maxScalingCapacity;
        }

        @Override
        public software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public software.amazon.awscdk.services.sqs.IQueue getQueue() {
            return this.queue;
        }

        @Override
        public software.amazon.awscdk.core.Duration getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps() {
            return this.scalingSteps;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        public java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getDesiredTaskCount() != null) {
                data.set("desiredTaskCount", om.valueToTree(this.getDesiredTaskCount()));
            }
            if (this.getEnableEcsManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableEcsManagedTags()));
            }
            if (this.getEnableLogging() != null) {
                data.set("enableLogging", om.valueToTree(this.getEnableLogging()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getLogDriver() != null) {
                data.set("logDriver", om.valueToTree(this.getLogDriver()));
            }
            if (this.getMaxReceiveCount() != null) {
                data.set("maxReceiveCount", om.valueToTree(this.getMaxReceiveCount()));
            }
            if (this.getMaxScalingCapacity() != null) {
                data.set("maxScalingCapacity", om.valueToTree(this.getMaxScalingCapacity()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getQueue() != null) {
                data.set("queue", om.valueToTree(this.getQueue()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getScalingSteps() != null) {
                data.set("scalingSteps", om.valueToTree(this.getScalingSteps()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.QueueProcessingFargateServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueueProcessingFargateServiceProps.Jsii$Proxy that = (QueueProcessingFargateServiceProps.Jsii$Proxy) o;

            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (!image.equals(that.image)) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.desiredTaskCount != null ? !this.desiredTaskCount.equals(that.desiredTaskCount) : that.desiredTaskCount != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.enableLogging != null ? !this.enableLogging.equals(that.enableLogging) : that.enableLogging != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.logDriver != null ? !this.logDriver.equals(that.logDriver) : that.logDriver != null) return false;
            if (this.maxReceiveCount != null ? !this.maxReceiveCount.equals(that.maxReceiveCount) : that.maxReceiveCount != null) return false;
            if (this.maxScalingCapacity != null ? !this.maxScalingCapacity.equals(that.maxScalingCapacity) : that.maxScalingCapacity != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.queue != null ? !this.queue.equals(that.queue) : that.queue != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            if (this.scalingSteps != null ? !this.scalingSteps.equals(that.scalingSteps) : that.scalingSteps != null) return false;
            if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.cpu != null ? this.cpu.hashCode() : 0;
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.image.hashCode());
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.desiredTaskCount != null ? this.desiredTaskCount.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.enableLogging != null ? this.enableLogging.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.logDriver != null ? this.logDriver.hashCode() : 0);
            result = 31 * result + (this.maxReceiveCount != null ? this.maxReceiveCount.hashCode() : 0);
            result = 31 * result + (this.maxScalingCapacity != null ? this.maxScalingCapacity.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.queue != null ? this.queue.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.scalingSteps != null ? this.scalingSteps.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
