package software.amazon.awscdk.services.ecs.patterns;

/**
 * A scheduled Fargate task that will be initiated off of CloudWatch Events.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:21.942Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ScheduledFargateTask")
public class ScheduledFargateTask extends software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBase {

    protected ScheduledFargateTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduledFargateTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ScheduledFargateTask class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ScheduledFargateTask(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The Fargate task definition in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
        return this.jsiiGet("taskDefinition", software.amazon.awscdk.services.ecs.FargateTaskDefinition.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskProps.Builder();
        }

        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expression Syntax for Rules</a>
         * in the Amazon CloudWatch User Guide.
         * <p>
         * @return {@code this}
         * @param schedule The schedule or rate (frequency) that determines when CloudWatch Events runs the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.applicationautoscaling.Schedule schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The name of the cluster that hosts the service.
         * <p>
         * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * <p>
         * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * The desired number of instantiations of the task definition to keep running on the service.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param desiredTaskCount The desired number of instantiations of the task definition to keep running on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredTaskCount(final java.lang.Number desiredTaskCount) {
            this.props.desiredTaskCount(desiredTaskCount);
            return this;
        }

        /**
         * In what subnets to place the task's ENIs.
         * <p>
         * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * <p>
         * Default: Private subnets
         * <p>
         * @return {@code this}
         * @param subnetSelection In what subnets to place the task's ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         * <p>
         * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * <p>
         * Default: - uses the VPC defined in the cluster or creates a new VPC.
         * <p>
         * @return {@code this}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The properties to define if using an existing TaskDefinition in this construct.
         * <p>
         * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param scheduledFargateTaskDefinitionOptions The properties to define if using an existing TaskDefinition in this construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledFargateTaskDefinitionOptions(final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions) {
            this.props.scheduledFargateTaskDefinitionOptions(scheduledFargateTaskDefinitionOptions);
            return this;
        }

        /**
         * The properties to define if the construct is to create a TaskDefinition.
         * <p>
         * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param scheduledFargateTaskImageOptions The properties to define if the construct is to create a TaskDefinition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledFargateTaskImageOptions(final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions) {
            this.props.scheduledFargateTaskImageOptions(scheduledFargateTaskImageOptions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTask build() {
            return new software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTask(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
