/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.Ec2Service;
import software.amazon.awscdk.services.ecs.Ec2TaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.patterns.;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkMultipleTargetGroupsEc2ServiceProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkMultipleTargetGroupsServiceBase;
import software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs-patterns.NetworkMultipleTargetGroupsEc2Service")
public class NetworkMultipleTargetGroupsEc2Service
extends NetworkMultipleTargetGroupsServiceBase {
    protected NetworkMultipleTargetGroupsEc2Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkMultipleTargetGroupsEc2Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NetworkMultipleTargetGroupsEc2Service(@NotNull Construct scope, @NotNull String id, @Nullable NetworkMultipleTargetGroupsEc2ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public NetworkMultipleTargetGroupsEc2Service(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public Ec2Service getService() {
        return (Ec2Service)this.jsiiGet("service", Ec2Service.class);
    }

    @NotNull
    public NetworkTargetGroup getTargetGroup() {
        return (NetworkTargetGroup)this.jsiiGet("targetGroup", NetworkTargetGroup.class);
    }

    @NotNull
    public Ec2TaskDefinition getTaskDefinition() {
        return (Ec2TaskDefinition)this.jsiiGet("taskDefinition", Ec2TaskDefinition.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private NetworkMultipleTargetGroupsEc2ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.props().cloudMapOptions(cloudMapOptions);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props().cluster(cluster);
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.props().healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        public Builder loadBalancers(List<NetworkLoadBalancerProps> loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        public Builder targetGroups(List<NetworkTargetProps> targetGroups) {
            this.props().targetGroups(targetGroups);
            return this;
        }

        public Builder taskImageOptions(NetworkLoadBalancedTaskImageProps taskImageOptions) {
            this.props().taskImageOptions(taskImageOptions);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public Builder cpu(Number cpu) {
            this.props().cpu(cpu);
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.props().memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.props().memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        public Builder taskDefinition(Ec2TaskDefinition taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        public NetworkMultipleTargetGroupsEc2Service build() {
            return new NetworkMultipleTargetGroupsEc2Service(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private NetworkMultipleTargetGroupsEc2ServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new NetworkMultipleTargetGroupsEc2ServiceProps.Builder();
            }
            return this.props;
        }
    }
}

