package software.amazon.awscdk.services.ecs.patterns;

/**
 * A Fargate service running on an ECS cluster fronted by a network load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-11-24T22:29:59.857Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.NetworkLoadBalancedFargateService")
public class NetworkLoadBalancedFargateService extends software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceBase {

    protected NetworkLoadBalancedFargateService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkLoadBalancedFargateService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the NetworkLoadBalancedFargateService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkLoadBalancedFargateService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedFargateServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the NetworkLoadBalancedFargateService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkLoadBalancedFargateService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAssignPublicIp() {
        return software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The Fargate service in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateService getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateService.class));
    }

    /**
     * The Fargate task definition in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateTaskDefinition.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedFargateService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedFargateService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedFargateServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The options for configuring an Amazon ECS service to use service discovery.
         * <p>
         * Default: - AWS Cloud Map service discovery is not enabled.
         * <p>
         * @return {@code this}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.props().cloudMapOptions(cloudMapOptions);
            return this;
        }

        /**
         * The name of the cluster that hosts the service.
         * <p>
         * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * <p>
         * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props().cluster(cluster);
            return this;
        }

        /**
         * The desired number of instantiations of the task definition to keep running on the service.
         * <p>
         * The minimum value is 1
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(final java.lang.Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        /**
         * The domain name for the service, e.g. "api.example.com.".
         * <p>
         * Default: - No domain name.
         * <p>
         * @return {@code this}
         * @param domainName The domain name for the service, e.g. "api.example.com.". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props().domainName(domainName);
            return this;
        }

        /**
         * The Route53 hosted zone for the domain, e.g. "example.com.".
         * <p>
         * Default: - No Route53 hosted domain zone.
         * <p>
         * @return {@code this}
         * @param domainZone The Route53 hosted zone for the domain, e.g. "example.com.". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainZone(final software.amazon.awscdk.services.route53.IHostedZone domainZone) {
            this.props().domainZone(domainZone);
            return this;
        }

        /**
         * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * <p>
         * Default: - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
         * <p>
         * @return {@code this}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(final software.amazon.awscdk.core.Duration healthCheckGracePeriod) {
            this.props().healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        /**
         * Listener port of the network load balancer that will serve traffic to the service.
         * <p>
         * Default: 80
         * <p>
         * @return {@code this}
         * @param listenerPort Listener port of the network load balancer that will serve traffic to the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerPort(final java.lang.Number listenerPort) {
            this.props().listenerPort(listenerPort);
            return this;
        }

        /**
         * The network load balancer that will serve traffic to the service.
         * <p>
         * If the load balancer has been imported, the vpc attribute must be specified
         * in the call to fromNetworkLoadBalancerAttributes().
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * Default: - a new load balancer will be created.
         * <p>
         * @return {@code this}
         * @param loadBalancer The network load balancer that will serve traffic to the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
            this.props().loadBalancer(loadBalancer);
            return this;
        }

        /**
         * The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * <p>
         * Default: - 100 if daemon, otherwise 200
         * <p>
         * @return {@code this}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(final java.lang.Number maxHealthyPercent) {
            this.props().maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        /**
         * The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * <p>
         * Default: - 0 if daemon, otherwise 50
         * <p>
         * @return {@code this}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(final java.lang.Number minHealthyPercent) {
            this.props().minHealthyPercent(minHealthyPercent);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         * <p>
         * Tags can only be propagated to the tasks within the service during service creation.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        /**
         * Determines whether the Load Balancer will be internet-facing.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param publicLoadBalancer Determines whether the Load Balancer will be internet-facing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicLoadBalancer(final java.lang.Boolean publicLoadBalancer) {
            this.props().publicLoadBalancer(publicLoadBalancer);
            return this;
        }

        /**
         * Specifies whether the Route53 record should be a CNAME, an A record using the Alias feature or no record at all.
         * <p>
         * This is useful if you need to work with DNS systems that do not support alias records.
         * <p>
         * Default: NetworkLoadBalancedServiceRecordType.ALIAS
         * <p>
         * @return {@code this}
         * @param recordType Specifies whether the Route53 record should be a CNAME, an A record using the Alias feature or no record at all. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordType(final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceRecordType recordType) {
            this.props().recordType(recordType);
            return this;
        }

        /**
         * The name of the service.
         * <p>
         * Default: - CloudFormation-generated name.
         * <p>
         * @return {@code this}
         * @param serviceName The name of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        /**
         * The properties required to create a new task definition.
         * <p>
         * One of taskImageOptions or taskDefinition must be specified.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param taskImageOptions The properties required to create a new task definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskImageOptions(final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions taskImageOptions) {
            this.props().taskImageOptions(taskImageOptions);
            return this;
        }

        /**
         * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         * <p>
         * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * <p>
         * Default: - uses the VPC defined in the cluster or creates a new VPC.
         * <p>
         * @return {@code this}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        /**
         * Determines whether the service will be assigned a public IP address.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param assignPublicIp Determines whether the service will be assigned a public IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(final java.lang.Boolean assignPublicIp) {
            this.props().assignPublicIp(assignPublicIp);
            return this;
        }

        /**
         * The number of cpu units used by the task.
         * <p>
         * Valid values, which determines your range of valid values for the memory parameter:
         * <p>
         * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         * <p>
         * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         * <p>
         * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         * <p>
         * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         * <p>
         * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: 256
         * <p>
         * @return {@code this}
         * @param cpu The number of cpu units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.Number cpu) {
            this.props().cpu(cpu);
            return this;
        }

        /**
         * The amount (in MiB) of memory used by the task.
         * <p>
         * This field is required and you must use one of the following values, which determines your range of valid values
         * for the cpu parameter:
         * <p>
         * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         * <p>
         * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         * <p>
         * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         * <p>
         * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         * <p>
         * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: 512
         * <p>
         * @return {@code this}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(final java.lang.Number memoryLimitMiB) {
            this.props().memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        /**
         * The platform version on which to run your service.
         * <p>
         * If one is not specified, the LATEST platform version is used by default. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
         * in the Amazon Elastic Container Service Developer Guide.
         * <p>
         * Default: Latest
         * <p>
         * @return {@code this}
         * @param platformVersion The platform version on which to run your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.props().platformVersion(platformVersion);
            return this;
        }

        /**
         * The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param taskDefinition The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedFargateService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedFargateService build() {
            return new software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedFargateService(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedFargateServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedFargateServiceProps.Builder();
            }
            return this.props;
        }
    }
}
