package software.amazon.awscdk.services.ecs.patterns;

/**
 * A scheduled EC2 task that will be initiated off of CloudWatch Events.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-11-24T22:29:59.892Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ScheduledEc2Task")
public class ScheduledEc2Task extends software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBase {

    protected ScheduledEc2Task(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduledEc2Task(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ScheduledEc2Task class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ScheduledEc2Task(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The EC2 task definition in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ec2TaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Ec2TaskDefinition.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.patterns.ScheduledEc2Task}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.patterns.ScheduledEc2Task> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskProps.Builder();
        }

        /**
         * The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expression Syntax for Rules</a>
         * in the Amazon CloudWatch User Guide.
         * <p>
         * @return {@code this}
         * @param schedule The schedule or rate (frequency) that determines when CloudWatch Events runs the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.applicationautoscaling.Schedule schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The name of the cluster that hosts the service.
         * <p>
         * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * <p>
         * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * The desired number of instantiations of the task definition to keep running on the service.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param desiredTaskCount The desired number of instantiations of the task definition to keep running on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredTaskCount(final java.lang.Number desiredTaskCount) {
            this.props.desiredTaskCount(desiredTaskCount);
            return this;
        }

        /**
         * In what subnets to place the task's ENIs.
         * <p>
         * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * <p>
         * Default: Private subnets
         * <p>
         * @return {@code this}
         * @param subnetSelection In what subnets to place the task's ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         * <p>
         * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * <p>
         * Default: - uses the VPC defined in the cluster or creates a new VPC.
         * <p>
         * @return {@code this}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The properties to define if using an existing TaskDefinition in this construct.
         * <p>
         * ScheduledEc2TaskDefinitionOptions or ScheduledEc2TaskImageOptions must be defined, but not both.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param scheduledEc2TaskDefinitionOptions The properties to define if using an existing TaskDefinition in this construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledEc2TaskDefinitionOptions(final software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskDefinitionOptions scheduledEc2TaskDefinitionOptions) {
            this.props.scheduledEc2TaskDefinitionOptions(scheduledEc2TaskDefinitionOptions);
            return this;
        }

        /**
         * The properties to define if the construct is to create a TaskDefinition.
         * <p>
         * ScheduledEc2TaskDefinitionOptions or ScheduledEc2TaskImageOptions must be defined, but not both.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param scheduledEc2TaskImageOptions The properties to define if the construct is to create a TaskDefinition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledEc2TaskImageOptions(final software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskImageOptions scheduledEc2TaskImageOptions) {
            this.props.scheduledEc2TaskImageOptions(scheduledEc2TaskImageOptions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.patterns.ScheduledEc2Task}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.patterns.ScheduledEc2Task build() {
            return new software.amazon.awscdk.services.ecs.patterns.ScheduledEc2Task(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
