package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the ScheduledEc2Task task.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2020-12-12T01:57:09.054Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ScheduledEc2TaskProps")
@software.amazon.jsii.Jsii.Proxy(ScheduledEc2TaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduledEc2TaskProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBaseProps {

    /**
     * The properties to define if using an existing TaskDefinition in this construct.
     * <p>
     * ScheduledEc2TaskDefinitionOptions or ScheduledEc2TaskImageOptions must be defined, but not both.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskDefinitionOptions getScheduledEc2TaskDefinitionOptions() {
        return null;
    }

    /**
     * The properties to define if the construct is to create a TaskDefinition.
     * <p>
     * ScheduledEc2TaskDefinitionOptions or ScheduledEc2TaskImageOptions must be defined, but not both.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskImageOptions getScheduledEc2TaskImageOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScheduledEc2TaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledEc2TaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduledEc2TaskProps> {
        private software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskDefinitionOptions scheduledEc2TaskDefinitionOptions;
        private software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskImageOptions scheduledEc2TaskImageOptions;
        private software.amazon.awscdk.services.applicationautoscaling.Schedule schedule;
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private java.lang.Number desiredTaskCount;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ScheduledEc2TaskProps#getScheduledEc2TaskDefinitionOptions}
         * @param scheduledEc2TaskDefinitionOptions The properties to define if using an existing TaskDefinition in this construct.
         *                                          ScheduledEc2TaskDefinitionOptions or ScheduledEc2TaskImageOptions must be defined, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledEc2TaskDefinitionOptions(software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskDefinitionOptions scheduledEc2TaskDefinitionOptions) {
            this.scheduledEc2TaskDefinitionOptions = scheduledEc2TaskDefinitionOptions;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskProps#getScheduledEc2TaskImageOptions}
         * @param scheduledEc2TaskImageOptions The properties to define if the construct is to create a TaskDefinition.
         *                                     ScheduledEc2TaskDefinitionOptions or ScheduledEc2TaskImageOptions must be defined, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledEc2TaskImageOptions(software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskImageOptions scheduledEc2TaskImageOptions) {
            this.scheduledEc2TaskImageOptions = scheduledEc2TaskImageOptions;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskProps#getSchedule}
         * @param schedule The schedule or rate (frequency) that determines when CloudWatch Events runs the rule. This parameter is required.
         *                 For more information, see
         *                 <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expression Syntax for Rules</a>
         *                 in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.applicationautoscaling.Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskProps#getDesiredTaskCount}
         * @param desiredTaskCount The desired number of instantiations of the task definition to keep running on the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredTaskCount(java.lang.Number desiredTaskCount) {
            this.desiredTaskCount = desiredTaskCount;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskProps#getSubnetSelection}
         * @param subnetSelection In what subnets to place the task's ENIs.
         *                        (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledEc2TaskProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledEc2TaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduledEc2TaskProps build() {
            return new Jsii$Proxy(scheduledEc2TaskDefinitionOptions, scheduledEc2TaskImageOptions, schedule, cluster, desiredTaskCount, subnetSelection, vpc);
        }
    }

    /**
     * An implementation for {@link ScheduledEc2TaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledEc2TaskProps {
        private final software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskDefinitionOptions scheduledEc2TaskDefinitionOptions;
        private final software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskImageOptions scheduledEc2TaskImageOptions;
        private final software.amazon.awscdk.services.applicationautoscaling.Schedule schedule;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.lang.Number desiredTaskCount;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scheduledEc2TaskDefinitionOptions = software.amazon.jsii.Kernel.get(this, "scheduledEc2TaskDefinitionOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskDefinitionOptions.class));
            this.scheduledEc2TaskImageOptions = software.amazon.jsii.Kernel.get(this, "scheduledEc2TaskImageOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskImageOptions.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.Schedule.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.desiredTaskCount = software.amazon.jsii.Kernel.get(this, "desiredTaskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskDefinitionOptions scheduledEc2TaskDefinitionOptions, final software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskImageOptions scheduledEc2TaskImageOptions, final software.amazon.awscdk.services.applicationautoscaling.Schedule schedule, final software.amazon.awscdk.services.ecs.ICluster cluster, final java.lang.Number desiredTaskCount, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scheduledEc2TaskDefinitionOptions = scheduledEc2TaskDefinitionOptions;
            this.scheduledEc2TaskImageOptions = scheduledEc2TaskImageOptions;
            this.schedule = java.util.Objects.requireNonNull(schedule, "schedule is required");
            this.cluster = cluster;
            this.desiredTaskCount = desiredTaskCount;
            this.subnetSelection = subnetSelection;
            this.vpc = vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskDefinitionOptions getScheduledEc2TaskDefinitionOptions() {
            return this.scheduledEc2TaskDefinitionOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskImageOptions getScheduledEc2TaskImageOptions() {
            return this.scheduledEc2TaskImageOptions;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.Schedule getSchedule() {
            return this.schedule;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.Number getDesiredTaskCount() {
            return this.desiredTaskCount;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getScheduledEc2TaskDefinitionOptions() != null) {
                data.set("scheduledEc2TaskDefinitionOptions", om.valueToTree(this.getScheduledEc2TaskDefinitionOptions()));
            }
            if (this.getScheduledEc2TaskImageOptions() != null) {
                data.set("scheduledEc2TaskImageOptions", om.valueToTree(this.getScheduledEc2TaskImageOptions()));
            }
            data.set("schedule", om.valueToTree(this.getSchedule()));
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDesiredTaskCount() != null) {
                data.set("desiredTaskCount", om.valueToTree(this.getDesiredTaskCount()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.ScheduledEc2TaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledEc2TaskProps.Jsii$Proxy that = (ScheduledEc2TaskProps.Jsii$Proxy) o;

            if (this.scheduledEc2TaskDefinitionOptions != null ? !this.scheduledEc2TaskDefinitionOptions.equals(that.scheduledEc2TaskDefinitionOptions) : that.scheduledEc2TaskDefinitionOptions != null) return false;
            if (this.scheduledEc2TaskImageOptions != null ? !this.scheduledEc2TaskImageOptions.equals(that.scheduledEc2TaskImageOptions) : that.scheduledEc2TaskImageOptions != null) return false;
            if (!schedule.equals(that.schedule)) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.desiredTaskCount != null ? !this.desiredTaskCount.equals(that.desiredTaskCount) : that.desiredTaskCount != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.scheduledEc2TaskDefinitionOptions != null ? this.scheduledEc2TaskDefinitionOptions.hashCode() : 0;
            result = 31 * result + (this.scheduledEc2TaskImageOptions != null ? this.scheduledEc2TaskImageOptions.hashCode() : 0);
            result = 31 * result + (this.schedule.hashCode());
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.desiredTaskCount != null ? this.desiredTaskCount.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
