package software.amazon.awscdk.services.ecs;

/**
 * The properties for defining a service using the External launch type.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-08T20:44:44.497Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.ExternalServiceProps")
@software.amazon.jsii.Jsii.Proxy(ExternalServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExternalServiceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.BaseServiceOptions {

    /**
     * The task definition to use for tasks in the service.
     * <p>
     * [disable-awslint:ref-via-interface]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition();

    /**
     * The security groups to associate with the service.
     * <p>
     * If you do not specify a security group, the default security group for the VPC is used.
     * <p>
     * Default: - A new security group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExternalServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExternalServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExternalServiceProps> {
        private software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        private software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        private software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        private java.lang.Number desiredCount;
        private java.lang.Boolean enableEcsManagedTags;
        private java.lang.Boolean enableExecuteCommand;
        private software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        private java.lang.Number maxHealthyPercent;
        private java.lang.Number minHealthyPercent;
        private software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTaskTagsFrom;
        private java.lang.String serviceName;

        /**
         * Sets the value of {@link ExternalServiceProps#getTaskDefinition}
         * @param taskDefinition The task definition to use for tasks in the service. This parameter is required.
         *                       [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getSecurityGroups}
         * @param securityGroups The security groups to associate with the service.
         *                       If you do not specify a security group, the default security group for the VPC is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getCluster}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getCapacityProviderStrategies}
         * @param capacityProviderStrategies A list of Capacity Provider strategies used to place a service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder capacityProviderStrategies(java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies) {
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)capacityProviderStrategies;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getCircuitBreaker}
         * @param circuitBreaker Whether to enable the deployment circuit breaker.
         *                       If this property is defined, circuit breaker will be implicitly
         *                       enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder circuitBreaker(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getCloudMapOptions}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getDeploymentController}
         * @param deploymentController Specifies which deployment controller to use for the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getDesiredCount}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(java.lang.Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getEnableExecuteCommand}
         * @param enableExecuteCommand Whether to enable the ability to execute into a container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(java.lang.Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getHealthCheckGracePeriod}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(software.amazon.awscdk.core.Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getMaxHealthyPercent}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(java.lang.Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getMinHealthyPercent}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(java.lang.Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Valid values are: PropagatedTagSource.SERVICE, PropagatedTagSource.TASK_DEFINITION or PropagatedTagSource.NONE
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getPropagateTaskTagsFrom}
         * @param propagateTaskTagsFrom Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                              Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         * @deprecated Use `propagateTags` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder propagateTaskTagsFrom(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTaskTagsFrom) {
            this.propagateTaskTagsFrom = propagateTaskTagsFrom;
            return this;
        }

        /**
         * Sets the value of {@link ExternalServiceProps#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExternalServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExternalServiceProps build() {
            return new Jsii$Proxy(taskDefinition, securityGroups, cluster, capacityProviderStrategies, circuitBreaker, cloudMapOptions, deploymentController, desiredCount, enableEcsManagedTags, enableExecuteCommand, healthCheckGracePeriod, maxHealthyPercent, minHealthyPercent, propagateTags, propagateTaskTagsFrom, serviceName);
        }
    }

    /**
     * An implementation for {@link ExternalServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExternalServiceProps {
        private final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        private final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        private final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private final software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        private final java.lang.Number desiredCount;
        private final java.lang.Boolean enableEcsManagedTags;
        private final java.lang.Boolean enableExecuteCommand;
        private final software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        private final java.lang.Number maxHealthyPercent;
        private final java.lang.Number minHealthyPercent;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTaskTagsFrom;
        private final java.lang.String serviceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.taskDefinition = software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TaskDefinition.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.capacityProviderStrategies = software.amazon.jsii.Kernel.get(this, "capacityProviderStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CapacityProviderStrategy.class)));
            this.circuitBreaker = software.amazon.jsii.Kernel.get(this, "circuitBreaker", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker.class));
            this.cloudMapOptions = software.amazon.jsii.Kernel.get(this, "cloudMapOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CloudMapOptions.class));
            this.deploymentController = software.amazon.jsii.Kernel.get(this, "deploymentController", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentController.class));
            this.desiredCount = software.amazon.jsii.Kernel.get(this, "desiredCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableECSManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableExecuteCommand = software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.healthCheckGracePeriod = software.amazon.jsii.Kernel.get(this, "healthCheckGracePeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.maxHealthyPercent = software.amazon.jsii.Kernel.get(this, "maxHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minHealthyPercent = software.amazon.jsii.Kernel.get(this, "minHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagatedTagSource.class));
            this.propagateTaskTagsFrom = software.amazon.jsii.Kernel.get(this, "propagateTaskTagsFrom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagatedTagSource.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition, final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final software.amazon.awscdk.services.ecs.ICluster cluster, final java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies, final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker, final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions, final software.amazon.awscdk.services.ecs.DeploymentController deploymentController, final java.lang.Number desiredCount, final java.lang.Boolean enableEcsManagedTags, final java.lang.Boolean enableExecuteCommand, final software.amazon.awscdk.core.Duration healthCheckGracePeriod, final java.lang.Number maxHealthyPercent, final java.lang.Number minHealthyPercent, final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags, final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTaskTagsFrom, final java.lang.String serviceName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.taskDefinition = java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required");
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            this.cluster = java.util.Objects.requireNonNull(cluster, "cluster is required");
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)capacityProviderStrategies;
            this.circuitBreaker = circuitBreaker;
            this.cloudMapOptions = cloudMapOptions;
            this.deploymentController = deploymentController;
            this.desiredCount = desiredCount;
            this.enableEcsManagedTags = enableEcsManagedTags;
            this.enableExecuteCommand = enableExecuteCommand;
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            this.maxHealthyPercent = maxHealthyPercent;
            this.minHealthyPercent = minHealthyPercent;
            this.propagateTags = propagateTags;
            this.propagateTaskTagsFrom = propagateTaskTagsFrom;
            this.serviceName = serviceName;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> getCapacityProviderStrategies() {
            return this.capacityProviderStrategies;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
            return this.circuitBreaker;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
            return this.cloudMapOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
            return this.deploymentController;
        }

        @Override
        public final java.lang.Number getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final java.lang.Boolean getEnableECSManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public final java.lang.Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final java.lang.Number getMaxHealthyPercent() {
            return this.maxHealthyPercent;
        }

        @Override
        public final java.lang.Number getMinHealthyPercent() {
            return this.minHealthyPercent;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTaskTagsFrom() {
            return this.propagateTaskTagsFrom;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            data.set("cluster", om.valueToTree(this.getCluster()));
            if (this.getCapacityProviderStrategies() != null) {
                data.set("capacityProviderStrategies", om.valueToTree(this.getCapacityProviderStrategies()));
            }
            if (this.getCircuitBreaker() != null) {
                data.set("circuitBreaker", om.valueToTree(this.getCircuitBreaker()));
            }
            if (this.getCloudMapOptions() != null) {
                data.set("cloudMapOptions", om.valueToTree(this.getCloudMapOptions()));
            }
            if (this.getDeploymentController() != null) {
                data.set("deploymentController", om.valueToTree(this.getDeploymentController()));
            }
            if (this.getDesiredCount() != null) {
                data.set("desiredCount", om.valueToTree(this.getDesiredCount()));
            }
            if (this.getEnableECSManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableECSManagedTags()));
            }
            if (this.getEnableExecuteCommand() != null) {
                data.set("enableExecuteCommand", om.valueToTree(this.getEnableExecuteCommand()));
            }
            if (this.getHealthCheckGracePeriod() != null) {
                data.set("healthCheckGracePeriod", om.valueToTree(this.getHealthCheckGracePeriod()));
            }
            if (this.getMaxHealthyPercent() != null) {
                data.set("maxHealthyPercent", om.valueToTree(this.getMaxHealthyPercent()));
            }
            if (this.getMinHealthyPercent() != null) {
                data.set("minHealthyPercent", om.valueToTree(this.getMinHealthyPercent()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getPropagateTaskTagsFrom() != null) {
                data.set("propagateTaskTagsFrom", om.valueToTree(this.getPropagateTaskTagsFrom()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.ExternalServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExternalServiceProps.Jsii$Proxy that = (ExternalServiceProps.Jsii$Proxy) o;

            if (!taskDefinition.equals(that.taskDefinition)) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (!cluster.equals(that.cluster)) return false;
            if (this.capacityProviderStrategies != null ? !this.capacityProviderStrategies.equals(that.capacityProviderStrategies) : that.capacityProviderStrategies != null) return false;
            if (this.circuitBreaker != null ? !this.circuitBreaker.equals(that.circuitBreaker) : that.circuitBreaker != null) return false;
            if (this.cloudMapOptions != null ? !this.cloudMapOptions.equals(that.cloudMapOptions) : that.cloudMapOptions != null) return false;
            if (this.deploymentController != null ? !this.deploymentController.equals(that.deploymentController) : that.deploymentController != null) return false;
            if (this.desiredCount != null ? !this.desiredCount.equals(that.desiredCount) : that.desiredCount != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.enableExecuteCommand != null ? !this.enableExecuteCommand.equals(that.enableExecuteCommand) : that.enableExecuteCommand != null) return false;
            if (this.healthCheckGracePeriod != null ? !this.healthCheckGracePeriod.equals(that.healthCheckGracePeriod) : that.healthCheckGracePeriod != null) return false;
            if (this.maxHealthyPercent != null ? !this.maxHealthyPercent.equals(that.maxHealthyPercent) : that.maxHealthyPercent != null) return false;
            if (this.minHealthyPercent != null ? !this.minHealthyPercent.equals(that.minHealthyPercent) : that.minHealthyPercent != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.propagateTaskTagsFrom != null ? !this.propagateTaskTagsFrom.equals(that.propagateTaskTagsFrom) : that.propagateTaskTagsFrom != null) return false;
            return this.serviceName != null ? this.serviceName.equals(that.serviceName) : that.serviceName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.taskDefinition.hashCode();
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.cluster.hashCode());
            result = 31 * result + (this.capacityProviderStrategies != null ? this.capacityProviderStrategies.hashCode() : 0);
            result = 31 * result + (this.circuitBreaker != null ? this.circuitBreaker.hashCode() : 0);
            result = 31 * result + (this.cloudMapOptions != null ? this.cloudMapOptions.hashCode() : 0);
            result = 31 * result + (this.deploymentController != null ? this.deploymentController.hashCode() : 0);
            result = 31 * result + (this.desiredCount != null ? this.desiredCount.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.enableExecuteCommand != null ? this.enableExecuteCommand.hashCode() : 0);
            result = 31 * result + (this.healthCheckGracePeriod != null ? this.healthCheckGracePeriod.hashCode() : 0);
            result = 31 * result + (this.maxHealthyPercent != null ? this.maxHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.minHealthyPercent != null ? this.minHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.propagateTaskTagsFrom != null ? this.propagateTaskTagsFrom.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            return result;
        }
    }
}
