package software.amazon.awscdk.services.ecs;

/**
 * The placement strategies to use for tasks in the service. For more information, see [Amazon ECS Task Placement Strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
 * <p>
 * Tasks will preferentially be placed on instances that match these rules.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-08T20:44:44.530Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.PlacementStrategy")
public class PlacementStrategy extends software.amazon.jsii.JsiiObject {

    protected PlacementStrategy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PlacementStrategy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Places tasks on the container instances with the least available capacity of the specified resource.
     * <p>
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy packedBy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BinPackResource resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "packedBy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Places tasks on container instances with the least available amount of CPU capacity.
     * <p>
     * This minimizes the number of instances in use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy packedByCpu() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "packedByCpu", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class));
    }

    /**
     * Places tasks on container instances with the least available amount of memory capacity.
     * <p>
     * This minimizes the number of instances in use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy packedByMemory() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "packedByMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class));
    }

    /**
     * Places tasks randomly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy randomly() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "randomly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class));
    }

    /**
     * Places tasks evenly based on the specified value.
     * <p>
     * You can use one of the built-in attributes found on <code>BuiltInAttributes</code>
     * or supply your own custom instance attributes. If more than one attribute
     * is supplied, spreading is done in order.
     * <p>
     * Default: attributes instanceId
     * <p>
     * @param fields This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy spreadAcross(final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "spreadAcross", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class), java.util.Arrays.<Object>stream(fields).toArray(Object[]::new));
    }

    /**
     * Places tasks evenly across all container instances in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy spreadAcrossInstances() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementStrategy.class, "spreadAcrossInstances", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class));
    }

    /**
     * Return the placement JSON.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.PlacementStrategyProperty> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.PlacementStrategyProperty.class))));
    }
}
