/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface HealthCheck
extends JsiiSerializable {
    public Number getPort();

    public Number getHealthyThreshold();

    public Duration getInterval();

    public String getPath();

    public LoadBalancingProtocol getProtocol();

    public Duration getTimeout();

    public Number getUnhealthyThreshold();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _port;
        @Nullable
        private Number _healthyThreshold;
        @Nullable
        private Duration _interval;
        @Nullable
        private String _path;
        @Nullable
        private LoadBalancingProtocol _protocol;
        @Nullable
        private Duration _timeout;
        @Nullable
        private Number _unhealthyThreshold;

        public Builder withPort(Number value) {
            this._port = Objects.requireNonNull(value, "port is required");
            return this;
        }

        public Builder withHealthyThreshold(@Nullable Number value) {
            this._healthyThreshold = value;
            return this;
        }

        public Builder withInterval(@Nullable Duration value) {
            this._interval = value;
            return this;
        }

        public Builder withPath(@Nullable String value) {
            this._path = value;
            return this;
        }

        public Builder withProtocol(@Nullable LoadBalancingProtocol value) {
            this._protocol = value;
            return this;
        }

        public Builder withTimeout(@Nullable Duration value) {
            this._timeout = value;
            return this;
        }

        public Builder withUnhealthyThreshold(@Nullable Number value) {
            this._unhealthyThreshold = value;
            return this;
        }

        public HealthCheck build() {
            return new HealthCheck(){
                private final Number $port;
                @Nullable
                private final Number $healthyThreshold;
                @Nullable
                private final Duration $interval;
                @Nullable
                private final String $path;
                @Nullable
                private final LoadBalancingProtocol $protocol;
                @Nullable
                private final Duration $timeout;
                @Nullable
                private final Number $unhealthyThreshold;
                {
                    this.$port = Objects.requireNonNull(_port, "port is required");
                    this.$healthyThreshold = _healthyThreshold;
                    this.$interval = _interval;
                    this.$path = _path;
                    this.$protocol = _protocol;
                    this.$timeout = _timeout;
                    this.$unhealthyThreshold = _unhealthyThreshold;
                }

                @Override
                public Number getPort() {
                    return this.$port;
                }

                @Override
                public Number getHealthyThreshold() {
                    return this.$healthyThreshold;
                }

                @Override
                public Duration getInterval() {
                    return this.$interval;
                }

                @Override
                public String getPath() {
                    return this.$path;
                }

                @Override
                public LoadBalancingProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public Duration getTimeout() {
                    return this.$timeout;
                }

                @Override
                public Number getUnhealthyThreshold() {
                    return this.$unhealthyThreshold;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("port", om.valueToTree((Object)this.getPort()));
                    if (this.getHealthyThreshold() != null) {
                        obj.set("healthyThreshold", om.valueToTree((Object)this.getHealthyThreshold()));
                    }
                    if (this.getInterval() != null) {
                        obj.set("interval", om.valueToTree((Object)this.getInterval()));
                    }
                    if (this.getPath() != null) {
                        obj.set("path", om.valueToTree((Object)this.getPath()));
                    }
                    if (this.getProtocol() != null) {
                        obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                    }
                    if (this.getTimeout() != null) {
                        obj.set("timeout", om.valueToTree((Object)this.getTimeout()));
                    }
                    if (this.getUnhealthyThreshold() != null) {
                        obj.set("unhealthyThreshold", om.valueToTree((Object)this.getUnhealthyThreshold()));
                    }
                    return obj;
                }
            };
        }
    }
}

