/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface LoadBalancerListener
extends JsiiSerializable {
    public Number getExternalPort();

    public List<IConnectable> getAllowConnectionsFrom();

    public LoadBalancingProtocol getExternalProtocol();

    public Number getInternalPort();

    public LoadBalancingProtocol getInternalProtocol();

    public List<String> getPolicyNames();

    public String getSslCertificateId();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _externalPort;
        @Nullable
        private List<IConnectable> _allowConnectionsFrom;
        @Nullable
        private LoadBalancingProtocol _externalProtocol;
        @Nullable
        private Number _internalPort;
        @Nullable
        private LoadBalancingProtocol _internalProtocol;
        @Nullable
        private List<String> _policyNames;
        @Nullable
        private String _sslCertificateId;

        public Builder withExternalPort(Number value) {
            this._externalPort = Objects.requireNonNull(value, "externalPort is required");
            return this;
        }

        public Builder withAllowConnectionsFrom(@Nullable List<IConnectable> value) {
            this._allowConnectionsFrom = value;
            return this;
        }

        public Builder withExternalProtocol(@Nullable LoadBalancingProtocol value) {
            this._externalProtocol = value;
            return this;
        }

        public Builder withInternalPort(@Nullable Number value) {
            this._internalPort = value;
            return this;
        }

        public Builder withInternalProtocol(@Nullable LoadBalancingProtocol value) {
            this._internalProtocol = value;
            return this;
        }

        public Builder withPolicyNames(@Nullable List<String> value) {
            this._policyNames = value;
            return this;
        }

        public Builder withSslCertificateId(@Nullable String value) {
            this._sslCertificateId = value;
            return this;
        }

        public LoadBalancerListener build() {
            return new LoadBalancerListener(){
                private final Number $externalPort;
                @Nullable
                private final List<IConnectable> $allowConnectionsFrom;
                @Nullable
                private final LoadBalancingProtocol $externalProtocol;
                @Nullable
                private final Number $internalPort;
                @Nullable
                private final LoadBalancingProtocol $internalProtocol;
                @Nullable
                private final List<String> $policyNames;
                @Nullable
                private final String $sslCertificateId;
                {
                    this.$externalPort = Objects.requireNonNull(_externalPort, "externalPort is required");
                    this.$allowConnectionsFrom = _allowConnectionsFrom;
                    this.$externalProtocol = _externalProtocol;
                    this.$internalPort = _internalPort;
                    this.$internalProtocol = _internalProtocol;
                    this.$policyNames = _policyNames;
                    this.$sslCertificateId = _sslCertificateId;
                }

                @Override
                public Number getExternalPort() {
                    return this.$externalPort;
                }

                @Override
                public List<IConnectable> getAllowConnectionsFrom() {
                    return this.$allowConnectionsFrom;
                }

                @Override
                public LoadBalancingProtocol getExternalProtocol() {
                    return this.$externalProtocol;
                }

                @Override
                public Number getInternalPort() {
                    return this.$internalPort;
                }

                @Override
                public LoadBalancingProtocol getInternalProtocol() {
                    return this.$internalProtocol;
                }

                @Override
                public List<String> getPolicyNames() {
                    return this.$policyNames;
                }

                @Override
                public String getSslCertificateId() {
                    return this.$sslCertificateId;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("externalPort", om.valueToTree((Object)this.getExternalPort()));
                    if (this.getAllowConnectionsFrom() != null) {
                        obj.set("allowConnectionsFrom", om.valueToTree(this.getAllowConnectionsFrom()));
                    }
                    if (this.getExternalProtocol() != null) {
                        obj.set("externalProtocol", om.valueToTree((Object)this.getExternalProtocol()));
                    }
                    if (this.getInternalPort() != null) {
                        obj.set("internalPort", om.valueToTree((Object)this.getInternalPort()));
                    }
                    if (this.getInternalProtocol() != null) {
                        obj.set("internalProtocol", om.valueToTree((Object)this.getInternalProtocol()));
                    }
                    if (this.getPolicyNames() != null) {
                        obj.set("policyNames", om.valueToTree(this.getPolicyNames()));
                    }
                    if (this.getSslCertificateId() != null) {
                        obj.set("sslCertificateId", om.valueToTree((Object)this.getSslCertificateId()));
                    }
                    return obj;
                }
            };
        }
    }
}

