/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancing.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface LoadBalancerProps
extends JsiiSerializable {
    public IVpc getVpc();

    public Boolean getCrossZone();

    public HealthCheck getHealthCheck();

    public Boolean getInternetFacing();

    public List<LoadBalancerListener> getListeners();

    public List<ILoadBalancerTarget> getTargets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IVpc _vpc;
        @Nullable
        private Boolean _crossZone;
        @Nullable
        private HealthCheck _healthCheck;
        @Nullable
        private Boolean _internetFacing;
        @Nullable
        private List<LoadBalancerListener> _listeners;
        @Nullable
        private List<ILoadBalancerTarget> _targets;

        public Builder withVpc(IVpc value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withCrossZone(@Nullable Boolean value) {
            this._crossZone = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheck value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withInternetFacing(@Nullable Boolean value) {
            this._internetFacing = value;
            return this;
        }

        public Builder withListeners(@Nullable List<LoadBalancerListener> value) {
            this._listeners = value;
            return this;
        }

        public Builder withTargets(@Nullable List<ILoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }

        public LoadBalancerProps build() {
            return new LoadBalancerProps(){
                private final IVpc $vpc;
                @Nullable
                private final Boolean $crossZone;
                @Nullable
                private final HealthCheck $healthCheck;
                @Nullable
                private final Boolean $internetFacing;
                @Nullable
                private final List<LoadBalancerListener> $listeners;
                @Nullable
                private final List<ILoadBalancerTarget> $targets;
                {
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$crossZone = _crossZone;
                    this.$healthCheck = _healthCheck;
                    this.$internetFacing = _internetFacing;
                    this.$listeners = _listeners;
                    this.$targets = _targets;
                }

                @Override
                public IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public Boolean getCrossZone() {
                    return this.$crossZone;
                }

                @Override
                public HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public List<LoadBalancerListener> getListeners() {
                    return this.$listeners;
                }

                @Override
                public List<ILoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    if (this.getCrossZone() != null) {
                        obj.set("crossZone", om.valueToTree((Object)this.getCrossZone()));
                    }
                    if (this.getHealthCheck() != null) {
                        obj.set("healthCheck", om.valueToTree((Object)this.getHealthCheck()));
                    }
                    if (this.getInternetFacing() != null) {
                        obj.set("internetFacing", om.valueToTree((Object)this.getInternetFacing()));
                    }
                    if (this.getListeners() != null) {
                        obj.set("listeners", om.valueToTree(this.getListeners()));
                    }
                    if (this.getTargets() != null) {
                        obj.set("targets", om.valueToTree(this.getTargets()));
                    }
                    return obj;
                }
            };
        }
    }
}

