package software.amazon.awscdk.services.elasticsearch;

/**
 * Configures log settings for the domain.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.39.0 (build 8af72c2)", date = "2021-10-14T05:49:26.792Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.LoggingOptions")
@software.amazon.jsii.Jsii.Proxy(LoggingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoggingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specify if Elasticsearch application logging should be set up.
     * <p>
     * Requires Elasticsearch version 5.1 or later.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAppLogEnabled() {
        return null;
    }

    /**
     * Log Elasticsearch application logs to this log group.
     * <p>
     * Default: - a new log group is created if app logging is enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getAppLogGroup() {
        return null;
    }

    /**
     * Specify if Elasticsearch audit logging should be set up.
     * <p>
     * Requires Elasticsearch version 6.7 or later and fine grained access control to be enabled.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAuditLogEnabled() {
        return null;
    }

    /**
     * Log Elasticsearch audit logs to this log group.
     * <p>
     * Default: - a new log group is created if audit logging is enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getAuditLogGroup() {
        return null;
    }

    /**
     * Specify if slow index logging should be set up.
     * <p>
     * Requires Elasticsearch version 5.1 or later.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSlowIndexLogEnabled() {
        return null;
    }

    /**
     * Log slow indices to this log group.
     * <p>
     * Default: - a new log group is created if slow index logging is enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getSlowIndexLogGroup() {
        return null;
    }

    /**
     * Specify if slow search logging should be set up.
     * <p>
     * Requires Elasticsearch version 5.1 or later.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSlowSearchLogEnabled() {
        return null;
    }

    /**
     * Log slow searches to this log group.
     * <p>
     * Default: - a new log group is created if slow search logging is enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getSlowSearchLogGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoggingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoggingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoggingOptions> {
        private java.lang.Boolean appLogEnabled;
        private software.amazon.awscdk.services.logs.ILogGroup appLogGroup;
        private java.lang.Boolean auditLogEnabled;
        private software.amazon.awscdk.services.logs.ILogGroup auditLogGroup;
        private java.lang.Boolean slowIndexLogEnabled;
        private software.amazon.awscdk.services.logs.ILogGroup slowIndexLogGroup;
        private java.lang.Boolean slowSearchLogEnabled;
        private software.amazon.awscdk.services.logs.ILogGroup slowSearchLogGroup;

        /**
         * Sets the value of {@link LoggingOptions#getAppLogEnabled}
         * @param appLogEnabled Specify if Elasticsearch application logging should be set up.
         *                      Requires Elasticsearch version 5.1 or later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appLogEnabled(java.lang.Boolean appLogEnabled) {
            this.appLogEnabled = appLogEnabled;
            return this;
        }

        /**
         * Sets the value of {@link LoggingOptions#getAppLogGroup}
         * @param appLogGroup Log Elasticsearch application logs to this log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appLogGroup(software.amazon.awscdk.services.logs.ILogGroup appLogGroup) {
            this.appLogGroup = appLogGroup;
            return this;
        }

        /**
         * Sets the value of {@link LoggingOptions#getAuditLogEnabled}
         * @param auditLogEnabled Specify if Elasticsearch audit logging should be set up.
         *                        Requires Elasticsearch version 6.7 or later and fine grained access control to be enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auditLogEnabled(java.lang.Boolean auditLogEnabled) {
            this.auditLogEnabled = auditLogEnabled;
            return this;
        }

        /**
         * Sets the value of {@link LoggingOptions#getAuditLogGroup}
         * @param auditLogGroup Log Elasticsearch audit logs to this log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auditLogGroup(software.amazon.awscdk.services.logs.ILogGroup auditLogGroup) {
            this.auditLogGroup = auditLogGroup;
            return this;
        }

        /**
         * Sets the value of {@link LoggingOptions#getSlowIndexLogEnabled}
         * @param slowIndexLogEnabled Specify if slow index logging should be set up.
         *                            Requires Elasticsearch version 5.1 or later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slowIndexLogEnabled(java.lang.Boolean slowIndexLogEnabled) {
            this.slowIndexLogEnabled = slowIndexLogEnabled;
            return this;
        }

        /**
         * Sets the value of {@link LoggingOptions#getSlowIndexLogGroup}
         * @param slowIndexLogGroup Log slow indices to this log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slowIndexLogGroup(software.amazon.awscdk.services.logs.ILogGroup slowIndexLogGroup) {
            this.slowIndexLogGroup = slowIndexLogGroup;
            return this;
        }

        /**
         * Sets the value of {@link LoggingOptions#getSlowSearchLogEnabled}
         * @param slowSearchLogEnabled Specify if slow search logging should be set up.
         *                             Requires Elasticsearch version 5.1 or later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slowSearchLogEnabled(java.lang.Boolean slowSearchLogEnabled) {
            this.slowSearchLogEnabled = slowSearchLogEnabled;
            return this;
        }

        /**
         * Sets the value of {@link LoggingOptions#getSlowSearchLogGroup}
         * @param slowSearchLogGroup Log slow searches to this log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slowSearchLogGroup(software.amazon.awscdk.services.logs.ILogGroup slowSearchLogGroup) {
            this.slowSearchLogGroup = slowSearchLogGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoggingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoggingOptions build() {
            return new Jsii$Proxy(appLogEnabled, appLogGroup, auditLogEnabled, auditLogGroup, slowIndexLogEnabled, slowIndexLogGroup, slowSearchLogEnabled, slowSearchLogGroup);
        }
    }

    /**
     * An implementation for {@link LoggingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingOptions {
        private final java.lang.Boolean appLogEnabled;
        private final software.amazon.awscdk.services.logs.ILogGroup appLogGroup;
        private final java.lang.Boolean auditLogEnabled;
        private final software.amazon.awscdk.services.logs.ILogGroup auditLogGroup;
        private final java.lang.Boolean slowIndexLogEnabled;
        private final software.amazon.awscdk.services.logs.ILogGroup slowIndexLogGroup;
        private final java.lang.Boolean slowSearchLogEnabled;
        private final software.amazon.awscdk.services.logs.ILogGroup slowSearchLogGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appLogEnabled = software.amazon.jsii.Kernel.get(this, "appLogEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.appLogGroup = software.amazon.jsii.Kernel.get(this, "appLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.auditLogEnabled = software.amazon.jsii.Kernel.get(this, "auditLogEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.auditLogGroup = software.amazon.jsii.Kernel.get(this, "auditLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.slowIndexLogEnabled = software.amazon.jsii.Kernel.get(this, "slowIndexLogEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.slowIndexLogGroup = software.amazon.jsii.Kernel.get(this, "slowIndexLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.slowSearchLogEnabled = software.amazon.jsii.Kernel.get(this, "slowSearchLogEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.slowSearchLogGroup = software.amazon.jsii.Kernel.get(this, "slowSearchLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean appLogEnabled, final software.amazon.awscdk.services.logs.ILogGroup appLogGroup, final java.lang.Boolean auditLogEnabled, final software.amazon.awscdk.services.logs.ILogGroup auditLogGroup, final java.lang.Boolean slowIndexLogEnabled, final software.amazon.awscdk.services.logs.ILogGroup slowIndexLogGroup, final java.lang.Boolean slowSearchLogEnabled, final software.amazon.awscdk.services.logs.ILogGroup slowSearchLogGroup) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appLogEnabled = appLogEnabled;
            this.appLogGroup = appLogGroup;
            this.auditLogEnabled = auditLogEnabled;
            this.auditLogGroup = auditLogGroup;
            this.slowIndexLogEnabled = slowIndexLogEnabled;
            this.slowIndexLogGroup = slowIndexLogGroup;
            this.slowSearchLogEnabled = slowSearchLogEnabled;
            this.slowSearchLogGroup = slowSearchLogGroup;
        }

        @Override
        public final java.lang.Boolean getAppLogEnabled() {
            return this.appLogEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getAppLogGroup() {
            return this.appLogGroup;
        }

        @Override
        public final java.lang.Boolean getAuditLogEnabled() {
            return this.auditLogEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getAuditLogGroup() {
            return this.auditLogGroup;
        }

        @Override
        public final java.lang.Boolean getSlowIndexLogEnabled() {
            return this.slowIndexLogEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getSlowIndexLogGroup() {
            return this.slowIndexLogGroup;
        }

        @Override
        public final java.lang.Boolean getSlowSearchLogEnabled() {
            return this.slowSearchLogEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getSlowSearchLogGroup() {
            return this.slowSearchLogGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAppLogEnabled() != null) {
                data.set("appLogEnabled", om.valueToTree(this.getAppLogEnabled()));
            }
            if (this.getAppLogGroup() != null) {
                data.set("appLogGroup", om.valueToTree(this.getAppLogGroup()));
            }
            if (this.getAuditLogEnabled() != null) {
                data.set("auditLogEnabled", om.valueToTree(this.getAuditLogEnabled()));
            }
            if (this.getAuditLogGroup() != null) {
                data.set("auditLogGroup", om.valueToTree(this.getAuditLogGroup()));
            }
            if (this.getSlowIndexLogEnabled() != null) {
                data.set("slowIndexLogEnabled", om.valueToTree(this.getSlowIndexLogEnabled()));
            }
            if (this.getSlowIndexLogGroup() != null) {
                data.set("slowIndexLogGroup", om.valueToTree(this.getSlowIndexLogGroup()));
            }
            if (this.getSlowSearchLogEnabled() != null) {
                data.set("slowSearchLogEnabled", om.valueToTree(this.getSlowSearchLogEnabled()));
            }
            if (this.getSlowSearchLogGroup() != null) {
                data.set("slowSearchLogGroup", om.valueToTree(this.getSlowSearchLogGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.LoggingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoggingOptions.Jsii$Proxy that = (LoggingOptions.Jsii$Proxy) o;

            if (this.appLogEnabled != null ? !this.appLogEnabled.equals(that.appLogEnabled) : that.appLogEnabled != null) return false;
            if (this.appLogGroup != null ? !this.appLogGroup.equals(that.appLogGroup) : that.appLogGroup != null) return false;
            if (this.auditLogEnabled != null ? !this.auditLogEnabled.equals(that.auditLogEnabled) : that.auditLogEnabled != null) return false;
            if (this.auditLogGroup != null ? !this.auditLogGroup.equals(that.auditLogGroup) : that.auditLogGroup != null) return false;
            if (this.slowIndexLogEnabled != null ? !this.slowIndexLogEnabled.equals(that.slowIndexLogEnabled) : that.slowIndexLogEnabled != null) return false;
            if (this.slowIndexLogGroup != null ? !this.slowIndexLogGroup.equals(that.slowIndexLogGroup) : that.slowIndexLogGroup != null) return false;
            if (this.slowSearchLogEnabled != null ? !this.slowSearchLogEnabled.equals(that.slowSearchLogEnabled) : that.slowSearchLogEnabled != null) return false;
            return this.slowSearchLogGroup != null ? this.slowSearchLogGroup.equals(that.slowSearchLogGroup) : that.slowSearchLogGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appLogEnabled != null ? this.appLogEnabled.hashCode() : 0;
            result = 31 * result + (this.appLogGroup != null ? this.appLogGroup.hashCode() : 0);
            result = 31 * result + (this.auditLogEnabled != null ? this.auditLogEnabled.hashCode() : 0);
            result = 31 * result + (this.auditLogGroup != null ? this.auditLogGroup.hashCode() : 0);
            result = 31 * result + (this.slowIndexLogEnabled != null ? this.slowIndexLogEnabled.hashCode() : 0);
            result = 31 * result + (this.slowIndexLogGroup != null ? this.slowIndexLogGroup.hashCode() : 0);
            result = 31 * result + (this.slowSearchLogEnabled != null ? this.slowSearchLogEnabled.hashCode() : 0);
            result = 31 * result + (this.slowSearchLogGroup != null ? this.slowSearchLogGroup.hashCode() : 0);
            return result;
        }
    }
}
