package software.amazon.awscdk.services.elasticsearch;

/**
 * Properties for an AWS Elasticsearch Domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(ElasticsearchVersion.V7_4)
 *         .ebs(EbsOptions.builder()
 *                 .volumeSize(100)
 *                 .volumeType(EbsDeviceVolumeType.GENERAL_PURPOSE_SSD)
 *                 .build())
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(EncryptionAtRestOptions.builder()
 *                 .enabled(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-11T17:58:49.380Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.DomainProps")
@software.amazon.jsii.Jsii.Proxy(DomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Elasticsearch version that your domain will leverage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion getVersion();

    /**
     * Domain Access policies.
     * <p>
     * Default: - No access policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getAccessPolicies() {
        return null;
    }

    /**
     * Additional options to specify for the Amazon ES domain.
     * <p>
     * Default: - no advanced options are specified
     * <p>
     * @see https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getAdvancedOptions() {
        return null;
    }

    /**
     * The hour in UTC during which the service takes an automated daily snapshot of the indices in the Amazon ES domain.
     * <p>
     * Only applies for Elasticsearch
     * versions below 5.3.
     * <p>
     * Default: - Hourly automated snapshots not used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAutomatedSnapshotStartHour() {
        return null;
    }

    /**
     * The cluster capacity configuration for the Amazon ES domain.
     * <p>
     * Default: - 1 r5.large.elasticsearch data node; no dedicated master nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CapacityConfig getCapacity() {
        return null;
    }

    /**
     * Configures Amazon ES to use Amazon Cognito authentication for Kibana.
     * <p>
     * Default: - Cognito not used for authentication to Kibana.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CognitoOptions getCognitoKibanaAuth() {
        return null;
    }

    /**
     * To configure a custom domain configure these options.
     * <p>
     * If you specify a Route53 hosted zone it will create a CNAME record and use DNS validation for the certificate
     * <p>
     * Default: - no custom domain endpoint will be configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CustomEndpointOptions getCustomEndpoint() {
        return null;
    }

    /**
     * Enforces a particular physical domain name.
     * <p>
     * Default: - A name will be auto-generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the Amazon ES domain.
     * <p>
     * For more information, see
     * [Configuring EBS-based Storage]
     * (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
     * in the Amazon Elasticsearch Service Developer Guide.
     * <p>
     * Default: - 10 GiB General Purpose (SSD) volumes per node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.EbsOptions getEbs() {
        return null;
    }

    /**
     * To upgrade an Amazon ES domain to a new version of Elasticsearch rather than replacing the entire domain resource, use the EnableVersionUpgrade update policy.
     * <p>
     * Default: - false
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeelasticsearchdomain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableVersionUpgrade() {
        return null;
    }

    /**
     * Encryption at rest options for the cluster.
     * <p>
     * Default: - No encryption at rest
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions getEncryptionAtRest() {
        return null;
    }

    /**
     * True to require that all traffic to the domain arrive over HTTPS.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnforceHttps() {
        return null;
    }

    /**
     * Specifies options for fine-grained access control.
     * <p>
     * Requires Elasticsearch version 6.7 or later. Enabling fine-grained access control
     * also requires encryption of data at rest and node-to-node encryption, along with
     * enforced HTTPS.
     * <p>
     * Default: - fine-grained access control is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions getFineGrainedAccessControl() {
        return null;
    }

    /**
     * Configuration log publishing configuration options.
     * <p>
     * Default: - No logs are published
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.LoggingOptions getLogging() {
        return null;
    }

    /**
     * Specify true to enable node to node encryption.
     * <p>
     * Requires Elasticsearch version 6.0 or later.
     * <p>
     * Default: - Node to node encryption is not enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNodeToNodeEncryption() {
        return null;
    }

    /**
     * Policy to apply when the domain is removed from the stack.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * The list of security groups that are associated with the VPC endpoints for the domain.
     * <p>
     * Only used if <code>vpc</code> is specified.
     * <p>
     * Default: - One new security group is created.
     * <p>
     * @see https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * The minimum TLS version required for traffic to the domain.
     * <p>
     * Default: - TLSSecurityPolicy.TLS_1_0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.TLSSecurityPolicy getTlsSecurityPolicy() {
        return null;
    }

    /**
     * Configures the domain so that unsigned basic auth is enabled.
     * <p>
     * If no master user is provided a default master user
     * with username <code>admin</code> and a dynamically generated password stored in KMS is created. The password can be retrieved
     * by getting <code>masterUserPassword</code> from the domain instance.
     * <p>
     * Setting this to true will also add an access policy that allows unsigned
     * access, enable node to node encryption, encryption at rest. If conflicting
     * settings are encountered (like disabling encryption at rest) enabling this
     * setting will cause a failure.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseUnsignedBasicAuth() {
        return null;
    }

    /**
     * Place the domain inside this VPC.
     * <p>
     * Default: - Domain is not placed in a VPC.
     * <p>
     * @see https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * The specific vpc subnets the domain will be placed in.
     * <p>
     * You must provide one subnet for each Availability Zone
     * that your domain uses. For example, you must specify three subnet IDs for a three Availability Zone
     * domain.
     * <p>
     * Only used if <code>vpc</code> is specified.
     * <p>
     * Default: - All private subnets.
     * <p>
     * @see https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpcSubnets() {
        return null;
    }

    /**
     * The cluster zone awareness configuration for the Amazon ES domain.
     * <p>
     * Default: - no zone awareness (1 AZ)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig getZoneAwareness() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DomainProps> {
        software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion version;
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> accessPolicies;
        java.util.Map<java.lang.String, java.lang.String> advancedOptions;
        java.lang.Number automatedSnapshotStartHour;
        software.amazon.awscdk.services.elasticsearch.CapacityConfig capacity;
        software.amazon.awscdk.services.elasticsearch.CognitoOptions cognitoKibanaAuth;
        software.amazon.awscdk.services.elasticsearch.CustomEndpointOptions customEndpoint;
        java.lang.String domainName;
        software.amazon.awscdk.services.elasticsearch.EbsOptions ebs;
        java.lang.Boolean enableVersionUpgrade;
        software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions encryptionAtRest;
        java.lang.Boolean enforceHttps;
        software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions fineGrainedAccessControl;
        software.amazon.awscdk.services.elasticsearch.LoggingOptions logging;
        java.lang.Boolean nodeToNodeEncryption;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.elasticsearch.TLSSecurityPolicy tlsSecurityPolicy;
        java.lang.Boolean useUnsignedBasicAuth;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;
        software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig zoneAwareness;

        /**
         * Sets the value of {@link DomainProps#getVersion}
         * @param version The Elasticsearch version that your domain will leverage. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getAccessPolicies}
         * @param accessPolicies Domain Access policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder accessPolicies(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> accessPolicies) {
            this.accessPolicies = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)accessPolicies;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getAdvancedOptions}
         * @param advancedOptions Additional options to specify for the Amazon ES domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(java.util.Map<java.lang.String, java.lang.String> advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getAutomatedSnapshotStartHour}
         * @param automatedSnapshotStartHour The hour in UTC during which the service takes an automated daily snapshot of the indices in the Amazon ES domain.
         *                                   Only applies for Elasticsearch
         *                                   versions below 5.3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automatedSnapshotStartHour(java.lang.Number automatedSnapshotStartHour) {
            this.automatedSnapshotStartHour = automatedSnapshotStartHour;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getCapacity}
         * @param capacity The cluster capacity configuration for the Amazon ES domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(software.amazon.awscdk.services.elasticsearch.CapacityConfig capacity) {
            this.capacity = capacity;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getCognitoKibanaAuth}
         * @param cognitoKibanaAuth Configures Amazon ES to use Amazon Cognito authentication for Kibana.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoKibanaAuth(software.amazon.awscdk.services.elasticsearch.CognitoOptions cognitoKibanaAuth) {
            this.cognitoKibanaAuth = cognitoKibanaAuth;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getCustomEndpoint}
         * @param customEndpoint To configure a custom domain configure these options.
         *                       If you specify a Route53 hosted zone it will create a CNAME record and use DNS validation for the certificate
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEndpoint(software.amazon.awscdk.services.elasticsearch.CustomEndpointOptions customEndpoint) {
            this.customEndpoint = customEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getDomainName}
         * @param domainName Enforces a particular physical domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getEbs}
         * @param ebs The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the Amazon ES domain.
         *            For more information, see
         *            [Configuring EBS-based Storage]
         *            (https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
         *            in the Amazon Elasticsearch Service Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebs(software.amazon.awscdk.services.elasticsearch.EbsOptions ebs) {
            this.ebs = ebs;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getEnableVersionUpgrade}
         * @param enableVersionUpgrade To upgrade an Amazon ES domain to a new version of Elasticsearch rather than replacing the entire domain resource, use the EnableVersionUpgrade update policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableVersionUpgrade(java.lang.Boolean enableVersionUpgrade) {
            this.enableVersionUpgrade = enableVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getEncryptionAtRest}
         * @param encryptionAtRest Encryption at rest options for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRest(software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getEnforceHttps}
         * @param enforceHttps True to require that all traffic to the domain arrive over HTTPS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceHttps(java.lang.Boolean enforceHttps) {
            this.enforceHttps = enforceHttps;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getFineGrainedAccessControl}
         * @param fineGrainedAccessControl Specifies options for fine-grained access control.
         *                                 Requires Elasticsearch version 6.7 or later. Enabling fine-grained access control
         *                                 also requires encryption of data at rest and node-to-node encryption, along with
         *                                 enforced HTTPS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fineGrainedAccessControl(software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions fineGrainedAccessControl) {
            this.fineGrainedAccessControl = fineGrainedAccessControl;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getLogging}
         * @param logging Configuration log publishing configuration options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.elasticsearch.LoggingOptions logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getNodeToNodeEncryption}
         * @param nodeToNodeEncryption Specify true to enable node to node encryption.
         *                             Requires Elasticsearch version 6.0 or later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryption(java.lang.Boolean nodeToNodeEncryption) {
            this.nodeToNodeEncryption = nodeToNodeEncryption;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the domain is removed from the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getSecurityGroups}
         * @param securityGroups The list of security groups that are associated with the VPC endpoints for the domain.
         *                       Only used if <code>vpc</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getTlsSecurityPolicy}
         * @param tlsSecurityPolicy The minimum TLS version required for traffic to the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsSecurityPolicy(software.amazon.awscdk.services.elasticsearch.TLSSecurityPolicy tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getUseUnsignedBasicAuth}
         * @param useUnsignedBasicAuth Configures the domain so that unsigned basic auth is enabled.
         *                             If no master user is provided a default master user
         *                             with username <code>admin</code> and a dynamically generated password stored in KMS is created. The password can be retrieved
         *                             by getting <code>masterUserPassword</code> from the domain instance.
         *                             <p>
         *                             Setting this to true will also add an access policy that allows unsigned
         *                             access, enable node to node encryption, encryption at rest. If conflicting
         *                             settings are encountered (like disabling encryption at rest) enabling this
         *                             setting will cause a failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useUnsignedBasicAuth(java.lang.Boolean useUnsignedBasicAuth) {
            this.useUnsignedBasicAuth = useUnsignedBasicAuth;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getVpc}
         * @param vpc Place the domain inside this VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getVpcSubnets}
         * @param vpcSubnets The specific vpc subnets the domain will be placed in.
         *                   You must provide one subnet for each Availability Zone
         *                   that your domain uses. For example, you must specify three subnet IDs for a three Availability Zone
         *                   domain.
         *                   <p>
         *                   Only used if <code>vpc</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder vpcSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link DomainProps#getZoneAwareness}
         * @param zoneAwareness The cluster zone awareness configuration for the Amazon ES domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneAwareness(software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig zoneAwareness) {
            this.zoneAwareness = zoneAwareness;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainProps {
        private final software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion version;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> accessPolicies;
        private final java.util.Map<java.lang.String, java.lang.String> advancedOptions;
        private final java.lang.Number automatedSnapshotStartHour;
        private final software.amazon.awscdk.services.elasticsearch.CapacityConfig capacity;
        private final software.amazon.awscdk.services.elasticsearch.CognitoOptions cognitoKibanaAuth;
        private final software.amazon.awscdk.services.elasticsearch.CustomEndpointOptions customEndpoint;
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.elasticsearch.EbsOptions ebs;
        private final java.lang.Boolean enableVersionUpgrade;
        private final software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions encryptionAtRest;
        private final java.lang.Boolean enforceHttps;
        private final software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions fineGrainedAccessControl;
        private final software.amazon.awscdk.services.elasticsearch.LoggingOptions logging;
        private final java.lang.Boolean nodeToNodeEncryption;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.elasticsearch.TLSSecurityPolicy tlsSecurityPolicy;
        private final java.lang.Boolean useUnsignedBasicAuth;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;
        private final software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig zoneAwareness;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion.class));
            this.accessPolicies = software.amazon.jsii.Kernel.get(this, "accessPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.advancedOptions = software.amazon.jsii.Kernel.get(this, "advancedOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.automatedSnapshotStartHour = software.amazon.jsii.Kernel.get(this, "automatedSnapshotStartHour", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.CapacityConfig.class));
            this.cognitoKibanaAuth = software.amazon.jsii.Kernel.get(this, "cognitoKibanaAuth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.CognitoOptions.class));
            this.customEndpoint = software.amazon.jsii.Kernel.get(this, "customEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.CustomEndpointOptions.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ebs = software.amazon.jsii.Kernel.get(this, "ebs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.EbsOptions.class));
            this.enableVersionUpgrade = software.amazon.jsii.Kernel.get(this, "enableVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.encryptionAtRest = software.amazon.jsii.Kernel.get(this, "encryptionAtRest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions.class));
            this.enforceHttps = software.amazon.jsii.Kernel.get(this, "enforceHttps", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.fineGrainedAccessControl = software.amazon.jsii.Kernel.get(this, "fineGrainedAccessControl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.LoggingOptions.class));
            this.nodeToNodeEncryption = software.amazon.jsii.Kernel.get(this, "nodeToNodeEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.tlsSecurityPolicy = software.amazon.jsii.Kernel.get(this, "tlsSecurityPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.TLSSecurityPolicy.class));
            this.useUnsignedBasicAuth = software.amazon.jsii.Kernel.get(this, "useUnsignedBasicAuth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class)));
            this.zoneAwareness = software.amazon.jsii.Kernel.get(this, "zoneAwareness", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.accessPolicies = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.accessPolicies;
            this.advancedOptions = builder.advancedOptions;
            this.automatedSnapshotStartHour = builder.automatedSnapshotStartHour;
            this.capacity = builder.capacity;
            this.cognitoKibanaAuth = builder.cognitoKibanaAuth;
            this.customEndpoint = builder.customEndpoint;
            this.domainName = builder.domainName;
            this.ebs = builder.ebs;
            this.enableVersionUpgrade = builder.enableVersionUpgrade;
            this.encryptionAtRest = builder.encryptionAtRest;
            this.enforceHttps = builder.enforceHttps;
            this.fineGrainedAccessControl = builder.fineGrainedAccessControl;
            this.logging = builder.logging;
            this.nodeToNodeEncryption = builder.nodeToNodeEncryption;
            this.removalPolicy = builder.removalPolicy;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.tlsSecurityPolicy = builder.tlsSecurityPolicy;
            this.useUnsignedBasicAuth = builder.useUnsignedBasicAuth;
            this.vpc = builder.vpc;
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)builder.vpcSubnets;
            this.zoneAwareness = builder.zoneAwareness;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.ElasticsearchVersion getVersion() {
            return this.version;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getAdvancedOptions() {
            return this.advancedOptions;
        }

        @Override
        public final java.lang.Number getAutomatedSnapshotStartHour() {
            return this.automatedSnapshotStartHour;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.CapacityConfig getCapacity() {
            return this.capacity;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.CognitoOptions getCognitoKibanaAuth() {
            return this.cognitoKibanaAuth;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.CustomEndpointOptions getCustomEndpoint() {
            return this.customEndpoint;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.EbsOptions getEbs() {
            return this.ebs;
        }

        @Override
        public final java.lang.Boolean getEnableVersionUpgrade() {
            return this.enableVersionUpgrade;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions getEncryptionAtRest() {
            return this.encryptionAtRest;
        }

        @Override
        public final java.lang.Boolean getEnforceHttps() {
            return this.enforceHttps;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.AdvancedSecurityOptions getFineGrainedAccessControl() {
            return this.fineGrainedAccessControl;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.LoggingOptions getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.Boolean getNodeToNodeEncryption() {
            return this.nodeToNodeEncryption;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.TLSSecurityPolicy getTlsSecurityPolicy() {
            return this.tlsSecurityPolicy;
        }

        @Override
        public final java.lang.Boolean getUseUnsignedBasicAuth() {
            return this.useUnsignedBasicAuth;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig getZoneAwareness() {
            return this.zoneAwareness;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getAccessPolicies() != null) {
                data.set("accessPolicies", om.valueToTree(this.getAccessPolicies()));
            }
            if (this.getAdvancedOptions() != null) {
                data.set("advancedOptions", om.valueToTree(this.getAdvancedOptions()));
            }
            if (this.getAutomatedSnapshotStartHour() != null) {
                data.set("automatedSnapshotStartHour", om.valueToTree(this.getAutomatedSnapshotStartHour()));
            }
            if (this.getCapacity() != null) {
                data.set("capacity", om.valueToTree(this.getCapacity()));
            }
            if (this.getCognitoKibanaAuth() != null) {
                data.set("cognitoKibanaAuth", om.valueToTree(this.getCognitoKibanaAuth()));
            }
            if (this.getCustomEndpoint() != null) {
                data.set("customEndpoint", om.valueToTree(this.getCustomEndpoint()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEbs() != null) {
                data.set("ebs", om.valueToTree(this.getEbs()));
            }
            if (this.getEnableVersionUpgrade() != null) {
                data.set("enableVersionUpgrade", om.valueToTree(this.getEnableVersionUpgrade()));
            }
            if (this.getEncryptionAtRest() != null) {
                data.set("encryptionAtRest", om.valueToTree(this.getEncryptionAtRest()));
            }
            if (this.getEnforceHttps() != null) {
                data.set("enforceHttps", om.valueToTree(this.getEnforceHttps()));
            }
            if (this.getFineGrainedAccessControl() != null) {
                data.set("fineGrainedAccessControl", om.valueToTree(this.getFineGrainedAccessControl()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getNodeToNodeEncryption() != null) {
                data.set("nodeToNodeEncryption", om.valueToTree(this.getNodeToNodeEncryption()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getTlsSecurityPolicy() != null) {
                data.set("tlsSecurityPolicy", om.valueToTree(this.getTlsSecurityPolicy()));
            }
            if (this.getUseUnsignedBasicAuth() != null) {
                data.set("useUnsignedBasicAuth", om.valueToTree(this.getUseUnsignedBasicAuth()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getZoneAwareness() != null) {
                data.set("zoneAwareness", om.valueToTree(this.getZoneAwareness()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.DomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainProps.Jsii$Proxy that = (DomainProps.Jsii$Proxy) o;

            if (!version.equals(that.version)) return false;
            if (this.accessPolicies != null ? !this.accessPolicies.equals(that.accessPolicies) : that.accessPolicies != null) return false;
            if (this.advancedOptions != null ? !this.advancedOptions.equals(that.advancedOptions) : that.advancedOptions != null) return false;
            if (this.automatedSnapshotStartHour != null ? !this.automatedSnapshotStartHour.equals(that.automatedSnapshotStartHour) : that.automatedSnapshotStartHour != null) return false;
            if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) return false;
            if (this.cognitoKibanaAuth != null ? !this.cognitoKibanaAuth.equals(that.cognitoKibanaAuth) : that.cognitoKibanaAuth != null) return false;
            if (this.customEndpoint != null ? !this.customEndpoint.equals(that.customEndpoint) : that.customEndpoint != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
            if (this.enableVersionUpgrade != null ? !this.enableVersionUpgrade.equals(that.enableVersionUpgrade) : that.enableVersionUpgrade != null) return false;
            if (this.encryptionAtRest != null ? !this.encryptionAtRest.equals(that.encryptionAtRest) : that.encryptionAtRest != null) return false;
            if (this.enforceHttps != null ? !this.enforceHttps.equals(that.enforceHttps) : that.enforceHttps != null) return false;
            if (this.fineGrainedAccessControl != null ? !this.fineGrainedAccessControl.equals(that.fineGrainedAccessControl) : that.fineGrainedAccessControl != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.nodeToNodeEncryption != null ? !this.nodeToNodeEncryption.equals(that.nodeToNodeEncryption) : that.nodeToNodeEncryption != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.tlsSecurityPolicy != null ? !this.tlsSecurityPolicy.equals(that.tlsSecurityPolicy) : that.tlsSecurityPolicy != null) return false;
            if (this.useUnsignedBasicAuth != null ? !this.useUnsignedBasicAuth.equals(that.useUnsignedBasicAuth) : that.useUnsignedBasicAuth != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            return this.zoneAwareness != null ? this.zoneAwareness.equals(that.zoneAwareness) : that.zoneAwareness == null;
        }

        @Override
        public final int hashCode() {
            int result = this.version.hashCode();
            result = 31 * result + (this.accessPolicies != null ? this.accessPolicies.hashCode() : 0);
            result = 31 * result + (this.advancedOptions != null ? this.advancedOptions.hashCode() : 0);
            result = 31 * result + (this.automatedSnapshotStartHour != null ? this.automatedSnapshotStartHour.hashCode() : 0);
            result = 31 * result + (this.capacity != null ? this.capacity.hashCode() : 0);
            result = 31 * result + (this.cognitoKibanaAuth != null ? this.cognitoKibanaAuth.hashCode() : 0);
            result = 31 * result + (this.customEndpoint != null ? this.customEndpoint.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
            result = 31 * result + (this.enableVersionUpgrade != null ? this.enableVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.encryptionAtRest != null ? this.encryptionAtRest.hashCode() : 0);
            result = 31 * result + (this.enforceHttps != null ? this.enforceHttps.hashCode() : 0);
            result = 31 * result + (this.fineGrainedAccessControl != null ? this.fineGrainedAccessControl.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.nodeToNodeEncryption != null ? this.nodeToNodeEncryption.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.tlsSecurityPolicy != null ? this.tlsSecurityPolicy.hashCode() : 0);
            result = 31 * result + (this.useUnsignedBasicAuth != null ? this.useUnsignedBasicAuth.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.zoneAwareness != null ? this.zoneAwareness.hashCode() : 0);
            return result;
        }
    }
}
