package software.amazon.awscdk.services.elasticsearch;

/**
 * A CloudFormation `AWS::Elasticsearch::Domain`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-02T12:03:06.362Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain")
public class CfnDomain extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.CfnDomain.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Elasticsearch::Domain`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomain(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Elasticsearch::Domain`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomain(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticsearch.CfnDomain fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticsearch.CfnDomain.class, "fromCloudFormation", software.amazon.awscdk.services.elasticsearch.CfnDomain.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainEndpoint() {
        return this.jsiiGet("attrDomainEndpoint", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Elasticsearch::Domain.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.AccessPolicies`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-accesspolicies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAccessPolicies() {
        return this.jsiiGet("accessPolicies", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.AccessPolicies`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-accesspolicies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessPolicies(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiSet("accessPolicies", java.util.Objects.requireNonNull(value, "accessPolicies is required"));
    }

    /**
     * `AWS::Elasticsearch::Domain.AdvancedOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedOptions() {
        return this.jsiiGet("advancedOptions", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.AdvancedOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("advancedOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.AdvancedOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedOptions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("advancedOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.CognitoOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCognitoOptions() {
        return this.jsiiGet("cognitoOptions", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.CognitoOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("cognitoOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.CognitoOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.CognitoOptionsProperty value) {
        this.jsiiSet("cognitoOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.DomainName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return this.jsiiGet("domainName", java.lang.String.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.DomainName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("domainName", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.EBSOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptions() {
        return this.jsiiGet("ebsOptions", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.EBSOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ebsOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.EBSOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.EBSOptionsProperty value) {
        this.jsiiSet("ebsOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchClusterConfig() {
        return this.jsiiGet("elasticsearchClusterConfig", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchClusterConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("elasticsearchClusterConfig", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchClusterConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty value) {
        this.jsiiSet("elasticsearchClusterConfig", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchVersion`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getElasticsearchVersion() {
        return this.jsiiGet("elasticsearchVersion", java.lang.String.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchVersion`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("elasticsearchVersion", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionAtRestOptions() {
        return this.jsiiGet("encryptionAtRestOptions", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionAtRestOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("encryptionAtRestOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionAtRestOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty value) {
        this.jsiiSet("encryptionAtRestOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.LogPublishingOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogPublishingOptions() {
        return this.jsiiGet("logPublishingOptions", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.LogPublishingOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPublishingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("logPublishingOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.LogPublishingOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPublishingOptions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        this.jsiiSet("logPublishingOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNodeToNodeEncryptionOptions() {
        return this.jsiiGet("nodeToNodeEncryptionOptions", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeToNodeEncryptionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("nodeToNodeEncryptionOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeToNodeEncryptionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty value) {
        this.jsiiSet("nodeToNodeEncryptionOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.SnapshotOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotOptions() {
        return this.jsiiGet("snapshotOptions", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.SnapshotOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("snapshotOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.SnapshotOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.SnapshotOptionsProperty value) {
        this.jsiiSet("snapshotOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.VPCOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcOptions() {
        return this.jsiiGet("vpcOptions", java.lang.Object.class);
    }

    /**
     * `AWS::Elasticsearch::Domain.VPCOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("vpcOptions", value);
    }

    /**
     * `AWS::Elasticsearch::Domain.VPCOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.VPCOptionsProperty value) {
        this.jsiiSet("vpcOptions", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain.CognitoOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomain.CognitoOptionsProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * `CfnDomain.CognitoOptionsProperty.IdentityPoolId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-identitypoolid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityPoolId() {
            return null;
        }

        /**
         * `CfnDomain.CognitoOptionsProperty.RoleArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * `CfnDomain.CognitoOptionsProperty.UserPoolId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-userpoolid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoOptionsProperty> {
            private java.lang.Object enabled;
            private java.lang.String identityPoolId;
            private java.lang.String roleArn;
            private java.lang.String userPoolId;

            /**
             * Sets the value of {@link CognitoOptionsProperty#getEnabled}
             * @param enabled `CfnDomain.CognitoOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getEnabled}
             * @param enabled `CfnDomain.CognitoOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getIdentityPoolId}
             * @param identityPoolId `CfnDomain.CognitoOptionsProperty.IdentityPoolId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityPoolId(java.lang.String identityPoolId) {
                this.identityPoolId = identityPoolId;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getRoleArn}
             * @param roleArn `CfnDomain.CognitoOptionsProperty.RoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getUserPoolId}
             * @param userPoolId `CfnDomain.CognitoOptionsProperty.UserPoolId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoOptionsProperty build() {
                return new Jsii$Proxy(enabled, identityPoolId, roleArn, userPoolId);
            }
        }

        /**
         * An implementation for {@link CognitoOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String identityPoolId;
            private final java.lang.String roleArn;
            private final java.lang.String userPoolId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.identityPoolId = this.jsiiGet("identityPoolId", java.lang.String.class);
                this.roleArn = this.jsiiGet("roleArn", java.lang.String.class);
                this.userPoolId = this.jsiiGet("userPoolId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled, final java.lang.String identityPoolId, final java.lang.String roleArn, final java.lang.String userPoolId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = enabled;
                this.identityPoolId = identityPoolId;
                this.roleArn = roleArn;
                this.userPoolId = userPoolId;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.String getIdentityPoolId() {
                return this.identityPoolId;
            }

            @Override
            public java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getIdentityPoolId() != null) {
                    data.set("identityPoolId", om.valueToTree(this.getIdentityPoolId()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getUserPoolId() != null) {
                    data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.CfnDomain.CognitoOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoOptionsProperty.Jsii$Proxy that = (CognitoOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.identityPoolId != null ? !this.identityPoolId.equals(that.identityPoolId) : that.identityPoolId != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.userPoolId != null ? this.userPoolId.equals(that.userPoolId) : that.userPoolId == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.identityPoolId != null ? this.identityPoolId.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.userPoolId != null ? this.userPoolId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain.EBSOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EBSOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EBSOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomain.EBSOptionsProperty.EBSEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-ebsenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsEnabled() {
            return null;
        }

        /**
         * `CfnDomain.EBSOptionsProperty.Iops`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-iops
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * `CfnDomain.EBSOptionsProperty.VolumeSize`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumesize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * `CfnDomain.EBSOptionsProperty.VolumeType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EBSOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EBSOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EBSOptionsProperty> {
            private java.lang.Object ebsEnabled;
            private java.lang.Number iops;
            private java.lang.Number volumeSize;
            private java.lang.String volumeType;

            /**
             * Sets the value of {@link EBSOptionsProperty#getEbsEnabled}
             * @param ebsEnabled `CfnDomain.EBSOptionsProperty.EBSEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsEnabled(java.lang.Boolean ebsEnabled) {
                this.ebsEnabled = ebsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getEbsEnabled}
             * @param ebsEnabled `CfnDomain.EBSOptionsProperty.EBSEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsEnabled(software.amazon.awscdk.core.IResolvable ebsEnabled) {
                this.ebsEnabled = ebsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getIops}
             * @param iops `CfnDomain.EBSOptionsProperty.Iops`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getVolumeSize}
             * @param volumeSize `CfnDomain.EBSOptionsProperty.VolumeSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getVolumeType}
             * @param volumeType `CfnDomain.EBSOptionsProperty.VolumeType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EBSOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EBSOptionsProperty build() {
                return new Jsii$Proxy(ebsEnabled, iops, volumeSize, volumeType);
            }
        }

        /**
         * An implementation for {@link EBSOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EBSOptionsProperty {
            private final java.lang.Object ebsEnabled;
            private final java.lang.Number iops;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsEnabled = this.jsiiGet("ebsEnabled", java.lang.Object.class);
                this.iops = this.jsiiGet("iops", java.lang.Number.class);
                this.volumeSize = this.jsiiGet("volumeSize", java.lang.Number.class);
                this.volumeType = this.jsiiGet("volumeType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object ebsEnabled, final java.lang.Number iops, final java.lang.Number volumeSize, final java.lang.String volumeType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsEnabled = ebsEnabled;
                this.iops = iops;
                this.volumeSize = volumeSize;
                this.volumeType = volumeType;
            }

            @Override
            public java.lang.Object getEbsEnabled() {
                return this.ebsEnabled;
            }

            @Override
            public java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsEnabled() != null) {
                    data.set("ebsEnabled", om.valueToTree(this.getEbsEnabled()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.CfnDomain.EBSOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EBSOptionsProperty.Jsii$Proxy that = (EBSOptionsProperty.Jsii$Proxy) o;

                if (this.ebsEnabled != null ? !this.ebsEnabled.equals(that.ebsEnabled) : that.ebsEnabled != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public int hashCode() {
                int result = this.ebsEnabled != null ? this.ebsEnabled.hashCode() : 0;
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchClusterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchClusterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-dedicatedmastercount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDedicatedMasterCount() {
            return null;
        }

        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-dedicatedmasterenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDedicatedMasterEnabled() {
            return null;
        }

        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-dedicatedmastertype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDedicatedMasterType() {
            return null;
        }

        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.InstanceCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-instancecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceCount() {
            return null;
        }

        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.InstanceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-instnacetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-zoneawarenessconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZoneAwarenessConfig() {
            return null;
        }

        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessEnabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-zoneawarenessenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZoneAwarenessEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchClusterConfigProperty> {
            private java.lang.Number dedicatedMasterCount;
            private java.lang.Object dedicatedMasterEnabled;
            private java.lang.String dedicatedMasterType;
            private java.lang.Number instanceCount;
            private java.lang.String instanceType;
            private java.lang.Object zoneAwarenessConfig;
            private java.lang.Object zoneAwarenessEnabled;

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getDedicatedMasterCount}
             * @param dedicatedMasterCount `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterCount(java.lang.Number dedicatedMasterCount) {
                this.dedicatedMasterCount = dedicatedMasterCount;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getDedicatedMasterEnabled}
             * @param dedicatedMasterEnabled `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterEnabled(java.lang.Boolean dedicatedMasterEnabled) {
                this.dedicatedMasterEnabled = dedicatedMasterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getDedicatedMasterEnabled}
             * @param dedicatedMasterEnabled `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterEnabled(software.amazon.awscdk.core.IResolvable dedicatedMasterEnabled) {
                this.dedicatedMasterEnabled = dedicatedMasterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getDedicatedMasterType}
             * @param dedicatedMasterType `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterType(java.lang.String dedicatedMasterType) {
                this.dedicatedMasterType = dedicatedMasterType;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getInstanceCount}
             * @param instanceCount `CfnDomain.ElasticsearchClusterConfigProperty.InstanceCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getInstanceType}
             * @param instanceType `CfnDomain.ElasticsearchClusterConfigProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getZoneAwarenessConfig}
             * @param zoneAwarenessConfig `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessConfig(software.amazon.awscdk.core.IResolvable zoneAwarenessConfig) {
                this.zoneAwarenessConfig = zoneAwarenessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getZoneAwarenessConfig}
             * @param zoneAwarenessConfig `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessConfig(software.amazon.awscdk.services.elasticsearch.CfnDomain.ZoneAwarenessConfigProperty zoneAwarenessConfig) {
                this.zoneAwarenessConfig = zoneAwarenessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getZoneAwarenessEnabled}
             * @param zoneAwarenessEnabled `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessEnabled(java.lang.Boolean zoneAwarenessEnabled) {
                this.zoneAwarenessEnabled = zoneAwarenessEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getZoneAwarenessEnabled}
             * @param zoneAwarenessEnabled `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessEnabled(software.amazon.awscdk.core.IResolvable zoneAwarenessEnabled) {
                this.zoneAwarenessEnabled = zoneAwarenessEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchClusterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchClusterConfigProperty build() {
                return new Jsii$Proxy(dedicatedMasterCount, dedicatedMasterEnabled, dedicatedMasterType, instanceCount, instanceType, zoneAwarenessConfig, zoneAwarenessEnabled);
            }
        }

        /**
         * An implementation for {@link ElasticsearchClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchClusterConfigProperty {
            private final java.lang.Number dedicatedMasterCount;
            private final java.lang.Object dedicatedMasterEnabled;
            private final java.lang.String dedicatedMasterType;
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Object zoneAwarenessConfig;
            private final java.lang.Object zoneAwarenessEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dedicatedMasterCount = this.jsiiGet("dedicatedMasterCount", java.lang.Number.class);
                this.dedicatedMasterEnabled = this.jsiiGet("dedicatedMasterEnabled", java.lang.Object.class);
                this.dedicatedMasterType = this.jsiiGet("dedicatedMasterType", java.lang.String.class);
                this.instanceCount = this.jsiiGet("instanceCount", java.lang.Number.class);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
                this.zoneAwarenessConfig = this.jsiiGet("zoneAwarenessConfig", java.lang.Object.class);
                this.zoneAwarenessEnabled = this.jsiiGet("zoneAwarenessEnabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number dedicatedMasterCount, final java.lang.Object dedicatedMasterEnabled, final java.lang.String dedicatedMasterType, final java.lang.Number instanceCount, final java.lang.String instanceType, final java.lang.Object zoneAwarenessConfig, final java.lang.Object zoneAwarenessEnabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dedicatedMasterCount = dedicatedMasterCount;
                this.dedicatedMasterEnabled = dedicatedMasterEnabled;
                this.dedicatedMasterType = dedicatedMasterType;
                this.instanceCount = instanceCount;
                this.instanceType = instanceType;
                this.zoneAwarenessConfig = zoneAwarenessConfig;
                this.zoneAwarenessEnabled = zoneAwarenessEnabled;
            }

            @Override
            public java.lang.Number getDedicatedMasterCount() {
                return this.dedicatedMasterCount;
            }

            @Override
            public java.lang.Object getDedicatedMasterEnabled() {
                return this.dedicatedMasterEnabled;
            }

            @Override
            public java.lang.String getDedicatedMasterType() {
                return this.dedicatedMasterType;
            }

            @Override
            public java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public java.lang.Object getZoneAwarenessConfig() {
                return this.zoneAwarenessConfig;
            }

            @Override
            public java.lang.Object getZoneAwarenessEnabled() {
                return this.zoneAwarenessEnabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDedicatedMasterCount() != null) {
                    data.set("dedicatedMasterCount", om.valueToTree(this.getDedicatedMasterCount()));
                }
                if (this.getDedicatedMasterEnabled() != null) {
                    data.set("dedicatedMasterEnabled", om.valueToTree(this.getDedicatedMasterEnabled()));
                }
                if (this.getDedicatedMasterType() != null) {
                    data.set("dedicatedMasterType", om.valueToTree(this.getDedicatedMasterType()));
                }
                if (this.getInstanceCount() != null) {
                    data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getZoneAwarenessConfig() != null) {
                    data.set("zoneAwarenessConfig", om.valueToTree(this.getZoneAwarenessConfig()));
                }
                if (this.getZoneAwarenessEnabled() != null) {
                    data.set("zoneAwarenessEnabled", om.valueToTree(this.getZoneAwarenessEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchClusterConfigProperty.Jsii$Proxy that = (ElasticsearchClusterConfigProperty.Jsii$Proxy) o;

                if (this.dedicatedMasterCount != null ? !this.dedicatedMasterCount.equals(that.dedicatedMasterCount) : that.dedicatedMasterCount != null) return false;
                if (this.dedicatedMasterEnabled != null ? !this.dedicatedMasterEnabled.equals(that.dedicatedMasterEnabled) : that.dedicatedMasterEnabled != null) return false;
                if (this.dedicatedMasterType != null ? !this.dedicatedMasterType.equals(that.dedicatedMasterType) : that.dedicatedMasterType != null) return false;
                if (this.instanceCount != null ? !this.instanceCount.equals(that.instanceCount) : that.instanceCount != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.zoneAwarenessConfig != null ? !this.zoneAwarenessConfig.equals(that.zoneAwarenessConfig) : that.zoneAwarenessConfig != null) return false;
                return this.zoneAwarenessEnabled != null ? this.zoneAwarenessEnabled.equals(that.zoneAwarenessEnabled) : that.zoneAwarenessEnabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.dedicatedMasterCount != null ? this.dedicatedMasterCount.hashCode() : 0;
                result = 31 * result + (this.dedicatedMasterEnabled != null ? this.dedicatedMasterEnabled.hashCode() : 0);
                result = 31 * result + (this.dedicatedMasterType != null ? this.dedicatedMasterType.hashCode() : 0);
                result = 31 * result + (this.instanceCount != null ? this.instanceCount.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.zoneAwarenessConfig != null ? this.zoneAwarenessConfig.hashCode() : 0);
                result = 31 * result + (this.zoneAwarenessEnabled != null ? this.zoneAwarenessEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionAtRestOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionAtRestOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomain.EncryptionAtRestOptionsProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * `CfnDomain.EncryptionAtRestOptionsProperty.KmsKeyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-kmskeyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionAtRestOptionsProperty> {
            private java.lang.Object enabled;
            private java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getEnabled}
             * @param enabled `CfnDomain.EncryptionAtRestOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getEnabled}
             * @param enabled `CfnDomain.EncryptionAtRestOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getKmsKeyId}
             * @param kmsKeyId `CfnDomain.EncryptionAtRestOptionsProperty.KmsKeyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionAtRestOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionAtRestOptionsProperty build() {
                return new Jsii$Proxy(enabled, kmsKeyId);
            }
        }

        /**
         * An implementation for {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionAtRestOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.kmsKeyId = this.jsiiGet("kmsKeyId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled, final java.lang.String kmsKeyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = enabled;
                this.kmsKeyId = kmsKeyId;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionAtRestOptionsProperty.Jsii$Proxy that = (EncryptionAtRestOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain.LogPublishingOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(LogPublishingOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogPublishingOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomain.LogPublishingOptionProperty.CloudWatchLogsLogGroupArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-cloudwatchlogsloggrouparn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsLogGroupArn() {
            return null;
        }

        /**
         * `CfnDomain.LogPublishingOptionProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogPublishingOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogPublishingOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogPublishingOptionProperty> {
            private java.lang.String cloudWatchLogsLogGroupArn;
            private java.lang.Object enabled;

            /**
             * Sets the value of {@link LogPublishingOptionProperty#getCloudWatchLogsLogGroupArn}
             * @param cloudWatchLogsLogGroupArn `CfnDomain.LogPublishingOptionProperty.CloudWatchLogsLogGroupArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsLogGroupArn(java.lang.String cloudWatchLogsLogGroupArn) {
                this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link LogPublishingOptionProperty#getEnabled}
             * @param enabled `CfnDomain.LogPublishingOptionProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link LogPublishingOptionProperty#getEnabled}
             * @param enabled `CfnDomain.LogPublishingOptionProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogPublishingOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogPublishingOptionProperty build() {
                return new Jsii$Proxy(cloudWatchLogsLogGroupArn, enabled);
            }
        }

        /**
         * An implementation for {@link LogPublishingOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogPublishingOptionProperty {
            private final java.lang.String cloudWatchLogsLogGroupArn;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsLogGroupArn = this.jsiiGet("cloudWatchLogsLogGroupArn", java.lang.String.class);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String cloudWatchLogsLogGroupArn, final java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
                this.enabled = enabled;
            }

            @Override
            public java.lang.String getCloudWatchLogsLogGroupArn() {
                return this.cloudWatchLogsLogGroupArn;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogsLogGroupArn() != null) {
                    data.set("cloudWatchLogsLogGroupArn", om.valueToTree(this.getCloudWatchLogsLogGroupArn()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.CfnDomain.LogPublishingOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogPublishingOptionProperty.Jsii$Proxy that = (LogPublishingOptionProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogsLogGroupArn != null ? !this.cloudWatchLogsLogGroupArn.equals(that.cloudWatchLogsLogGroupArn) : that.cloudWatchLogsLogGroupArn != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.cloudWatchLogsLogGroupArn != null ? this.cloudWatchLogsLogGroupArn.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeToNodeEncryptionOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeToNodeEncryptionOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomain.NodeToNodeEncryptionOptionsProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeToNodeEncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeToNodeEncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeToNodeEncryptionOptionsProperty> {
            private java.lang.Object enabled;

            /**
             * Sets the value of {@link NodeToNodeEncryptionOptionsProperty#getEnabled}
             * @param enabled `CfnDomain.NodeToNodeEncryptionOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link NodeToNodeEncryptionOptionsProperty#getEnabled}
             * @param enabled `CfnDomain.NodeToNodeEncryptionOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeToNodeEncryptionOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeToNodeEncryptionOptionsProperty build() {
                return new Jsii$Proxy(enabled);
            }
        }

        /**
         * An implementation for {@link NodeToNodeEncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeToNodeEncryptionOptionsProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = enabled;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeToNodeEncryptionOptionsProperty.Jsii$Proxy that = (NodeToNodeEncryptionOptionsProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain.SnapshotOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SnapshotOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnapshotOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomain.SnapshotOptionsProperty.AutomatedSnapshotStartHour`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html#cfn-elasticsearch-domain-snapshotoptions-automatedsnapshotstarthour
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomatedSnapshotStartHour() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnapshotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnapshotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnapshotOptionsProperty> {
            private java.lang.Number automatedSnapshotStartHour;

            /**
             * Sets the value of {@link SnapshotOptionsProperty#getAutomatedSnapshotStartHour}
             * @param automatedSnapshotStartHour `CfnDomain.SnapshotOptionsProperty.AutomatedSnapshotStartHour`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automatedSnapshotStartHour(java.lang.Number automatedSnapshotStartHour) {
                this.automatedSnapshotStartHour = automatedSnapshotStartHour;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnapshotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnapshotOptionsProperty build() {
                return new Jsii$Proxy(automatedSnapshotStartHour);
            }
        }

        /**
         * An implementation for {@link SnapshotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnapshotOptionsProperty {
            private final java.lang.Number automatedSnapshotStartHour;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automatedSnapshotStartHour = this.jsiiGet("automatedSnapshotStartHour", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number automatedSnapshotStartHour) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automatedSnapshotStartHour = automatedSnapshotStartHour;
            }

            @Override
            public java.lang.Number getAutomatedSnapshotStartHour() {
                return this.automatedSnapshotStartHour;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomatedSnapshotStartHour() != null) {
                    data.set("automatedSnapshotStartHour", om.valueToTree(this.getAutomatedSnapshotStartHour()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.CfnDomain.SnapshotOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnapshotOptionsProperty.Jsii$Proxy that = (SnapshotOptionsProperty.Jsii$Proxy) o;

                return this.automatedSnapshotStartHour != null ? this.automatedSnapshotStartHour.equals(that.automatedSnapshotStartHour) : that.automatedSnapshotStartHour == null;
            }

            @Override
            public int hashCode() {
                int result = this.automatedSnapshotStartHour != null ? this.automatedSnapshotStartHour.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain.VPCOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(VPCOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VPCOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomain.VPCOptionsProperty.SecurityGroupIds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-securitygroupids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * `CfnDomain.VPCOptionsProperty.SubnetIds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-subnetids
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VPCOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VPCOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VPCOptionsProperty> {
            private java.util.List<java.lang.String> securityGroupIds;
            private java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link VPCOptionsProperty#getSecurityGroupIds}
             * @param securityGroupIds `CfnDomain.VPCOptionsProperty.SecurityGroupIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VPCOptionsProperty#getSubnetIds}
             * @param subnetIds `CfnDomain.VPCOptionsProperty.SubnetIds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VPCOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VPCOptionsProperty build() {
                return new Jsii$Proxy(securityGroupIds, subnetIds);
            }
        }

        /**
         * An implementation for {@link VPCOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VPCOptionsProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = this.jsiiGet("securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = this.jsiiGet("subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> securityGroupIds, final java.util.List<java.lang.String> subnetIds) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = securityGroupIds;
                this.subnetIds = subnetIds;
            }

            @Override
            public java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnetIds() != null) {
                    data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.CfnDomain.VPCOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VPCOptionsProperty.Jsii$Proxy that = (VPCOptionsProperty.Jsii$Proxy) o;

                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                return this.subnetIds != null ? this.subnetIds.equals(that.subnetIds) : that.subnetIds == null;
            }

            @Override
            public int hashCode() {
                int result = this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0;
                result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.CfnDomain.ZoneAwarenessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ZoneAwarenessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZoneAwarenessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomain.ZoneAwarenessConfigProperty.AvailabilityZoneCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html#cfn-elasticsearch-domain-zoneawarenessconfig-availabilityzonecount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAvailabilityZoneCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZoneAwarenessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZoneAwarenessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZoneAwarenessConfigProperty> {
            private java.lang.Number availabilityZoneCount;

            /**
             * Sets the value of {@link ZoneAwarenessConfigProperty#getAvailabilityZoneCount}
             * @param availabilityZoneCount `CfnDomain.ZoneAwarenessConfigProperty.AvailabilityZoneCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZoneCount(java.lang.Number availabilityZoneCount) {
                this.availabilityZoneCount = availabilityZoneCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZoneAwarenessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZoneAwarenessConfigProperty build() {
                return new Jsii$Proxy(availabilityZoneCount);
            }
        }

        /**
         * An implementation for {@link ZoneAwarenessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZoneAwarenessConfigProperty {
            private final java.lang.Number availabilityZoneCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZoneCount = this.jsiiGet("availabilityZoneCount", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number availabilityZoneCount) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZoneCount = availabilityZoneCount;
            }

            @Override
            public java.lang.Number getAvailabilityZoneCount() {
                return this.availabilityZoneCount;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZoneCount() != null) {
                    data.set("availabilityZoneCount", om.valueToTree(this.getAvailabilityZoneCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.CfnDomain.ZoneAwarenessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZoneAwarenessConfigProperty.Jsii$Proxy that = (ZoneAwarenessConfigProperty.Jsii$Proxy) o;

                return this.availabilityZoneCount != null ? this.availabilityZoneCount.equals(that.availabilityZoneCount) : that.availabilityZoneCount == null;
            }

            @Override
            public int hashCode() {
                int result = this.availabilityZoneCount != null ? this.availabilityZoneCount.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticsearch.CfnDomain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticsearch.CfnDomain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.elasticsearch.CfnDomainProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::Elasticsearch::Domain.AccessPolicies`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-accesspolicies
         * @param accessPolicies `AWS::Elasticsearch::Domain.AccessPolicies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicies(final java.lang.Object accessPolicies) {
            this.props().accessPolicies(accessPolicies);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.AdvancedOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions
         * @param advancedOptions `AWS::Elasticsearch::Domain.AdvancedOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(final software.amazon.awscdk.core.IResolvable advancedOptions) {
            this.props().advancedOptions(advancedOptions);
            return this;
        }
        /**
         * `AWS::Elasticsearch::Domain.AdvancedOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions
         * @param advancedOptions `AWS::Elasticsearch::Domain.AdvancedOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(final java.util.Map<java.lang.String, java.lang.String> advancedOptions) {
            this.props().advancedOptions(advancedOptions);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.CognitoOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions
         * @param cognitoOptions `AWS::Elasticsearch::Domain.CognitoOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(final software.amazon.awscdk.core.IResolvable cognitoOptions) {
            this.props().cognitoOptions(cognitoOptions);
            return this;
        }
        /**
         * `AWS::Elasticsearch::Domain.CognitoOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions
         * @param cognitoOptions `AWS::Elasticsearch::Domain.CognitoOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.CognitoOptionsProperty cognitoOptions) {
            this.props().cognitoOptions(cognitoOptions);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.DomainName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainname
         * @param domainName `AWS::Elasticsearch::Domain.DomainName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props().domainName(domainName);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.EBSOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions
         * @param ebsOptions `AWS::Elasticsearch::Domain.EBSOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(final software.amazon.awscdk.core.IResolvable ebsOptions) {
            this.props().ebsOptions(ebsOptions);
            return this;
        }
        /**
         * `AWS::Elasticsearch::Domain.EBSOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions
         * @param ebsOptions `AWS::Elasticsearch::Domain.EBSOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.EBSOptionsProperty ebsOptions) {
            this.props().ebsOptions(ebsOptions);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig
         * @param elasticsearchClusterConfig `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchClusterConfig(final software.amazon.awscdk.core.IResolvable elasticsearchClusterConfig) {
            this.props().elasticsearchClusterConfig(elasticsearchClusterConfig);
            return this;
        }
        /**
         * `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig
         * @param elasticsearchClusterConfig `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchClusterConfig(final software.amazon.awscdk.services.elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty elasticsearchClusterConfig) {
            this.props().elasticsearchClusterConfig(elasticsearchClusterConfig);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.ElasticsearchVersion`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchversion
         * @param elasticsearchVersion `AWS::Elasticsearch::Domain.ElasticsearchVersion`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchVersion(final java.lang.String elasticsearchVersion) {
            this.props().elasticsearchVersion(elasticsearchVersion);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions
         * @param encryptionAtRestOptions `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(final software.amazon.awscdk.core.IResolvable encryptionAtRestOptions) {
            this.props().encryptionAtRestOptions(encryptionAtRestOptions);
            return this;
        }
        /**
         * `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions
         * @param encryptionAtRestOptions `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty encryptionAtRestOptions) {
            this.props().encryptionAtRestOptions(encryptionAtRestOptions);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.LogPublishingOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions
         * @param logPublishingOptions `AWS::Elasticsearch::Domain.LogPublishingOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(final software.amazon.awscdk.core.IResolvable logPublishingOptions) {
            this.props().logPublishingOptions(logPublishingOptions);
            return this;
        }
        /**
         * `AWS::Elasticsearch::Domain.LogPublishingOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions
         * @param logPublishingOptions `AWS::Elasticsearch::Domain.LogPublishingOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(final java.util.Map<java.lang.String, java.lang.Object> logPublishingOptions) {
            this.props().logPublishingOptions(logPublishingOptions);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions
         * @param nodeToNodeEncryptionOptions `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(final software.amazon.awscdk.core.IResolvable nodeToNodeEncryptionOptions) {
            this.props().nodeToNodeEncryptionOptions(nodeToNodeEncryptionOptions);
            return this;
        }
        /**
         * `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions
         * @param nodeToNodeEncryptionOptions `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty nodeToNodeEncryptionOptions) {
            this.props().nodeToNodeEncryptionOptions(nodeToNodeEncryptionOptions);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.SnapshotOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions
         * @param snapshotOptions `AWS::Elasticsearch::Domain.SnapshotOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(final software.amazon.awscdk.core.IResolvable snapshotOptions) {
            this.props().snapshotOptions(snapshotOptions);
            return this;
        }
        /**
         * `AWS::Elasticsearch::Domain.SnapshotOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions
         * @param snapshotOptions `AWS::Elasticsearch::Domain.SnapshotOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.SnapshotOptionsProperty snapshotOptions) {
            this.props().snapshotOptions(snapshotOptions);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-tags
         * @param tags `AWS::Elasticsearch::Domain.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * `AWS::Elasticsearch::Domain.VPCOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions
         * @param vpcOptions `AWS::Elasticsearch::Domain.VPCOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(final software.amazon.awscdk.core.IResolvable vpcOptions) {
            this.props().vpcOptions(vpcOptions);
            return this;
        }
        /**
         * `AWS::Elasticsearch::Domain.VPCOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions
         * @param vpcOptions `AWS::Elasticsearch::Domain.VPCOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.VPCOptionsProperty vpcOptions) {
            this.props().vpcOptions(vpcOptions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticsearch.CfnDomain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticsearch.CfnDomain build() {
            return new software.amazon.awscdk.services.elasticsearch.CfnDomain(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.elasticsearch.CfnDomainProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.elasticsearch.CfnDomainProps.Builder();
            }
            return this.props;
        }
    }
}
