package software.amazon.awscdk.services.elasticsearch;

/**
 * (experimental) The virtual private cloud (VPC) configuration for the Amazon ES domain.
 * <p>
 * For
 * more information, see <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html">VPC Support for Amazon Elasticsearch Service
 * Domains</a>
 * in the Amazon Elasticsearch Service Developer Guide.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:47:04.750Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticsearch.$Module.class, fqn = "@aws-cdk/aws-elasticsearch.VpcOptions")
@software.amazon.jsii.Jsii.Proxy(VpcOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface VpcOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The list of security groups that are associated with the VPC endpoints for the domain.
     * <p>
     * If you don't provide a security group ID, Amazon ES uses
     * the default security group for the VPC. To learn more, see [Security Groups for your VPC]
     * (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the Amazon VPC
     * User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups();

    /**
     * (experimental) Provide one subnet for each Availability Zone that your domain uses.
     * <p>
     * For
     * example, you must specify three subnet IDs for a three Availability Zone
     * domain. To learn more, see [VPCs and Subnets]
     * (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the
     * Amazon VPC User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets();

    /**
     * @return a {@link Builder} of {@link VpcOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<VpcOptions> {
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;

        /**
         * Sets the value of {@link VpcOptions#getSecurityGroups}
         * @param securityGroups The list of security groups that are associated with the VPC endpoints for the domain. This parameter is required.
         *                       If you don't provide a security group ID, Amazon ES uses
         *                       the default security group for the VPC. To learn more, see [Security Groups for your VPC]
         *                       (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the Amazon VPC
         *                       User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link VpcOptions#getSubnets}
         * @param subnets Provide one subnet for each Availability Zone that your domain uses. This parameter is required.
         *                For
         *                example, you must specify three subnet IDs for a three Availability Zone
         *                domain. To learn more, see [VPCs and Subnets]
         *                (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in the
         *                Amazon VPC User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder subnets(java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public VpcOptions build() {
            return new Jsii$Proxy(securityGroups, subnets);
        }
    }

    /**
     * An implementation for {@link VpcOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcOptions {
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)java.util.Objects.requireNonNull(securityGroups, "securityGroups is required");
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)java.util.Objects.requireNonNull(subnets, "subnets is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            data.set("subnets", om.valueToTree(this.getSubnets()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticsearch.VpcOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcOptions.Jsii$Proxy that = (VpcOptions.Jsii$Proxy) o;

            if (!securityGroups.equals(that.securityGroups)) return false;
            return this.subnets.equals(that.subnets);
        }

        @Override
        public final int hashCode() {
            int result = this.securityGroups.hashCode();
            result = 31 * result + (this.subnets.hashCode());
            return result;
        }
    }
}
