package software.amazon.awscdk.services.iotthingsgraph;

/**
 * A CloudFormation `AWS::IoTThingsGraph::FlowTemplate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotthingsgraph-flowtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.11 (build d4fd44f)", date = "2019-12-17T13:05:36.635Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iotthingsgraph.$Module.class, fqn = "@aws-cdk/aws-iotthingsgraph.CfnFlowTemplate")
public class CfnFlowTemplate extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnFlowTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplate.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::IoTThingsGraph::FlowTemplate`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnFlowTemplate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::IoTThingsGraph::FlowTemplate.Definition`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotthingsgraph-flowtemplate.html#cfn-iotthingsgraph-flowtemplate-definition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDefinition() {
        return this.jsiiGet("definition", java.lang.Object.class);
    }

    /**
     * `AWS::IoTThingsGraph::FlowTemplate.Definition`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotthingsgraph-flowtemplate.html#cfn-iotthingsgraph-flowtemplate-definition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinition(final software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplate.DefinitionDocumentProperty value) {
        this.jsiiSet("definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * `AWS::IoTThingsGraph::FlowTemplate.Definition`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotthingsgraph-flowtemplate.html#cfn-iotthingsgraph-flowtemplate-definition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefinition(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * `AWS::IoTThingsGraph::FlowTemplate.CompatibleNamespaceVersion`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotthingsgraph-flowtemplate.html#cfn-iotthingsgraph-flowtemplate-compatiblenamespaceversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Number getCompatibleNamespaceVersion() {
        return this.jsiiGet("compatibleNamespaceVersion", java.lang.Number.class);
    }

    /**
     * `AWS::IoTThingsGraph::FlowTemplate.CompatibleNamespaceVersion`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotthingsgraph-flowtemplate.html#cfn-iotthingsgraph-flowtemplate-compatiblenamespaceversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCompatibleNamespaceVersion(final java.lang.Number value) {
        this.jsiiSet("compatibleNamespaceVersion", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotthingsgraph-flowtemplate-definitiondocument.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iotthingsgraph.$Module.class, fqn = "@aws-cdk/aws-iotthingsgraph.CfnFlowTemplate.DefinitionDocumentProperty")
    @software.amazon.jsii.Jsii.Proxy(DefinitionDocumentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DefinitionDocumentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFlowTemplate.DefinitionDocumentProperty.Language`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotthingsgraph-flowtemplate-definitiondocument.html#cfn-iotthingsgraph-flowtemplate-definitiondocument-language
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLanguage();

        /**
         * `CfnFlowTemplate.DefinitionDocumentProperty.Text`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotthingsgraph-flowtemplate-definitiondocument.html#cfn-iotthingsgraph-flowtemplate-definitiondocument-text
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getText();

        /**
         * @return a {@link Builder} of {@link DefinitionDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefinitionDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String language;
            private java.lang.String text;

            /**
             * Sets the value of {@link DefinitionDocumentProperty#getLanguage}
             * @param language `CfnFlowTemplate.DefinitionDocumentProperty.Language`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder language(java.lang.String language) {
                this.language = language;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionDocumentProperty#getText}
             * @param text `CfnFlowTemplate.DefinitionDocumentProperty.Text`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefinitionDocumentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DefinitionDocumentProperty build() {
                return new Jsii$Proxy(language, text);
            }
        }

        /**
         * An implementation for {@link DefinitionDocumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefinitionDocumentProperty {
            private final java.lang.String language;
            private final java.lang.String text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.language = this.jsiiGet("language", java.lang.String.class);
                this.text = this.jsiiGet("text", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String language, final java.lang.String text) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.language = java.util.Objects.requireNonNull(language, "language is required");
                this.text = java.util.Objects.requireNonNull(text, "text is required");
            }

            @Override
            public java.lang.String getLanguage() {
                return this.language;
            }

            @Override
            public java.lang.String getText() {
                return this.text;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("language", om.valueToTree(this.getLanguage()));
                data.set("text", om.valueToTree(this.getText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-iotthingsgraph.CfnFlowTemplate.DefinitionDocumentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefinitionDocumentProperty.Jsii$Proxy that = (DefinitionDocumentProperty.Jsii$Proxy) o;

                if (!language.equals(that.language)) return false;
                return this.text.equals(that.text);
            }

            @Override
            public int hashCode() {
                int result = this.language.hashCode();
                result = 31 * result + (this.text.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplateProps.Builder();
        }

        /**
         * `AWS::IoTThingsGraph::FlowTemplate.Definition`.
         * 
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotthingsgraph-flowtemplate.html#cfn-iotthingsgraph-flowtemplate-definition
         * @param definition `AWS::IoTThingsGraph::FlowTemplate.Definition`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder definition(final software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplate.DefinitionDocumentProperty definition) {
            this.props.definition(definition);
            return this;
        }
        /**
         * `AWS::IoTThingsGraph::FlowTemplate.Definition`.
         * 
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotthingsgraph-flowtemplate.html#cfn-iotthingsgraph-flowtemplate-definition
         * @param definition `AWS::IoTThingsGraph::FlowTemplate.Definition`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder definition(final software.amazon.awscdk.core.IResolvable definition) {
            this.props.definition(definition);
            return this;
        }

        /**
         * `AWS::IoTThingsGraph::FlowTemplate.CompatibleNamespaceVersion`.
         * 
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotthingsgraph-flowtemplate.html#cfn-iotthingsgraph-flowtemplate-compatiblenamespaceversion
         * @param compatibleNamespaceVersion `AWS::IoTThingsGraph::FlowTemplate.CompatibleNamespaceVersion`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder compatibleNamespaceVersion(final java.lang.Number compatibleNamespaceVersion) {
            this.props.compatibleNamespaceVersion(compatibleNamespaceVersion);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplate build() {
            return new software.amazon.awscdk.services.iotthingsgraph.CfnFlowTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
