package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Properties for a Kafka event source.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-11T00:50:33.860Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.eventsources.$Module.class, fqn = "@aws-cdk/aws-lambda-event-sources.KafkaEventSourceProps")
@software.amazon.jsii.Jsii.Proxy(KafkaEventSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KafkaEventSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.eventsources.StreamEventSourceProps {

    /**
     * The Kafka topic to subscribe to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTopic();

    /**
     * The secret with the Kafka credentials, see https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html for details This field is required if your Kafka brokers are accessed over the Internet.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KafkaEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KafkaEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KafkaEventSourceProps> {
        private java.lang.String topic;
        private software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        private java.lang.Number batchSize;
        private java.lang.Boolean bisectBatchOnError;
        private java.lang.Boolean enabled;
        private software.amazon.awscdk.core.Duration maxBatchingWindow;
        private software.amazon.awscdk.core.Duration maxRecordAge;
        private software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        private java.lang.Number parallelizationFactor;
        private java.lang.Boolean reportBatchItemFailures;
        private java.lang.Number retryAttempts;
        private software.amazon.awscdk.core.Duration tumblingWindow;

        /**
         * Sets the value of {@link KafkaEventSourceProps#getTopic}
         * @param topic The Kafka topic to subscribe to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(java.lang.String topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getSecret}
         * @param secret The secret with the Kafka credentials, see https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html for details This field is required if your Kafka brokers are accessed over the Internet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getStartingPosition}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getBatchSize}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         *                  Your function receives an
         *                  event with all the retrieved records.
         *                  <p>
         *                  Valid Range:
         *                  <p>
         *                  <ul>
         *                  <li>Minimum value of 1</li>
         *                  <li>Maximum value of:
         *                  <p>
         *                  <ul>
         *                  <li>1000 for {&#64;link DynamoEventSource}</li>
         *                  <li>10000 for {&#64;link KinesisEventSource}</li>
         *                  </ul></li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getBisectBatchOnError}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnError(java.lang.Boolean bisectBatchOnError) {
            this.bisectBatchOnError = bisectBatchOnError;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getEnabled}
         * @param enabled If the stream event source mapping should be enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getMaxBatchingWindow}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function.
         *                          Maximum of Duration.minutes(5)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getMaxRecordAge}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing.
         *                     Valid Range:
         *                     <p>
         *                     <ul>
         *                     <li>Minimum value of 60 seconds</li>
         *                     <li>Maximum value of 7 days</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRecordAge(software.amazon.awscdk.core.Duration maxRecordAge) {
            this.maxRecordAge = maxRecordAge;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getOnFailure}
         * @param onFailure An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getParallelizationFactor}
         * @param parallelizationFactor The number of batches to process from each shard concurrently.
         *                              Valid Range:
         *                              <p>
         *                              <ul>
         *                              <li>Minimum value of 1</li>
         *                              <li>Maximum value of 10</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getReportBatchItemFailures}
         * @param reportBatchItemFailures Allow functions to return partially successful responses for a batch of records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportBatchItemFailures(java.lang.Boolean reportBatchItemFailures) {
            this.reportBatchItemFailures = reportBatchItemFailures;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getRetryAttempts}
         * @param retryAttempts Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link KafkaEventSourceProps#getTumblingWindow}
         * @param tumblingWindow The size of the tumbling windows to group records sent to DynamoDB or Kinesis Valid Range: 0 - 15 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tumblingWindow(software.amazon.awscdk.core.Duration tumblingWindow) {
            this.tumblingWindow = tumblingWindow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KafkaEventSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KafkaEventSourceProps build() {
            return new Jsii$Proxy(topic, secret, startingPosition, batchSize, bisectBatchOnError, enabled, maxBatchingWindow, maxRecordAge, onFailure, parallelizationFactor, reportBatchItemFailures, retryAttempts, tumblingWindow);
        }
    }

    /**
     * An implementation for {@link KafkaEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaEventSourceProps {
        private final java.lang.String topic;
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        private final java.lang.Number batchSize;
        private final java.lang.Boolean bisectBatchOnError;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.core.Duration maxBatchingWindow;
        private final software.amazon.awscdk.core.Duration maxRecordAge;
        private final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        private final java.lang.Number parallelizationFactor;
        private final java.lang.Boolean reportBatchItemFailures;
        private final java.lang.Number retryAttempts;
        private final software.amazon.awscdk.core.Duration tumblingWindow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.StartingPosition.class));
            this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.bisectBatchOnError = software.amazon.jsii.Kernel.get(this, "bisectBatchOnError", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maxBatchingWindow = software.amazon.jsii.Kernel.get(this, "maxBatchingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.maxRecordAge = software.amazon.jsii.Kernel.get(this, "maxRecordAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IEventSourceDlq.class));
            this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.reportBatchItemFailures = software.amazon.jsii.Kernel.get(this, "reportBatchItemFailures", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tumblingWindow = software.amazon.jsii.Kernel.get(this, "tumblingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String topic, final software.amazon.awscdk.services.secretsmanager.ISecret secret, final software.amazon.awscdk.services.lambda.StartingPosition startingPosition, final java.lang.Number batchSize, final java.lang.Boolean bisectBatchOnError, final java.lang.Boolean enabled, final software.amazon.awscdk.core.Duration maxBatchingWindow, final software.amazon.awscdk.core.Duration maxRecordAge, final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure, final java.lang.Number parallelizationFactor, final java.lang.Boolean reportBatchItemFailures, final java.lang.Number retryAttempts, final software.amazon.awscdk.core.Duration tumblingWindow) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.topic = java.util.Objects.requireNonNull(topic, "topic is required");
            this.secret = secret;
            this.startingPosition = java.util.Objects.requireNonNull(startingPosition, "startingPosition is required");
            this.batchSize = batchSize;
            this.bisectBatchOnError = bisectBatchOnError;
            this.enabled = enabled;
            this.maxBatchingWindow = maxBatchingWindow;
            this.maxRecordAge = maxRecordAge;
            this.onFailure = onFailure;
            this.parallelizationFactor = parallelizationFactor;
            this.reportBatchItemFailures = reportBatchItemFailures;
            this.retryAttempts = retryAttempts;
            this.tumblingWindow = tumblingWindow;
        }

        @Override
        public final java.lang.String getTopic() {
            return this.topic;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public final java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final java.lang.Boolean getBisectBatchOnError() {
            return this.bisectBatchOnError;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxBatchingWindow() {
            return this.maxBatchingWindow;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxRecordAge() {
            return this.maxRecordAge;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IEventSourceDlq getOnFailure() {
            return this.onFailure;
        }

        @Override
        public final java.lang.Number getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @Override
        public final java.lang.Boolean getReportBatchItemFailures() {
            return this.reportBatchItemFailures;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTumblingWindow() {
            return this.tumblingWindow;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("topic", om.valueToTree(this.getTopic()));
            if (this.getSecret() != null) {
                data.set("secret", om.valueToTree(this.getSecret()));
            }
            data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getBisectBatchOnError() != null) {
                data.set("bisectBatchOnError", om.valueToTree(this.getBisectBatchOnError()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getMaxBatchingWindow() != null) {
                data.set("maxBatchingWindow", om.valueToTree(this.getMaxBatchingWindow()));
            }
            if (this.getMaxRecordAge() != null) {
                data.set("maxRecordAge", om.valueToTree(this.getMaxRecordAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getParallelizationFactor() != null) {
                data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
            }
            if (this.getReportBatchItemFailures() != null) {
                data.set("reportBatchItemFailures", om.valueToTree(this.getReportBatchItemFailures()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getTumblingWindow() != null) {
                data.set("tumblingWindow", om.valueToTree(this.getTumblingWindow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-event-sources.KafkaEventSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KafkaEventSourceProps.Jsii$Proxy that = (KafkaEventSourceProps.Jsii$Proxy) o;

            if (!topic.equals(that.topic)) return false;
            if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) return false;
            if (!startingPosition.equals(that.startingPosition)) return false;
            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            if (this.bisectBatchOnError != null ? !this.bisectBatchOnError.equals(that.bisectBatchOnError) : that.bisectBatchOnError != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.maxBatchingWindow != null ? !this.maxBatchingWindow.equals(that.maxBatchingWindow) : that.maxBatchingWindow != null) return false;
            if (this.maxRecordAge != null ? !this.maxRecordAge.equals(that.maxRecordAge) : that.maxRecordAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.parallelizationFactor != null ? !this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor != null) return false;
            if (this.reportBatchItemFailures != null ? !this.reportBatchItemFailures.equals(that.reportBatchItemFailures) : that.reportBatchItemFailures != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            return this.tumblingWindow != null ? this.tumblingWindow.equals(that.tumblingWindow) : that.tumblingWindow == null;
        }

        @Override
        public final int hashCode() {
            int result = this.topic.hashCode();
            result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
            result = 31 * result + (this.startingPosition.hashCode());
            result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
            result = 31 * result + (this.bisectBatchOnError != null ? this.bisectBatchOnError.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.maxBatchingWindow != null ? this.maxBatchingWindow.hashCode() : 0);
            result = 31 * result + (this.maxRecordAge != null ? this.maxRecordAge.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
            result = 31 * result + (this.reportBatchItemFailures != null ? this.reportBatchItemFailures.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.tumblingWindow != null ? this.tumblingWindow.hashCode() : 0);
            return result;
        }
    }
}
