package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesis.*;
 * import software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource;
 * Function myFunction;
 * Stream stream = new Stream(this, "MyStream");
 * myFunction.addEventSource(KinesisEventSource.Builder.create(stream)
 *         .batchSize(100) // default
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-01T02:29:06.761Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.eventsources.$Module.class, fqn = "@aws-cdk/aws-lambda-event-sources.KinesisEventSourceProps")
@software.amazon.jsii.Jsii.Proxy(KinesisEventSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KinesisEventSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.eventsources.StreamEventSourceProps {

    /**
     * @return a {@link Builder} of {@link KinesisEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KinesisEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KinesisEventSourceProps> {
        java.lang.Boolean bisectBatchOnError;
        software.amazon.awscdk.core.Duration maxRecordAge;
        java.lang.Number parallelizationFactor;
        java.lang.Boolean reportBatchItemFailures;
        java.lang.Number retryAttempts;
        software.amazon.awscdk.core.Duration tumblingWindow;
        software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        java.lang.Number batchSize;
        java.lang.Boolean enabled;
        software.amazon.awscdk.core.Duration maxBatchingWindow;
        software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;

        /**
         * Sets the value of {@link KinesisEventSourceProps#getBisectBatchOnError}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnError(java.lang.Boolean bisectBatchOnError) {
            this.bisectBatchOnError = bisectBatchOnError;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getMaxRecordAge}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing.
         *                     Valid Range:
         *                     <p>
         *                     <ul>
         *                     <li>Minimum value of 60 seconds</li>
         *                     <li>Maximum value of 7 days</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRecordAge(software.amazon.awscdk.core.Duration maxRecordAge) {
            this.maxRecordAge = maxRecordAge;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getParallelizationFactor}
         * @param parallelizationFactor The number of batches to process from each shard concurrently.
         *                              Valid Range:
         *                              <p>
         *                              <ul>
         *                              <li>Minimum value of 1</li>
         *                              <li>Maximum value of 10</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getReportBatchItemFailures}
         * @param reportBatchItemFailures Allow functions to return partially successful responses for a batch of records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportBatchItemFailures(java.lang.Boolean reportBatchItemFailures) {
            this.reportBatchItemFailures = reportBatchItemFailures;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getRetryAttempts}
         * @param retryAttempts Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getTumblingWindow}
         * @param tumblingWindow The size of the tumbling windows to group records sent to DynamoDB or Kinesis Valid Range: 0 - 15 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tumblingWindow(software.amazon.awscdk.core.Duration tumblingWindow) {
            this.tumblingWindow = tumblingWindow;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getStartingPosition}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getBatchSize}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         *                  Your function receives an
         *                  event with all the retrieved records.
         *                  <p>
         *                  Valid Range:
         *                  <p>
         *                  <ul>
         *                  <li>Minimum value of 1</li>
         *                  <li>Maximum value of:
         *                  <p>
         *                  <ul>
         *                  <li>1000 for {&#64;link DynamoEventSource}</li>
         *                  <li>10000 for {&#64;link KinesisEventSource}, {&#64;link ManagedKafkaEventSource} and {&#64;link SelfManagedKafkaEventSource}</li>
         *                  </ul></li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getEnabled}
         * @param enabled If the stream event source mapping should be enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getMaxBatchingWindow}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function.
         *                          Maximum of Duration.minutes(5)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getOnFailure}
         * @param onFailure An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KinesisEventSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KinesisEventSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KinesisEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisEventSourceProps {
        private final java.lang.Boolean bisectBatchOnError;
        private final software.amazon.awscdk.core.Duration maxRecordAge;
        private final java.lang.Number parallelizationFactor;
        private final java.lang.Boolean reportBatchItemFailures;
        private final java.lang.Number retryAttempts;
        private final software.amazon.awscdk.core.Duration tumblingWindow;
        private final software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        private final java.lang.Number batchSize;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.core.Duration maxBatchingWindow;
        private final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bisectBatchOnError = software.amazon.jsii.Kernel.get(this, "bisectBatchOnError", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maxRecordAge = software.amazon.jsii.Kernel.get(this, "maxRecordAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.reportBatchItemFailures = software.amazon.jsii.Kernel.get(this, "reportBatchItemFailures", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tumblingWindow = software.amazon.jsii.Kernel.get(this, "tumblingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.StartingPosition.class));
            this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maxBatchingWindow = software.amazon.jsii.Kernel.get(this, "maxBatchingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IEventSourceDlq.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bisectBatchOnError = builder.bisectBatchOnError;
            this.maxRecordAge = builder.maxRecordAge;
            this.parallelizationFactor = builder.parallelizationFactor;
            this.reportBatchItemFailures = builder.reportBatchItemFailures;
            this.retryAttempts = builder.retryAttempts;
            this.tumblingWindow = builder.tumblingWindow;
            this.startingPosition = java.util.Objects.requireNonNull(builder.startingPosition, "startingPosition is required");
            this.batchSize = builder.batchSize;
            this.enabled = builder.enabled;
            this.maxBatchingWindow = builder.maxBatchingWindow;
            this.onFailure = builder.onFailure;
        }

        @Override
        public final java.lang.Boolean getBisectBatchOnError() {
            return this.bisectBatchOnError;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxRecordAge() {
            return this.maxRecordAge;
        }

        @Override
        public final java.lang.Number getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @Override
        public final java.lang.Boolean getReportBatchItemFailures() {
            return this.reportBatchItemFailures;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTumblingWindow() {
            return this.tumblingWindow;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public final java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxBatchingWindow() {
            return this.maxBatchingWindow;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IEventSourceDlq getOnFailure() {
            return this.onFailure;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBisectBatchOnError() != null) {
                data.set("bisectBatchOnError", om.valueToTree(this.getBisectBatchOnError()));
            }
            if (this.getMaxRecordAge() != null) {
                data.set("maxRecordAge", om.valueToTree(this.getMaxRecordAge()));
            }
            if (this.getParallelizationFactor() != null) {
                data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
            }
            if (this.getReportBatchItemFailures() != null) {
                data.set("reportBatchItemFailures", om.valueToTree(this.getReportBatchItemFailures()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getTumblingWindow() != null) {
                data.set("tumblingWindow", om.valueToTree(this.getTumblingWindow()));
            }
            data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getMaxBatchingWindow() != null) {
                data.set("maxBatchingWindow", om.valueToTree(this.getMaxBatchingWindow()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-event-sources.KinesisEventSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KinesisEventSourceProps.Jsii$Proxy that = (KinesisEventSourceProps.Jsii$Proxy) o;

            if (this.bisectBatchOnError != null ? !this.bisectBatchOnError.equals(that.bisectBatchOnError) : that.bisectBatchOnError != null) return false;
            if (this.maxRecordAge != null ? !this.maxRecordAge.equals(that.maxRecordAge) : that.maxRecordAge != null) return false;
            if (this.parallelizationFactor != null ? !this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor != null) return false;
            if (this.reportBatchItemFailures != null ? !this.reportBatchItemFailures.equals(that.reportBatchItemFailures) : that.reportBatchItemFailures != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            if (this.tumblingWindow != null ? !this.tumblingWindow.equals(that.tumblingWindow) : that.tumblingWindow != null) return false;
            if (!startingPosition.equals(that.startingPosition)) return false;
            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.maxBatchingWindow != null ? !this.maxBatchingWindow.equals(that.maxBatchingWindow) : that.maxBatchingWindow != null) return false;
            return this.onFailure != null ? this.onFailure.equals(that.onFailure) : that.onFailure == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bisectBatchOnError != null ? this.bisectBatchOnError.hashCode() : 0;
            result = 31 * result + (this.maxRecordAge != null ? this.maxRecordAge.hashCode() : 0);
            result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
            result = 31 * result + (this.reportBatchItemFailures != null ? this.reportBatchItemFailures.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.tumblingWindow != null ? this.tumblingWindow.hashCode() : 0);
            result = 31 * result + (this.startingPosition.hashCode());
            result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.maxBatchingWindow != null ? this.maxBatchingWindow.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            return result;
        }
    }
}
