package software.amazon.awscdk.services.lambda.eventsources;

/**
 * An SNS dead letter queue destination configuration for a Lambda event source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.eventsources.*;
 * import software.amazon.awscdk.services.sns.*;
 * Topic topic;
 * SnsDlq snsDlq = new SnsDlq(topic);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-01T02:29:06.770Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.eventsources.$Module.class, fqn = "@aws-cdk/aws-lambda-event-sources.SnsDlq")
public class SnsDlq extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IEventSourceDlq {

    protected SnsDlq(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SnsDlq(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SnsDlq(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * Returns a destination configuration for the DLQ.
     * <p>
     * @param _target This parameter is required.
     * @param targetHandler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DlqDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSourceMapping _target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction targetHandler) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DlqDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_target, "_target is required"), java.util.Objects.requireNonNull(targetHandler, "targetHandler is required") });
    }
}
