/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import java.util.Objects;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.dynamodb.Table;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.StartingPosition;
import software.amazon.awscdk.services.lambda.eventsources.;
import software.amazon.awscdk.services.lambda.eventsources.DynamoEventSourceProps;
import software.amazon.awscdk.services.lambda.eventsources.StreamEventSource;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda-event-sources.DynamoEventSource")
public class DynamoEventSource
extends StreamEventSource {
    protected DynamoEventSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DynamoEventSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DynamoEventSource(Table table, DynamoEventSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(table, "table is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void bind(IFunction target) {
        this.jsiiCall("bind", Void.class, new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    public static final class Builder {
        private final Table table;
        private final DynamoEventSourceProps.Builder props;

        public static Builder create(Table table) {
            return new Builder(table);
        }

        private Builder(Table table) {
            this.table = table;
            this.props = new DynamoEventSourceProps.Builder();
        }

        public Builder startingPosition(StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        public Builder batchSize(Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        public Builder maxBatchingWindow(Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        public DynamoEventSource build() {
            return new DynamoEventSource(this.table, this.props.build());
        }
    }
}

