/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import java.util.Objects;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.StartingPosition;
import software.amazon.awscdk.services.lambda.eventsources.;
import software.amazon.awscdk.services.lambda.eventsources.KinesisEventSourceProps;
import software.amazon.awscdk.services.lambda.eventsources.StreamEventSource;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda-event-sources.KinesisEventSource")
public class KinesisEventSource
extends StreamEventSource {
    protected KinesisEventSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisEventSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public KinesisEventSource(IStream stream, KinesisEventSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(stream, "stream is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void bind(IFunction target) {
        this.jsiiCall("bind", Void.class, new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    public IStream getStream() {
        return (IStream)this.jsiiGet("stream", IStream.class);
    }

    public static final class Builder {
        private final IStream stream;
        private final KinesisEventSourceProps.Builder props;

        public static Builder create(IStream stream) {
            return new Builder(stream);
        }

        private Builder(IStream stream) {
            this.stream = stream;
            this.props = new KinesisEventSourceProps.Builder();
        }

        public Builder startingPosition(StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        public Builder batchSize(Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        public Builder maxBatchingWindow(Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        public KinesisEventSource build() {
            return new KinesisEventSource(this.stream, this.props.build());
        }
    }
}

